/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.external.BaseExternalTool;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

class ExtCompareFiles
extends BaseExternalTool {
    public static final BaseExternalTool INSTANCE = new ExtCompareFiles();

    private ExtCompareFiles() {
        super(DiffManagerImpl.ENABLE_FILES, DiffManagerImpl.FILES_TOOL);
    }

    @Override
    public boolean canShow(DiffRequest request) {
        DiffContent[] contents = request.getContents();
        for (int i = 0; i < contents.length; ++i) {
            DiffContent content = contents[i];
            VirtualFile file = ExtCompareFiles.getLocalFile(content.getFile());
            if (file != null && file.isDirectory()) {
                return false;
            }
            if (this.canExternalizeAsFile(file) || !DiffUtil.isWritable(content)) continue;
            return false;
        }
        return super.canShow(request);
    }

    @Override
    protected BaseExternalTool.ContentExternalizer externalize(DiffRequest request, int index) {
        VirtualFile file = ExtCompareFiles.getLocalFile(request.getContents()[index].getFile());
        if (this.canExternalizeAsFile(file)) {
            return BaseExternalTool.LocalFileExternalizer.tryCreate(file);
        }
        return new MyContentExternalizer(request, index);
    }

    private boolean canExternalizeAsFile(VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
        return !fileType.isBinary() || fileType == FileTypes.UNKNOWN;
    }

    private static class MyContentExternalizer
    implements BaseExternalTool.ContentExternalizer {
        private final DiffRequest myRequest;
        private final int myIndex;
        @NonNls
        public static final String STD_PREFIX = "IJDiff";

        public MyContentExternalizer(DiffRequest request, int index) {
            this.myRequest = request;
            this.myIndex = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File getContentFile() throws IOException {
            File tempFile;
            String extension = this.chooseExtension();
            String name = this.chooseName();
            if (name.length() <= 3) {
                name = "___" + name;
            }
            try {
                tempFile = File.createTempFile(name, extension);
            }
            catch (IOException e) {
                tempFile = File.createTempFile(STD_PREFIX, extension);
            }
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(tempFile);
                stream.write(this.getContent().getBytes());
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return tempFile;
        }

        private String chooseName() {
            String title = this.myRequest.getContentTitles()[this.myIndex];
            char[] chars = title.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char aChar = chars[i];
                if (Character.isLetterOrDigit(aChar)) continue;
                chars[i] = 95;
            }
            return new String(chars);
        }

        private String chooseExtension() {
            String extension;
            DiffContent content = this.getContent();
            VirtualFile contentFile = content.getFile();
            if (contentFile != null) {
                extension = "." + contentFile.getExtension();
            } else {
                FileType contentType = content.getContentType();
                if (contentType == null) {
                    contentType = DiffUtil.chooseContentTypes(this.myRequest.getContents())[this.myIndex];
                }
                extension = contentType != null ? "." + contentType.getDefaultExtension() : null;
            }
            return extension;
        }

        private DiffContent getContent() {
            return this.myRequest.getContents()[this.myIndex];
        }
    }
}

