/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PairConsumer;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class DirectoryBasedStorage
implements StateStorage,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DirectoryBasedStorage");
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final IFile myDir;
    private final StateSplitter mySplitter;
    private Object mySession;
    private MyStorageData myStorageData = null;
    @NonNls
    private static final String COMPONENT = "component";
    @NonNls
    private static final String NAME = "name";
    private static final IFile[] EMPTY_FILES = new IFile[0];
    private final FileTypeManager myFileTypeManager;

    public DirectoryBasedStorage(TrackingPathMacroSubstitutor pathMacroSubstitutor, String dir, StateSplitter splitter, Disposable parentDisposable, PicoContainer picoContainer) {
        assert (dir.indexOf("$") < 0);
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        this.myDir = FileSystem.FILE_SYSTEM.createFile(dir);
        this.mySplitter = splitter;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)picoContainer.getComponentInstanceOfType(VirtualFileTracker.class);
        MessageBus messageBus = (MessageBus)picoContainer.getComponentInstanceOfType(MessageBus.class);
        if (virtualFileTracker != null && messageBus != null) {
            String path = this.myDir.getAbsolutePath();
            String fileUrl = "file://" + path.replace(File.separatorChar, '/');
            final StateStorage.Listener listener = (StateStorage.Listener)messageBus.syncPublisher(STORAGE_TOPIC);
            virtualFileTracker.addTracker(fileUrl, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(VirtualFileEvent event) {
                    if (!StringUtil.endsWithIgnoreCase((String)event.getFile().getName(), (String)".xml")) {
                        return;
                    }
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }

                public void fileDeleted(VirtualFileEvent event) {
                    if (!StringUtil.endsWithIgnoreCase((String)event.getFile().getName(), (String)".xml")) {
                        return;
                    }
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }

                public void fileCreated(VirtualFileEvent event) {
                    if (!StringUtil.endsWithIgnoreCase((String)event.getFile().getName(), (String)".xml")) {
                        return;
                    }
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }
            }, false, (Disposable)this);
        }
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    @Nullable
    public <T> T getState(Object component, String componentName, Class<T> stateClass, @Nullable T mergeInto) throws StateStorage.StateStorageException {
        if (this.myStorageData == null) {
            this.myStorageData = this.loadState();
        }
        if (!this.myStorageData.containsComponent(componentName)) {
            return DefaultStateSerializer.deserializeState(new Element(COMPONENT), stateClass, mergeInto);
        }
        final ArrayList subElements = new ArrayList();
        this.myStorageData.processComponent(componentName, new PairConsumer<IFile, Element>(){

            public void consume(IFile iFile, Element element) {
                List children = element.getChildren();
                assert (children.size() == 1);
                Element subElement = (Element)children.get(0);
                subElement.detach();
                subElements.add(subElement);
            }
        });
        Element state = new Element(COMPONENT);
        this.mySplitter.mergeStatesInto(state, subElements.toArray(new Element[subElements.size()]));
        this.myStorageData.removeComponent(componentName);
        return DefaultStateSerializer.deserializeState(state, stateClass, mergeInto);
    }

    private MyStorageData loadState() throws StateStorage.StateStorageException {
        IFile[] files;
        MyStorageData storageData = new MyStorageData();
        if (!this.myDir.exists()) {
            return storageData;
        }
        for (IFile file : files = this.myDir.listFiles()) {
            if (!StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".xml")) continue;
            try {
                Document document = JDOMUtil.loadDocument((IFile)file);
                Element element = document.getRootElement();
                assert (element.getName().equals(COMPONENT));
                String componentName = element.getAttributeValue(NAME);
                assert (componentName != null);
                if (this.myPathMacroSubstitutor != null) {
                    this.myPathMacroSubstitutor.expandPaths(element);
                    Set<String> unknownMacros = StorageUtil.getMacroNames(element);
                    this.myPathMacroSubstitutor.addUnknownMacros(componentName, unknownMacros);
                }
                storageData.put(componentName, file, element, true);
            }
            catch (IOException e) {
                LOG.info("Unable to load state", (Throwable)e);
            }
            catch (JDOMException e) {
                LOG.info("Unable to load state", (Throwable)e);
            }
        }
        return storageData;
    }

    public boolean hasState(Object component, String componentName, Class<?> aClass, boolean reloadData) throws StateStorage.StateStorageException {
        if (!this.myDir.exists()) {
            return false;
        }
        if (reloadData) {
            this.myStorageData = null;
        }
        return true;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        if (this.myStorageData == null) {
            try {
                this.myStorageData = this.loadState();
            }
            catch (StateStorage.StateStorageException e) {
                LOG.error((Throwable)e);
            }
        }
        MyExternalizationSession session = new MyExternalizationSession(this.myPathMacroSubstitutor, this.myStorageData.clone());
        this.mySession = session;
        MyExternalizationSession myExternalizationSession = session;
        if (myExternalizationSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/DirectoryBasedStorage.startExternalization must not return null");
        }
        return myExternalizationSession;
    }

    @NotNull
    public StateStorage.SaveSession startSave(StateStorage.ExternalizationSession externalizationSession) {
        assert (this.mySession == externalizationSession);
        MySaveSession session = new MySaveSession(((MyExternalizationSession)externalizationSession).myStorageData, this.myPathMacroSubstitutor);
        this.mySession = session;
        MySaveSession mySaveSession = session;
        if (mySaveSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/DirectoryBasedStorage.startSave must not return null");
        }
        return mySaveSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSave(StateStorage.SaveSession saveSession) {
        try {
            LOG.assertTrue(this.mySession == saveSession);
        }
        finally {
            this.mySession = null;
        }
    }

    public void reload(Set<String> changedComponents) throws StateStorage.StateStorageException {
        this.myStorageData = this.loadState();
    }

    public void dispose() {
    }

    private class MyExternalizationSession
    implements StateStorage.ExternalizationSession {
        private final MyStorageData myStorageData;

        private MyExternalizationSession(TrackingPathMacroSubstitutor pathMacroSubstitutor, MyStorageData storageData) {
            this.myStorageData = storageData;
        }

        public void setState(Object component, String componentName, Object state, Storage storageSpec) throws StateStorage.StateStorageException {
            assert (DirectoryBasedStorage.this.mySession == this);
            this.setState(componentName, state, storageSpec);
        }

        private void setState(String componentName, Object state, Storage storageSpec) throws StateStorage.StateStorageException {
            try {
                Element element = DefaultStateSerializer.serializeState(state, storageSpec);
                List states = DirectoryBasedStorage.this.mySplitter.splitState(element);
                for (Pair pair : states) {
                    Element e = (Element)pair.first;
                    String name = (String)pair.second;
                    Element statePart = new Element(DirectoryBasedStorage.COMPONENT);
                    statePart.setAttribute(DirectoryBasedStorage.NAME, componentName);
                    e.detach();
                    statePart.addContent(e);
                    this.myStorageData.put(componentName, DirectoryBasedStorage.this.myDir.getChild(name), statePart, false);
                }
            }
            catch (WriteExternalException e) {
                throw new StateStorage.StateStorageException((Throwable)e);
            }
        }
    }

    private static class MyStorageData {
        private Map<String, Map<IFile, Element>> myStates = new HashMap<String, Map<IFile, Element>>();
        private long myLastTimestamp = 0L;
        private MyStorageData myOriginalData;

        private MyStorageData() {
        }

        public Set<String> getComponentNames() {
            return this.myStates.keySet();
        }

        public void put(String componentName, IFile file, Element element, boolean updateTimestamp) {
            LOG.assertTrue(componentName != null, (Object)String.format("Component name should not be null for file: %s", file == null ? "NULL!" : file.getPath()));
            Map<IFile, Element> stateMap = this.myStates.get(componentName);
            if (stateMap == null) {
                stateMap = new HashMap<IFile, Element>();
                this.myStates.put(componentName, stateMap);
            }
            stateMap.put(file, element);
            if (updateTimestamp) {
                this.updateLastTimestamp(file);
            }
        }

        public void updateLastTimestamp(IFile file) {
            this.myLastTimestamp = Math.max(this.myLastTimestamp, file.getTimeStamp());
            if (this.myOriginalData != null) {
                this.myOriginalData.myLastTimestamp = this.myLastTimestamp;
            }
        }

        public long getLastTimeStamp() {
            return this.myLastTimestamp;
        }

        public Map<IFile, Long> getAllStorageFiles() {
            THashMap allStorageFiles = new THashMap();
            this.process(new StorageDataProcessor((Map)allStorageFiles){
                final /* synthetic */ Map val$allStorageFiles;
                {
                    this.val$allStorageFiles = map;
                }

                @Override
                public void process(String componentName, IFile file, Element element) {
                    this.val$allStorageFiles.put(file, file.getTimeStamp());
                }
            });
            return allStorageFiles;
        }

        public void processComponent(@NotNull String componentName, @NotNull PairConsumer<IFile, Element> consumer) {
            if (componentName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyStorageData.processComponent must not be null");
            }
            if (consumer == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyStorageData.processComponent must not be null");
            }
            Map<IFile, Element> map = this.myStates.get(componentName);
            if (map != null) {
                for (IFile file : map.keySet()) {
                    consumer.consume((Object)file, (Object)map.get(file));
                }
            }
        }

        public void process(final @NotNull StorageDataProcessor processor) {
            if (processor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyStorageData.process must not be null");
            }
            for (final String componentName : this.myStates.keySet()) {
                this.processComponent(componentName, new PairConsumer<IFile, Element>(){

                    public void consume(IFile iFile, Element element) {
                        processor.process(componentName, iFile, element);
                    }
                });
            }
        }

        protected MyStorageData clone() {
            MyStorageData result = new MyStorageData();
            result.myStates = new HashMap<String, Map<IFile, Element>>(this.myStates);
            result.myLastTimestamp = this.myLastTimestamp;
            result.myOriginalData = this;
            return result;
        }

        public void clear() {
            this.myStates.clear();
            this.myOriginalData = null;
        }

        public boolean containsComponent(String componentName) {
            return this.myStates.get(componentName) != null;
        }

        public void removeComponent(String componentName) {
            this.myStates.remove(componentName);
        }
    }

    private static interface StorageDataProcessor {
        public void process(String var1, IFile var2, Element var3);
    }

    private class MySaveSession
    implements StateStorage.SaveSession {
        private final MyStorageData myStorageData;
        private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

        private MySaveSession(MyStorageData storageData, TrackingPathMacroSubstitutor pathMacroSubstitutor) {
            this.myStorageData = storageData;
            this.myPathMacroSubstitutor = pathMacroSubstitutor;
        }

        public void save() throws StateStorage.StateStorageException {
            IFile[] children;
            assert (DirectoryBasedStorage.this.mySession == this);
            final HashSet<String> currentNames = new HashSet<String>();
            for (IFile child : children = DirectoryBasedStorage.this.myDir.exists() ? DirectoryBasedStorage.this.myDir.listFiles() : EMPTY_FILES) {
                String fileName = child.getName();
                if (DirectoryBasedStorage.this.myFileTypeManager.isFileIgnored(fileName) || !StringUtil.endsWithIgnoreCase((String)fileName, (String)".xml")) continue;
                currentNames.add(fileName);
            }
            this.myStorageData.process(new StorageDataProcessor(){

                @Override
                public void process(String componentName, IFile file, Element element) {
                    currentNames.remove(file.getName());
                    if (MySaveSession.this.myPathMacroSubstitutor != null) {
                        MySaveSession.this.myPathMacroSubstitutor.collapsePaths(element);
                    }
                    if (file.getTimeStamp() <= MySaveSession.this.myStorageData.getLastTimeStamp()) {
                        if (!DirectoryBasedStorage.this.myDir.exists()) {
                            DirectoryBasedStorage.this.myDir.createParentDirs();
                            DirectoryBasedStorage.this.myDir.mkDir();
                        }
                        StorageUtil.save(file, (Parent)element, MySaveSession.this);
                        MySaveSession.this.myStorageData.updateLastTimestamp(file);
                    }
                }
            });
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    if (DirectoryBasedStorage.this.myDir.exists()) {
                        for (String name : currentNames) {
                            IFile child = DirectoryBasedStorage.this.myDir.getChild(name);
                            if (child.getTimeStamp() > MySaveSession.this.myStorageData.getLastTimeStamp()) {
                                return;
                            }
                            VirtualFile virtualFile = StorageUtil.getVirtualFile(child);
                            if (virtualFile == null) continue;
                            try {
                                LOG.debug("Removing configuration file: " + virtualFile.getPresentableUrl());
                                virtualFile.delete((Object)MySaveSession.this);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                }
            });
            this.myStorageData.clear();
        }

        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            boolean containsSelf = false;
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                VirtualFile file;
                if (pair.second != DirectoryBasedStorage.this || !"xml".equalsIgnoreCase((file = (VirtualFile)pair.first).getExtension())) continue;
                containsSelf = true;
                break;
            }
            if (!containsSelf) {
                return Collections.emptySet();
            }
            if (this.myStorageData.getComponentNames().size() == 0) {
                MyStorageData storageData = DirectoryBasedStorage.this.loadState();
                return new HashSet<String>(storageData.getComponentNames());
            }
            return new HashSet<String>(this.myStorageData.getComponentNames());
        }

        public Collection<IFile> getStorageFilesToSave() throws StateStorage.StateStorageException {
            assert (DirectoryBasedStorage.this.mySession == this);
            if (!DirectoryBasedStorage.this.myDir.exists()) {
                return this.getAllStorageFiles();
            }
            assert (DirectoryBasedStorage.this.myDir.isDirectory());
            final ArrayList<IFile> filesToSave = new ArrayList<IFile>();
            IFile[] children = DirectoryBasedStorage.this.myDir.listFiles();
            final HashSet<String> currentChildNames = new HashSet<String>();
            for (IFile child : children) {
                if (DirectoryBasedStorage.this.myFileTypeManager.isFileIgnored(child.getName())) continue;
                currentChildNames.add(child.getName());
            }
            this.myStorageData.process(new StorageDataProcessor(){

                @Override
                public void process(String componentName, IFile file, Element element) {
                    if (currentChildNames.contains(file.getName())) {
                        currentChildNames.remove(file.getName());
                        if (MySaveSession.this.myPathMacroSubstitutor != null) {
                            MySaveSession.this.myPathMacroSubstitutor.collapsePaths(element);
                        }
                        if (!StorageUtil.contentEquals(element, file)) {
                            filesToSave.add(file);
                        }
                    }
                }
            });
            for (String childName : currentChildNames) {
                IFile child = DirectoryBasedStorage.this.myDir.getChild(childName);
                filesToSave.add(child);
            }
            return filesToSave;
        }

        public List<IFile> getAllStorageFiles() {
            return new ArrayList<IFile>(this.myStorageData.getAllStorageFiles().keySet());
        }
    }
}

