/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final Object LOCK = new Object();
    private static final IdeEventQueue ourEventQueue = IdeEventQueue.getInstance();
    private static final List<Object> ourModalEntities = new CopyOnWriteArrayList<Object>();
    private static final List<RunnableInfo> ourQueue = new ArrayList<RunnableInfo>();
    private static volatile int ourQueueSkipCount = 0;
    private static final Runnable ourFlushQueueRunnable = new FlushQueue();
    private static final Stack<AWTEvent> ourEventStack = new Stack();
    static boolean IS_TEST_MODE = false;
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final ArrayList<RunnableInfo> ourForcedFlushQueue = new ArrayList();
    private static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);
    private static final Object RUN_LOCK = new Object();

    private LaterInvocator() {
    }

    public static void addModalityStateListener(ModalityStateListener listener) {
        ourModalityStateMulticaster.addListener((EventListener)listener);
    }

    public static void removeModalityStateListener(ModalityStateListener listener) {
        ourModalityStateMulticaster.removeListener((EventListener)listener);
    }

    static ModalityStateEx modalityStateForWindow(Window window) {
        int index = ourModalEntities.indexOf(window);
        if (index < 0) {
            Window owner = window.getOwner();
            if (owner == null) {
                return (ModalityStateEx)ApplicationManager.getApplication().getNoneModalityState();
            }
            ModalityStateEx ownerState = LaterInvocator.modalityStateForWindow(owner);
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return ownerState.appendEntity(window);
            }
            return ownerState;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object entity : ourModalEntities) {
            if (entity instanceof Window) {
                result.add(entity);
                continue;
            }
            if (!(entity instanceof ProgressIndicator) || !((ProgressIndicator)entity).isModal()) continue;
            result.add(entity);
        }
        return new ModalityStateEx(result.toArray());
    }

    public static ActionCallback invokeLater(Runnable runnable) {
        return LaterInvocator.invokeLater(runnable, Conditions.FALSE);
    }

    public static ActionCallback invokeLater(Runnable runnable, @NotNull Condition expired) {
        if (expired == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator.invokeLater must not be null");
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        return LaterInvocator.invokeLater(runnable, modalityState, (Condition<Object>)expired);
    }

    public static ActionCallback invokeLater(Runnable runnable, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator.invokeLater must not be null");
        }
        return LaterInvocator.invokeLater(runnable, modalityState, (Condition<Object>)Conditions.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionCallback invokeLater(Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<Object> expired) {
        if (modalityState == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator.invokeLater must not be null");
        }
        if (expired == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator.invokeLater must not be null");
        }
        ActionCallback callback = new ActionCallback();
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(new RunnableInfo(runnable, modalityState, expired, callback));
        }
        LaterInvocator.requestFlush();
        return callback;
    }

    public static void invokeAndWait(final Runnable runnable, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator.invokeAndWait must not be null");
        }
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        Runnable runnable1 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable.toString() + "]";
            }
        };
        LaterInvocator.invokeLater(runnable1, modalityState);
        semaphore.waitFor();
    }

    public static void enterModal(Object modalEntity) {
        if (!IS_TEST_MODE) {
            LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        if (!IS_TEST_MODE) {
            ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        }
        ourModalEntities.add(modalEntity);
    }

    public static void leaveModal(Object modalEntity) {
        if (!IS_TEST_MODE) {
            LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        if (!IS_TEST_MODE) {
            ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        }
        boolean removed = ourModalEntities.remove(modalEntity);
        LOG.assertTrue(removed, modalEntity);
        LaterInvocator.cleanupQueueForModal(modalEntity);
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupQueueForModal(Object modalEntity) {
        Object object = LOCK;
        synchronized (object) {
            Iterator<RunnableInfo> iterator = ourQueue.iterator();
            while (iterator.hasNext()) {
                ModalityStateEx stateEx;
                RunnableInfo runnableInfo = iterator.next();
                if (!(runnableInfo.modalityState instanceof ModalityStateEx) || !(stateEx = (ModalityStateEx)runnableInfo.modalityState).contains(modalEntity)) continue;
                ourForcedFlushQueue.add(runnableInfo);
                iterator.remove();
            }
        }
    }

    static void leaveAllModals() {
        LOG.assertTrue(IS_TEST_MODE);
        ourModalEntities.clear();
        ourQueueSkipCount = 0;
        LaterInvocator.requestFlush();
    }

    public static Object[] getCurrentModalEntities() {
        if (!IS_TEST_MODE) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        return ArrayUtil.toObjectArray(ourModalEntities);
    }

    public static boolean isInModalContext() {
        if (!IS_TEST_MODE) {
            LOG.assertTrue(LaterInvocator.isDispatchThread());
        }
        return !ourModalEntities.isEmpty();
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo pollNext() {
        Object object = LOCK;
        synchronized (object) {
            if (!ourForcedFlushQueue.isEmpty()) {
                RunnableInfo toRun = ourForcedFlushQueue.get(0);
                ourForcedFlushQueue.remove(0);
                if (!toRun.expired.value(null)) {
                    return toRun;
                }
                toRun.callback.setDone();
            }
            ModalityStateEx currentModality = (ModalityStateEx)((Object)(ourModalEntities.isEmpty() ? ApplicationManager.getApplication().getNoneModalityState() : new ModalityStateEx(ourModalEntities.toArray())));
            while (ourQueueSkipCount < ourQueue.size()) {
                RunnableInfo info = ourQueue.get(ourQueueSkipCount);
                if (info.expired.value(null)) {
                    ourQueue.remove(ourQueueSkipCount);
                    info.callback.setDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    ourQueue.remove(ourQueueSkipCount);
                    return info;
                }
                ++ourQueueSkipCount;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> dumpQueue() {
        Object object = LOCK;
        synchronized (object) {
            if (!ourQueue.isEmpty()) {
                ArrayList<Object> r = new ArrayList<Object>();
                r.addAll(ourQueue);
                Collections.reverse(r);
                return r;
            }
        }
        return null;
    }

    static /* synthetic */ AtomicBoolean access$000() {
        return FLUSHER_SCHEDULED;
    }

    static /* synthetic */ RunnableInfo access$100() {
        return LaterInvocator.pollNext();
    }

    static /* synthetic */ Object access$200() {
        return RUN_LOCK;
    }

    static /* synthetic */ IdeEventQueue access$300() {
        return ourEventQueue;
    }

    static /* synthetic */ Stack access$400() {
        return ourEventStack;
    }

    static /* synthetic */ Logger access$500() {
        return LOG;
    }

    static /* synthetic */ boolean access$600() {
        return DEBUG;
    }

    static /* synthetic */ void access$700() {
        LaterInvocator.requestFlush();
    }

    static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        FlushQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block14: {
                LaterInvocator.access$000().set(false);
                this.myLastInfo = lastInfo = LaterInvocator.access$100();
                if (lastInfo == null) break block14;
                var2_2 = LaterInvocator.access$200();
                synchronized (var2_2) {
                    event = LaterInvocator.access$300().getTrueCurrentEvent();
                    LaterInvocator.access$400().push(event);
                    stackSize = LaterInvocator.access$400().size();
                    try {
                        lastInfo.runnable.run();
                        lastInfo.callback.setDone();
                    }
                    catch (ProcessCanceledException ex) {
                        LaterInvocator.access$500().assertTrue(LaterInvocator.access$400().size() == stackSize);
                        LaterInvocator.access$400().pop();
                        if (!LaterInvocator.access$600()) {
                            this.myLastInfo = null;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof StackOverflowError) {
                            t.printStackTrace();
                        }
                        LaterInvocator.access$500().error(t);
                        {
                            catch (Throwable var6_7) {
                                LaterInvocator.access$500().assertTrue(LaterInvocator.access$400().size() == stackSize);
                                LaterInvocator.access$400().pop();
                                if (!LaterInvocator.access$600()) {
                                    this.myLastInfo = null;
                                }
                                throw var6_7;
                            }
                        }
                        LaterInvocator.access$500().assertTrue(LaterInvocator.access$400().size() == stackSize);
                        LaterInvocator.access$400().pop();
                        if (!LaterInvocator.access$600()) {
                            this.myLastInfo = null;
                        } else {
                            ** GOTO lbl49
                        }
                    }
                    LaterInvocator.access$500().assertTrue(LaterInvocator.access$400().size() == stackSize);
                    LaterInvocator.access$400().pop();
                    if (!LaterInvocator.access$600()) {
                        this.myLastInfo = null;
                    }
lbl49:
                    // 3 sources

                }
                LaterInvocator.access$700();
            }
        }

        @NonNls
        public String toString() {
            return "LaterInvocator[lastRunnable=" + this.myLastInfo + "]";
        }
    }

    private static class RunnableInfo {
        final Runnable runnable;
        final ModalityState modalityState;
        final Condition<Object> expired;
        final ActionCallback callback;

        public RunnableInfo(Runnable runnable, ModalityState modalityState, @NotNull Condition<Object> expired, @NotNull ActionCallback callback) {
            if (expired == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo.<init> must not be null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/application/impl/LaterInvocator$RunnableInfo.<init> must not be null");
            }
            this.runnable = runnable;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback;
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + "] ";
        }
    }
}

