/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class ActionButtonWithText
extends ActionButton {
    private static final int ICON_TEXT_SPACE = 2;

    public ActionButtonWithText(AnAction action, Presentation presentation, String place, Dimension minimumSize) {
        super(action, presentation, place, minimumSize);
        this.setFont(UIUtil.getLabelFont());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension(super.getPreferredSize());
        String text = this.getText();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        preferredSize.width += 2;
        preferredSize.width += fontMetrics.stringWidth(text);
        return preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        String text = this.getText();
        Icon icon = this.getIcon();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int x = (int)Math.ceil((this.getWidth() - icon.getIconWidth() - fontMetrics.stringWidth(text)) / 2);
        int y = (int)Math.ceil((this.getHeight() - icon.getIconHeight()) / 2);
        ActionButtonLook look = ActionButtonLook.IDEA_LOOK;
        look.paintBackground(g, this);
        look.paintIconAt(g, this, icon, x, y);
        look.paintBorder(g, this);
        int textHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        UIUtil.applyRenderingHints((Graphics)g);
        g.setColor(this.isButtonEnabled() ? UIUtil.getLabelForeground() : UIUtil.getTextInactiveTextColor());
        int iconTextDifference = (int)Math.ceil((icon.getIconHeight() - textHeight) / 2);
        int textStartX = x + icon.getIconWidth() + 2;
        g.drawString(text, textStartX, y + iconTextDifference + fontMetrics.getMaxAscent());
        int mnemonicIndex = this.getMnemonicCharIndex(text);
        if (mnemonicIndex >= 0) {
            char[] chars = text.toCharArray();
            int startX = textStartX + fontMetrics.charsWidth(chars, 0, mnemonicIndex);
            int startY = y + iconTextDifference + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int endX = startX + fontMetrics.charWidth(text.charAt(mnemonicIndex));
            UIUtil.drawLine((Graphics)g, (int)startX, (int)startY, (int)endX, (int)startY);
        }
    }

    private int getMnemonicCharIndex(String text) {
        ShortcutSet shortcutSet = this.myAction.getShortcutSet();
        Shortcut[] shortcuts = shortcutSet.getShortcuts();
        for (int i = 0; i < shortcuts.length; ++i) {
            KeyStroke keyStroke;
            int modifiers;
            KeyboardShortcut keyboardShortcut;
            Shortcut shortcut = shortcuts[i];
            if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null || ((modifiers = (keyStroke = keyboardShortcut.getFirstKeyStroke()).getModifiers()) & 8) == 0) continue;
            return keyStroke.getKeyChar() != '\uffff' ? text.indexOf(keyStroke.getKeyChar()) : text.indexOf(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        }
        return -1;
    }

    private String getText() {
        String text = this.myPresentation.getText();
        return text != null ? text : "";
    }
}

