/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.javadoc.JavadocConfiguration;
import com.intellij.javadoc.JavadocGenerationPanel;
import com.intellij.openapi.options.Configurable;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class JavadocConfigurable
implements Configurable {
    private JavadocGenerationPanel myPanel;
    private final JavadocConfiguration myConfiguration;

    public JavadocConfigurable(JavadocConfiguration configuration) {
        this.myConfiguration = configuration;
    }

    public JComponent createComponent() {
        this.myPanel = new JavadocGenerationPanel();
        return this.myPanel.myPanel;
    }

    public void applyTo(JavadocConfiguration configuration) {
        configuration.OUTPUT_DIRECTORY = JavadocConfigurable.toSystemIndependentFormat(this.myPanel.myTfOutputDir.getText());
        configuration.OTHER_OPTIONS = JavadocConfigurable.convertString(this.myPanel.myOtherOptionsField.getText());
        configuration.HEAP_SIZE = JavadocConfigurable.convertString(this.myPanel.myHeapSizeField.getText());
        configuration.LOCALE = JavadocConfigurable.convertString(this.myPanel.myLocaleTextField.getText());
        configuration.OPEN_IN_BROWSER = this.myPanel.myOpenInBrowserCheckBox.isSelected();
        configuration.OPTION_SCOPE = JavadocConfigurable.convertString(this.myPanel.getScope());
        configuration.OPTION_HIERARCHY = this.myPanel.myHierarchy.isSelected();
        configuration.OPTION_NAVIGATOR = this.myPanel.myNavigator.isSelected();
        configuration.OPTION_INDEX = this.myPanel.myIndex.isSelected();
        configuration.OPTION_SEPARATE_INDEX = this.myPanel.mySeparateIndex.isSelected();
        configuration.OPTION_DOCUMENT_TAG_USE = this.myPanel.myTagUse.isSelected();
        configuration.OPTION_DOCUMENT_TAG_AUTHOR = this.myPanel.myTagAuthor.isSelected();
        configuration.OPTION_DOCUMENT_TAG_VERSION = this.myPanel.myTagVersion.isSelected();
        configuration.OPTION_DOCUMENT_TAG_DEPRECATED = this.myPanel.myTagDeprecated.isSelected();
        configuration.OPTION_DEPRECATED_LIST = this.myPanel.myDeprecatedList.isSelected();
    }

    public void loadFrom(JavadocConfiguration configuration) {
        this.myPanel.myTfOutputDir.setText(JavadocConfigurable.toUserSystemFormat(configuration.OUTPUT_DIRECTORY));
        this.myPanel.myOtherOptionsField.setText(configuration.OTHER_OPTIONS);
        this.myPanel.myHeapSizeField.setText(configuration.HEAP_SIZE);
        this.myPanel.myLocaleTextField.setText(configuration.LOCALE);
        this.myPanel.myOpenInBrowserCheckBox.setSelected(configuration.OPEN_IN_BROWSER);
        this.myPanel.setScope(configuration.OPTION_SCOPE);
        this.myPanel.myHierarchy.setSelected(configuration.OPTION_HIERARCHY);
        this.myPanel.myNavigator.setSelected(configuration.OPTION_NAVIGATOR);
        this.myPanel.myIndex.setSelected(configuration.OPTION_INDEX);
        this.myPanel.mySeparateIndex.setSelected(configuration.OPTION_SEPARATE_INDEX);
        this.myPanel.myTagUse.setSelected(configuration.OPTION_DOCUMENT_TAG_USE);
        this.myPanel.myTagAuthor.setSelected(configuration.OPTION_DOCUMENT_TAG_AUTHOR);
        this.myPanel.myTagVersion.setSelected(configuration.OPTION_DOCUMENT_TAG_VERSION);
        this.myPanel.myTagDeprecated.setSelected(configuration.OPTION_DOCUMENT_TAG_DEPRECATED);
        this.myPanel.myDeprecatedList.setSelected(configuration.OPTION_DEPRECATED_LIST);
        this.myPanel.mySeparateIndex.setEnabled(this.myPanel.myIndex.isSelected());
        this.myPanel.myDeprecatedList.setEnabled(this.myPanel.myTagDeprecated.isSelected());
    }

    public boolean isModified() {
        JavadocConfiguration configuration = this.myConfiguration;
        boolean isModified = !JavadocConfigurable.compareStrings(this.myPanel.myTfOutputDir.getText(), JavadocConfigurable.toUserSystemFormat(configuration.OUTPUT_DIRECTORY));
        isModified |= !JavadocConfigurable.compareStrings(this.myPanel.myOtherOptionsField.getText(), configuration.OTHER_OPTIONS);
        isModified |= !JavadocConfigurable.compareStrings(this.myPanel.myHeapSizeField.getText(), configuration.HEAP_SIZE);
        isModified |= this.myPanel.myOpenInBrowserCheckBox.isSelected() != configuration.OPEN_IN_BROWSER;
        isModified |= !JavadocConfigurable.compareStrings(this.myPanel.getScope(), configuration.OPTION_SCOPE == null ? "protected" : configuration.OPTION_SCOPE);
        isModified |= this.myPanel.myHierarchy.isSelected() != configuration.OPTION_HIERARCHY;
        isModified |= this.myPanel.myNavigator.isSelected() != configuration.OPTION_NAVIGATOR;
        isModified |= this.myPanel.myIndex.isSelected() != configuration.OPTION_INDEX;
        isModified |= this.myPanel.mySeparateIndex.isSelected() != configuration.OPTION_SEPARATE_INDEX;
        isModified |= this.myPanel.myTagUse.isSelected() != configuration.OPTION_DOCUMENT_TAG_USE;
        isModified |= this.myPanel.myTagAuthor.isSelected() != configuration.OPTION_DOCUMENT_TAG_AUTHOR;
        isModified |= this.myPanel.myTagVersion.isSelected() != configuration.OPTION_DOCUMENT_TAG_VERSION;
        isModified |= this.myPanel.myTagDeprecated.isSelected() != configuration.OPTION_DOCUMENT_TAG_DEPRECATED;
        return isModified |= this.myPanel.myDeprecatedList.isSelected() != configuration.OPTION_DEPRECATED_LIST;
    }

    public final void apply() {
        this.applyTo(this.myConfiguration);
    }

    public void reset() {
        this.loadFrom(this.myConfiguration);
    }

    private static boolean compareStrings(String string1, String string2) {
        if (string1 == null) {
            string1 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string1.equals(string2);
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static String convertString(String s) {
        if (s != null && s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    private static String toSystemIndependentFormat(String directory) {
        if (directory.length() == 0) {
            return null;
        }
        return directory.replace(File.separatorChar, '/');
    }

    private static String toUserSystemFormat(String directory) {
        if (directory == null) {
            return "";
        }
        return directory.replace('/', File.separatorChar);
    }

    public String getDisplayName() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "project.propJavaDoc";
    }

    public String getOutputDir() {
        return this.myPanel.myTfOutputDir.getText();
    }
}

