/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.CaretModelWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.FoldingModelWindow;
import com.intellij.injected.editor.ListenerWrapperMap;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.injected.editor.SelectionModelWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.containers.WeakList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindow
implements EditorEx,
UserDataHolderEx {
    private final DocumentWindowImpl myDocumentWindow;
    private final EditorImpl myDelegate;
    private volatile PsiFile myInjectedFile;
    private final boolean myOneLine;
    private final CaretModelWindow myCaretModelDelegate;
    private final SelectionModelWindow mySelectionModelDelegate;
    private static final WeakList<EditorWindow> allEditors = new WeakList();
    private boolean myDisposed;
    private final MarkupModelWindow myMarkupModelDelegate;
    private final FoldingModelWindow myFoldingModelWindow;
    private final ListenerWrapperMap<EditorMouseListener> myEditorMouseListeners;
    private final ListenerWrapperMap<EditorMouseMotionListener> myEditorMouseMotionListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Editor create(@NotNull DocumentWindowImpl documentRange, @NotNull EditorImpl editor, @NotNull PsiFile injectedFile) {
        EditorWindow window;
        if (documentRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.create must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.create must not be null");
        }
        if (injectedFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.create must not be null");
        }
        assert (documentRange.isValid());
        assert (injectedFile.isValid());
        WeakList<EditorWindow> weakList = allEditors;
        synchronized (weakList) {
            for (EditorWindow editorWindow : allEditors) {
                if (editorWindow.getDocument() == documentRange && editorWindow.getDelegate() == editor) {
                    editorWindow.myInjectedFile = injectedFile;
                    if (editorWindow.isValid()) {
                        return editorWindow;
                    }
                }
                if (!editorWindow.getDocument().areRangesEqual(documentRange)) continue;
                boolean i = false;
            }
            window = new EditorWindow(documentRange, editor, injectedFile, documentRange.isOneLine());
            allEditors.add((Object)window);
        }
        assert (window.isValid());
        return window;
    }

    private EditorWindow(@NotNull DocumentWindowImpl documentWindow, @NotNull EditorImpl delegate, @NotNull PsiFile injectedFile, boolean oneLine) {
        if (documentWindow == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.<init> must not be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.<init> must not be null");
        }
        if (injectedFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.<init> must not be null");
        }
        this.myEditorMouseListeners = new ListenerWrapperMap();
        this.myEditorMouseMotionListeners = new ListenerWrapperMap();
        this.myDocumentWindow = documentWindow;
        this.myDelegate = delegate;
        this.myInjectedFile = injectedFile;
        this.myOneLine = oneLine;
        this.myCaretModelDelegate = new CaretModelWindow(this.myDelegate.getCaretModel(), this);
        this.mySelectionModelDelegate = new SelectionModelWindow(this.myDelegate, this.myDocumentWindow, this);
        this.myMarkupModelDelegate = new MarkupModelWindow((MarkupModelEx)this.myDelegate.getMarkupModel(), this.myDocumentWindow);
        this.myFoldingModelWindow = new FoldingModelWindow((FoldingModelEx)delegate.getFoldingModel(), documentWindow, this);
    }

    public static void disposeInvalidEditors() {
        Iterator iterator = allEditors.iterator();
        while (iterator.hasNext()) {
            EditorWindow editorWindow = (EditorWindow)iterator.next();
            if (editorWindow.isValid()) continue;
            editorWindow.dispose();
            InjectedLanguageUtil.clearCaches(editorWindow.getInjectedFile());
            iterator.remove();
        }
    }

    private boolean isValid() {
        return !this.isDisposed() && this.myInjectedFile.isValid() && this.myDocumentWindow.isValid();
    }

    public PsiFile getInjectedFile() {
        return this.myInjectedFile;
    }

    public LogicalPosition hostToInjected(LogicalPosition pos) {
        assert (this.isValid());
        int offsetInInjected = this.myDocumentWindow.hostToInjected(this.myDelegate.logicalPositionToOffset(pos));
        return this.offsetToLogicalPosition(offsetInInjected);
    }

    public LogicalPosition injectedToHost(LogicalPosition pos) {
        assert (this.isValid());
        int offsetInHost = this.myDocumentWindow.injectedToHost(this.logicalPositionToOffset(pos));
        return this.myDelegate.offsetToLogicalPosition(offsetInHost);
    }

    private void dispose() {
        assert (!this.myDisposed);
        this.myCaretModelDelegate.disposeModel();
        for (EditorMouseListener editorMouseListener : this.myEditorMouseListeners.wrappers()) {
            this.myDelegate.removeEditorMouseListener(editorMouseListener);
        }
        this.myEditorMouseListeners.clear();
        for (EditorMouseMotionListener editorMouseMotionListener : this.myEditorMouseMotionListeners.wrappers()) {
            this.myDelegate.removeEditorMouseMotionListener(editorMouseMotionListener);
        }
        this.myEditorMouseMotionListeners.clear();
        this.getDocument().dispose();
        this.myDisposed = true;
    }

    public boolean isViewer() {
        return this.myDelegate.isViewer();
    }

    @Override
    public boolean isRendererMode() {
        return this.myDelegate.isRendererMode();
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myDelegate.setRendererMode(isRendererMode);
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myDelegate.setFile(vFile);
    }

    public void setHeaderComponent(@Nullable JComponent header) {
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModelWindow selectionModelWindow = this.mySelectionModelDelegate;
        if (selectionModelWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getSelectionModel must not return null");
        }
        return selectionModelWindow;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        MarkupModelWindow markupModelWindow = this.myMarkupModelDelegate;
        if (markupModelWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getMarkupModel must not return null");
        }
        return markupModelWindow;
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        FoldingModelWindow foldingModelWindow = this.myFoldingModelWindow;
        if (foldingModelWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getFoldingModel must not return null");
        }
        return foldingModelWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModelWindow caretModelWindow = this.myCaretModelDelegate;
        if (caretModelWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getCaretModel must not return null");
        }
        return caretModelWindow;
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        ScrollingModel scrollingModel = this.myDelegate.getScrollingModel();
        if (scrollingModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getScrollingModel must not return null");
        }
        return scrollingModel;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorSettings editorSettings = this.myDelegate.getSettings();
        if (editorSettings == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getSettings must not return null");
        }
        return editorSettings;
    }

    @Override
    public void reinitSettings() {
        this.myDelegate.reinitSettings();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.myDelegate.setFontSize(fontSize);
    }

    @Override
    public void setHighlighter(EditorHighlighter highlighter) {
        this.myDelegate.setHighlighter(highlighter);
    }

    @Override
    public EditorHighlighter getHighlighter() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)this.myInjectedFile.getVirtualFile(), (EditorColorsScheme)scheme, (Project)this.getProject());
        highlighter.setText((CharSequence)this.getDocument().getText());
        return highlighter;
    }

    @NotNull
    public JComponent getContentComponent() {
        JComponent jComponent = this.myDelegate.getContentComponent();
        if (jComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getContentComponent must not return null");
        }
        return jComponent;
    }

    @Override
    public EditorGutterComponentEx getGutterComponentEx() {
        return this.myDelegate.getGutterComponentEx();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myDelegate.removePropertyChangeListener(listener);
    }

    @Override
    public void setInsertMode(boolean mode) {
        this.myDelegate.setInsertMode(mode);
    }

    public boolean isInsertMode() {
        return this.myDelegate.isInsertMode();
    }

    @Override
    public void setColumnMode(boolean mode) {
        this.myDelegate.setColumnMode(mode);
    }

    public boolean isColumnMode() {
        return this.myDelegate.isColumnMode();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.xyToVisualPosition must not be null");
        }
        VisualPosition visualPosition = this.logicalToVisualPosition(this.xyToLogicalPosition(p));
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.xyToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.offsetToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        assert (this.isValid());
        int lineNumber = this.myDocumentWindow.getLineNumber(offset);
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(lineNumber);
        int column = this.calcLogicalColumnNumber(offset - lineStartOffset, lineNumber, lineStartOffset);
        LogicalPosition logicalPosition = new LogicalPosition(lineNumber, column);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.offsetToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.xyToLogicalPosition must not be null");
        }
        assert (this.isValid());
        LogicalPosition hostPos = this.myDelegate.xyToLogicalPosition(p);
        LogicalPosition logicalPosition = this.hostToInjected(hostPos);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.xyToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    private LogicalPosition fitInsideEditor(LogicalPosition pos) {
        int lineLength;
        int lineCount = this.myDocumentWindow.getLineCount();
        if (pos.line >= lineCount) {
            pos = new LogicalPosition(lineCount - 1, pos.column);
        }
        if (pos.column >= (lineLength = this.myDocumentWindow.getLineEndOffset(pos.line) - this.myDocumentWindow.getLineStartOffset(pos.line))) {
            pos = new LogicalPosition(pos.line, lineLength - 1);
        }
        return pos;
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.logicalPositionToXY must not be null");
        }
        assert (this.isValid());
        Point point = this.myDelegate.logicalPositionToXY(this.injectedToHost(this.fitInsideEditor(pos)));
        if (point == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.logicalPositionToXY must not return null");
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.visualPositionToXY must not be null");
        }
        assert (this.isValid());
        Point point = this.logicalPositionToXY(this.visualToLogicalPosition(pos));
        if (point == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.visualPositionToXY must not return null");
        }
        return point;
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        assert (this.isValid());
        this.myDelegate.repaint(this.myDocumentWindow.injectedToHost(startOffset), this.myDocumentWindow.injectedToHost(endOffset));
    }

    @NotNull
    public DocumentWindowImpl getDocument() {
        DocumentWindowImpl documentWindowImpl = this.myDocumentWindow;
        if (documentWindowImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getDocument must not return null");
        }
        return documentWindowImpl;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myDelegate.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getComponent must not return null");
        }
        return jComponent;
    }

    public void addEditorMouseListener(final @NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.addEditorMouseListener must not be null");
        }
        assert (this.isValid());
        EditorMouseListener wrapper = new EditorMouseListener(){

            public void mousePressed(EditorMouseEvent e) {
                listener.mousePressed(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseClicked(EditorMouseEvent e) {
                listener.mouseClicked(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseReleased(EditorMouseEvent e) {
                listener.mouseReleased(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseEntered(EditorMouseEvent e) {
                listener.mouseEntered(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseExited(EditorMouseEvent e) {
                listener.mouseExited(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }
        };
        this.myEditorMouseListeners.registerWrapper(listener, wrapper);
        this.myDelegate.addEditorMouseListener(wrapper);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.removeEditorMouseListener must not be null");
        }
        EditorMouseListener wrapper = this.myEditorMouseListeners.removeWrapper(listener);
        if (wrapper != null) {
            this.myDelegate.removeEditorMouseListener(wrapper);
        }
    }

    public void addEditorMouseMotionListener(final @NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.addEditorMouseMotionListener must not be null");
        }
        assert (this.isValid());
        EditorMouseMotionListener wrapper = new EditorMouseMotionListener(){

            public void mouseMoved(EditorMouseEvent e) {
                listener.mouseMoved(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseDragged(EditorMouseEvent e) {
                listener.mouseDragged(new EditorMouseEvent((Editor)EditorWindow.this, e.getMouseEvent(), e.getArea()));
            }
        };
        this.myEditorMouseMotionListeners.registerWrapper(listener, wrapper);
        this.myDelegate.addEditorMouseMotionListener(wrapper);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.removeEditorMouseMotionListener must not be null");
        }
        EditorMouseMotionListener wrapper = this.myEditorMouseMotionListeners.removeWrapper(listener);
        if (wrapper != null) {
            this.myDelegate.removeEditorMouseMotionListener(wrapper);
        }
    }

    public boolean isDisposed() {
        return !this.myDisposed && this.myDelegate.isDisposed();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myDelegate.setBackgroundColor(color);
    }

    @Override
    public void resetBackgourndColor() {
        this.myDelegate.resetBackgourndColor();
    }

    @Override
    public Color getBackroundColor() {
        return this.myDelegate.getBackroundColor();
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myDelegate.getMaxWidthInRange(startOffset, endOffset);
    }

    public int getLineHeight() {
        return this.myDelegate.getLineHeight();
    }

    @Override
    public Dimension getContentSize() {
        return this.myDelegate.getContentSize();
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.myDelegate.getScrollPane();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.logicalPositionToOffset must not be null");
        }
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(pos.line);
        return this.calcOffset(pos.column, pos.line, lineStartOffset);
    }

    private int calcLogicalColumnNumber(int offsetInLine, int lineNumber, int lineStartOffset) {
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        if (offsetInLine == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        if (offsetInLine > end - lineStartOffset) {
            offsetInLine = end - lineStartOffset;
        }
        CharSequence text = this.myDocumentWindow.getCharsSequence();
        return EditorUtil.calcColumnNumber(this, text, lineStartOffset, lineStartOffset + offsetInLine, EditorUtil.getTabSize(this.myDelegate));
    }

    private int calcOffset(int col, int lineNumber, int lineStartOffset) {
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        CharSequence text = this.myDocumentWindow.getCharsSequence();
        return EditorUtil.calcOffset(this, text, lineStartOffset, end, col, EditorUtil.getTabSize(this.myDelegate));
    }

    @Override
    public void setLastColumnNumber(int val) {
        this.myDelegate.setLastColumnNumber(val);
    }

    @Override
    public int getLastColumnNumber() {
        return this.myDelegate.getLastColumnNumber();
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.logicalToVisualPosition must not be null");
        }
        assert (this.isValid());
        VisualPosition visualPosition = new VisualPosition(pos.line, pos.column);
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.logicalToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.visualToLogicalPosition must not be null");
        }
        assert (this.isValid());
        LogicalPosition logicalPosition = new LogicalPosition(pos.line, pos.column);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.visualToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @Override
    public DataContext getDataContext() {
        return this.myDelegate.getDataContext();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.getMouseEventArea must not be null");
        }
        return this.myDelegate.getMouseEventArea(e);
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        return this.myDelegate.setCaretVisible(b);
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        return this.myDelegate.setCaretEnabled(enabled);
    }

    @Override
    public void addFocusListener(FocusChangeListener listener) {
        this.myDelegate.addFocusListener(listener);
    }

    public Project getProject() {
        return this.myDelegate.getProject();
    }

    public boolean isOneLineMode() {
        return this.myOneLine;
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myDelegate.isEmbeddedIntoDialogWrapper();
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        this.myDelegate.setEmbeddedIntoDialogWrapper(b);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myDelegate.getVirtualFile();
    }

    @Override
    public void stopOptimizedScrolling() {
        this.myDelegate.stopOptimizedScrolling();
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.myDelegate.getCopyProvider();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.myDelegate.getCutProvider();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.myDelegate.getPasteProvider();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.myDelegate.getDeleteProvider();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.setColorsScheme must not be null");
        }
        this.myDelegate.setColorsScheme(scheme);
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myDelegate.getColorsScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getColorsScheme must not return null");
        }
        return editorColorsScheme;
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        this.myDelegate.setVerticalScrollbarOrientation(type);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myDelegate.setVerticalScrollbarVisible(b);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myDelegate.setHorizontalScrollbarVisible(b);
    }

    @Override
    public boolean processKeyTyped(KeyEvent e) {
        return this.myDelegate.processKeyTyped(e);
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutter editorGutter = this.myDelegate.getGutter();
        if (editorGutter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.getGutter must not return null");
        }
        return editorGutter;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.getUserData must not be null");
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.putUserData must not be null");
        }
        this.myDelegate.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.putUserDataIfAbsent must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.putUserDataIfAbsent must not be null");
        }
        Object object = this.myDelegate.putUserDataIfAbsent(key, value);
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/EditorWindow.putUserDataIfAbsent must not return null");
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/EditorWindow.replace must not be null");
        }
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorWindow that = (EditorWindow)o;
        DocumentWindowImpl thatWindow = that.getDocument();
        return this.myDelegate.equals(that.myDelegate) && this.myDocumentWindow.equals(thatWindow);
    }

    public int hashCode() {
        return this.myDocumentWindow.hashCode();
    }

    public Editor getDelegate() {
        return this.myDelegate;
    }

    @Override
    public int calcColumnNumber(CharSequence text, int start, int offset, int tabSize) {
        int hostStart = this.myDocumentWindow.injectedToHost(start);
        int hostOffset = this.myDocumentWindow.injectedToHost(offset);
        return this.myDelegate.calcColumnNumber(this.myDelegate.getDocument().getText(), hostStart, hostOffset, tabSize);
    }

    @Override
    public int calcColumnNumber(int offset, int lineIndex) {
        return this.myDelegate.calcColumnNumber(this.myDocumentWindow.injectedToHost(offset), this.myDocumentWindow.injectedToHostLine(lineIndex));
    }

    public IndentsModel getIndentsModel() {
        return this.myDelegate.getIndentsModel();
    }
}

