/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.CommonBundle;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;

public class SocketLock {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.SocketLock");
    private static final int SOCKET_NUMBER_START = 6942;
    private static final int SOCKET_NUMBER_END = 6992;
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private ServerSocket mySocket;
    private final List myLockedPaths = new ArrayList();
    private boolean myIsDialogShown = false;
    @NonNls
    private static final String LOCALHOST = "localhost";
    @NonNls
    private static final String LOCK_THREAD_NAME = "Lock thread";

    public synchronized void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: destroyProcess()");
        }
        try {
            this.mySocket.close();
            this.mySocket = null;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    public synchronized boolean lock(String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: lock(path='" + path + "')");
        }
        this.acquireSocket();
        if (this.mySocket == null) {
            if (!this.myIsDialogShown) {
                String productName = ApplicationNamesInfo.getInstance().getProductName();
                if (StartupUtil.isHeadless()) {
                    throw new RuntimeException("Only one instance of " + productName + " can be run at a time.");
                }
                String pathToLogFile = PathManager.getLogPath() + "/idea.log file".replace('/', File.separatorChar);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), CommonBundle.message((String)"cannot.start.other.instance.is.running.error.message", (Object[])new Object[]{productName, pathToLogFile}), CommonBundle.message((String)"title.warning", (Object[])new Object[0]), 2);
                this.myIsDialogShown = true;
            }
            return true;
        }
        for (int i = 6942; i < 6992; ++i) {
            List lockedList;
            if (SocketLock.isPortForbidden(i) || i == this.mySocket.getLocalPort() || !(lockedList = this.readLockedList(i)).contains(path)) continue;
            return false;
        }
        this.myLockedPaths.add(path);
        return true;
    }

    private static boolean isPortForbidden(int port) {
        for (int forbiddenPort : FORBIDDEN_PORTS) {
            if (port != forbiddenPort) continue;
            return true;
        }
        return false;
    }

    public synchronized void unlock(String path) {
        this.myLockedPaths.remove(path);
    }

    private List readLockedList(int i) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ServerSocket serverSocket = new ServerSocket(i);
            serverSocket.close();
            return result;
        }
        catch (IOException e) {
            try {
                Socket socket = new Socket(LOCALHOST, i);
                socket.setSoTimeout(300);
                DataInputStream in = new DataInputStream(socket.getInputStream());
                try {
                    while (true) {
                        result.add(in.readUTF());
                    }
                }
                catch (IOException e2) {
                    in.close();
                }
            }
            catch (IOException e3) {
                LOG.debug((Throwable)e3);
            }
            return result;
        }
    }

    private void acquireSocket() {
        if (this.mySocket != null) {
            return;
        }
        for (int i = 6942; i < 6992; ++i) {
            try {
                if (SocketLock.isPortForbidden(i)) continue;
                this.mySocket = new ServerSocket(i);
                break;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Thread thread = new Thread((Runnable)new MyRunnable(), LOCK_THREAD_NAME);
        thread.setPriority(1);
        thread.start();
    }

    private synchronized void writeLockedPaths(Socket socket) {
        try {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            for (String path : this.myLockedPaths) {
                out.writeUTF(path);
            }
            out.close();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket socket = SocketLock.this.mySocket.accept();
                            SocketLock.this.writeLockedPaths(socket);
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }
}

