/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;

public class PsiClassListCellRenderer
extends PsiElementListCellRenderer<PsiClass> {
    @Override
    public String getElementText(PsiClass element) {
        return ClassPresentationUtil.getNameForClass(element, false);
    }

    @Override
    protected String getContainerText(PsiClass element, String name) {
        return PsiClassListCellRenderer.getContainerTextStatic((PsiElement)element);
    }

    protected static String getContainerTextStatic(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)file;
            String packageName = javaFile.getPackageName();
            if (packageName.length() == 0) {
                return null;
            }
            return "(" + packageName + ")";
        }
        return null;
    }

    @Override
    protected int getIconFlags() {
        return 0;
    }
}

