/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

class StructureTreeBuilder
extends AbstractTreeBuilder {
    private final Project myProject;
    private final StructureViewModel myStructureModel;
    private final CopyPasteUtil.DefaultCopyPasteListener myCopyPasteListener;
    private final PsiTreeChangeListener myPsiTreeChangeListener;
    private final ModelListener myModelListener;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);

    public StructureTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, StructureViewModel structureModel) {
        super(tree, treeModel, treeStructure, null, false);
        this.myProject = project;
        this.myStructureModel = structureModel;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myModelListener = new ModelListener(){

            public void onModelChanged() {
                StructureTreeBuilder.this.addRootToUpdate();
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener(this.myPsiTreeChangeListener);
        this.myCopyPasteListener = new CopyPasteUtil.DefaultCopyPasteListener(this.getUpdater());
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)this.myCopyPasteListener);
        this.initRootNode();
        this.myStructureModel.addModelListener(this.myModelListener);
        this.setCanYieldUpdate(!ApplicationManager.getApplication().isUnitTestMode());
    }

    public final void dispose() {
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(this.myPsiTreeChangeListener);
        CopyPasteManager.getInstance().removeContentChangedListener((CopyPasteManager.ContentChangedListener)this.myCopyPasteListener);
        this.myStructureModel.removeModelListener(this.myModelListener);
        super.dispose();
    }

    protected final boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((AbstractTreeNode)nodeDescriptor).isAlwaysShowPlus();
    }

    protected final boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        NodeDescriptor parent = nodeDescriptor.getParentDescriptor();
        return super.isAutoExpandNode(parent == null ? nodeDescriptor : parent);
    }

    protected final boolean isSmartExpand() {
        return false;
    }

    @NotNull
    protected final ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/StructureTreeBuilder.createProgressIndicator must not return null");
        }
        return statusBarProgress;
    }

    private void setupUpdateAlarm() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!StructureTreeBuilder.this.isDisposed() && !StructureTreeBuilder.this.myProject.isDisposed()) {
                    StructureTreeBuilder.this.addRootToUpdate();
                }
            }
        }, 300, ModalityState.stateForComponent((Component)this.getTree()));
    }

    final void addRootToUpdate() {
        this.getTreeStructure().commit();
        ((SmartTreeStructure)this.getTreeStructure()).rebuildTree();
        this.getUpdater().addSubtreeToUpdate(this.getRootNode());
    }

    protected final AbstractTreeNode createSearchingTreeNodeWrapper() {
        return new StructureViewComponent.StructureViewTreeElementWrapper(null, null, null);
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private final PsiModificationTracker myModificationTracker;
        private long myOutOfCodeBlockModificationCount;

        private MyPsiTreeChangeListener() {
            this.myModificationTracker = PsiManager.getInstance((Project)StructureTreeBuilder.this.myProject).getModificationTracker();
            this.myOutOfCodeBlockModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
        }

        public void childRemoved(PsiTreeChangeEvent event) {
            PsiElement child = event.getOldChild();
            if (child instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childAdded(PsiTreeChangeEvent event) {
            PsiElement child = event.getNewChild();
            if (child instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            PsiElement oldChild = event.getOldChild();
            PsiElement newChild = event.getNewChild();
            if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childMoved(PsiTreeChangeEvent event) {
            this.childrenChanged();
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            this.childrenChanged();
        }

        private void childrenChanged() {
            long newModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
            if (newModificationCount == this.myOutOfCodeBlockModificationCount) {
                return;
            }
            this.myOutOfCodeBlockModificationCount = newModificationCount;
            StructureTreeBuilder.this.setupUpdateAlarm();
        }

        public void propertyChanged(PsiTreeChangeEvent event) {
            this.childrenChanged();
        }
    }
}

