/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.PsiRetriever;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.actions.MoveAction;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoveDropTargetListener
implements DropTargetListener {
    private final DataFlavor dataFlavor;
    private final Project myProject;
    private final JTree myTree;
    private final PsiRetriever myPsiRetriever;

    public MoveDropTargetListener(PsiRetriever psiRetriever, JTree tree, Project project, DataFlavor flavor) {
        this.myPsiRetriever = psiRetriever;
        this.myProject = project;
        this.myTree = tree;
        this.dataFlavor = flavor;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        DropHandler dropHandler = this.getDropHandler(dtde.getDropAction());
        TreeNode[] sourceNodes = this.getSourceNodes(dtde.getTransferable());
        if (sourceNodes != null && dropHandler.isValidSource(sourceNodes)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else if (dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        TreeNode[] sourceNodes = this.getSourceNodes(dtde.getTransferable());
        TreeNode targetNode = this.getTargetNode(dtde.getLocation());
        int dropAction = dtde.getDropAction();
        if (sourceNodes != null && targetNode != null && this.canDrop(sourceNodes, targetNode, dropAction)) {
            dtde.acceptDrag(dropAction);
        } else if (targetNode != null && dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(dropAction);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        TreeNode[] sourceNodes = this.getSourceNodes(dtde.getTransferable());
        TreeNode targetNode = this.getTargetNode(dtde.getLocation());
        int dropAction = dtde.getDropAction();
        if (targetNode == null || (dropAction & 3) == 0) {
            dtde.rejectDrop();
        } else if (sourceNodes == null) {
            if (dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList;
                dtde.acceptDrop(dropAction);
                try {
                    fileList = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception e) {
                    dtde.rejectDrop();
                    return;
                }
                this.getDropHandler(dropAction).doDropFiles(fileList, targetNode);
            } else {
                dtde.rejectDrop();
            }
        } else if (!this.doDrop(sourceNodes, targetNode, dropAction, dtde)) {
            dtde.rejectDrop();
        }
    }

    @Nullable
    private TreeNode[] getSourceNodes(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(this.dataFlavor)) {
            return null;
        }
        try {
            Object transferData = transferable.getTransferData(this.dataFlavor);
            if (transferData instanceof AbstractProjectViewPane.TransferableWrapper) {
                return ((AbstractProjectViewPane.TransferableWrapper)transferData).getTreeNodes();
            }
            return null;
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private TreeNode getTargetNode(Point location) {
        TreePath path = this.myTree.getPathForLocation(location.x, location.y);
        return path == null ? null : (TreeNode)path.getLastPathComponent();
    }

    private boolean canDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction) {
        if (sourceNodes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.canDrop must not be null");
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.canDrop must not be null");
        }
        return this.doDrop(sourceNodes, targetNode, dropAction, null);
    }

    private boolean doDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction, @Nullable DropTargetDropEvent dtde) {
        TreeNode[] filteredSourceNodes;
        if (sourceNodes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.doDrop must not be null");
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.doDrop must not be null");
        }
        TreeNode validTargetNode = this.getValidTargetNode(sourceNodes, targetNode, dropAction);
        if (validTargetNode != null && (filteredSourceNodes = this.removeRedundantSourceNodes(sourceNodes, validTargetNode, dropAction)).length != 0) {
            if (dtde != null) {
                dtde.dropComplete(true);
                this.getDropHandler(dropAction).doDrop(filteredSourceNodes, validTargetNode);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private TreeNode getValidTargetNode(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction) {
        if (sourceNodes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.getValidTargetNode must not be null");
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.getValidTargetNode must not be null");
        }
        DropHandler dropHandler = this.getDropHandler(dropAction);
        TreeNode currentNode = targetNode;
        do {
            if (dropHandler.isValidTarget(sourceNodes, currentNode)) {
                return currentNode;
            }
            if (dropHandler.shouldDelegateToParent(currentNode)) continue;
            return null;
        } while ((currentNode = currentNode.getParent()) != null);
        return null;
    }

    private TreeNode[] removeRedundantSourceNodes(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction) {
        if (sourceNodes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.removeRedundantSourceNodes must not be null");
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener.removeRedundantSourceNodes must not be null");
        }
        DropHandler dropHandler = this.getDropHandler(dropAction);
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(sourceNodes.length);
        for (TreeNode sourceNode : sourceNodes) {
            if (dropHandler.isDropRedundant(sourceNode, targetNode)) continue;
            result.add(sourceNode);
        }
        return result.toArray(new TreeNode[result.size()]);
    }

    public DropHandler getDropHandler(int dropAction) {
        return dropAction == 1 ? new CopyDropHandler() : new MoveDropHandler();
    }

    private class CopyDropHandler
    extends MoveCopyDropHandler {
        private CopyDropHandler() {
        }

        @Override
        protected boolean canDrop(@NotNull TreeNode[] sourceNodes, @Nullable TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$CopyDropHandler.canDrop must not be null");
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            PsiElement targetElement = this.getPsiElement(targetNode);
            return (targetElement instanceof PsiDirectoryContainer || targetElement instanceof PsiDirectory) && this.fromSameProject(sourceElements, targetElement) && CopyHandler.canCopy(sourceElements);
        }

        @Override
        public void doDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$CopyDropHandler.doDrop must not be null");
            }
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$CopyDropHandler.doDrop must not be null");
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            this.doDrop(targetNode, sourceElements);
        }

        private void doDrop(TreeNode targetNode, PsiElement[] sourceElements) {
            PsiDirectoryContainer directoryContainer;
            PsiDirectory[] psiDirectories;
            PsiElement targetElement = this.getPsiElement(targetNode);
            PsiDirectory psiDirectory = targetElement instanceof PsiDirectoryContainer ? ((psiDirectories = (directoryContainer = (PsiDirectoryContainer)targetElement).getDirectories()).length != 0 ? psiDirectories[0] : null) : (PsiDirectory)targetElement;
            CopyHandler.doCopy(sourceElements, psiDirectory);
        }

        @Override
        public boolean isDropRedundant(@NotNull TreeNode sourceNode, @NotNull TreeNode targetNode) {
            if (sourceNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$CopyDropHandler.isDropRedundant must not be null");
            }
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$CopyDropHandler.isDropRedundant must not be null");
            }
            return false;
        }

        @Override
        public boolean shouldDelegateToParent(@NotNull TreeNode targetNode) {
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$CopyDropHandler.shouldDelegateToParent must not be null");
            }
            PsiElement psiElement = this.getPsiElement(targetNode);
            return psiElement == null || !(psiElement instanceof PsiDirectoryContainer) && !(psiElement instanceof PsiDirectory);
        }

        @Override
        public void doDropFiles(List<File> fileList, TreeNode targetNode) {
            PsiFileSystemItem[] sourceFileArray = this.getPsiFiles(fileList);
            this.doDrop(targetNode, (PsiElement[])sourceFileArray);
        }
    }

    private class MoveDropHandler
    extends MoveCopyDropHandler {
        private MoveDropHandler() {
        }

        @Override
        protected boolean canDrop(@NotNull TreeNode[] sourceNodes, @Nullable TreeNode targetNode) {
            Object userObject;
            if (sourceNodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveDropHandler.canDrop must not be null");
            }
            if (targetNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)targetNode).getUserObject()) instanceof DropTargetNode && ((DropTargetNode)userObject).canDrop(sourceNodes)) {
                return true;
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            PsiElement targetElement = this.getPsiElement(targetNode);
            return sourceElements.length == 0 || (targetNode == null || targetElement != null) && this.fromSameProject(sourceElements, targetElement) && MoveHandler.canMove(sourceElements, targetElement);
        }

        @Override
        public void doDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            Object userObject;
            if (sourceNodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveDropHandler.doDrop must not be null");
            }
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveDropHandler.doDrop must not be null");
            }
            if (targetNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)targetNode).getUserObject()) instanceof DropTargetNode && ((DropTargetNode)userObject).canDrop(sourceNodes)) {
                ((DropTargetNode)userObject).drop(sourceNodes);
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            this.doDrop(targetNode, sourceElements);
        }

        private void doDrop(TreeNode targetNode, PsiElement[] sourceElements) {
            final PsiElement targetElement = this.getPsiElement(targetNode);
            if (targetElement == null) {
                return;
            }
            final DataContext dataContext = DataManager.getInstance().getDataContext((Component)MoveDropTargetListener.this.myTree);
            this.getActionHandler(dataContext).invoke(MoveDropTargetListener.this.myProject, sourceElements, new DataContext(){

                @Nullable
                public Object getData(@NonNls String dataId) {
                    if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                        return targetElement;
                    }
                    return dataContext.getData(dataId);
                }
            });
        }

        private RefactoringActionHandler getActionHandler(DataContext dataContext) {
            MoveAction.MoveProvider moveProvider = (MoveAction.MoveProvider)MoveAction.MoveProvider.DATA_KEY.getData(dataContext);
            if (moveProvider != null) {
                return moveProvider.getHandler(dataContext);
            }
            return RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        }

        @Override
        public boolean isDropRedundant(@NotNull TreeNode sourceNode, @NotNull TreeNode targetNode) {
            if (sourceNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveDropHandler.isDropRedundant must not be null");
            }
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveDropHandler.isDropRedundant must not be null");
            }
            return sourceNode.getParent() == targetNode;
        }

        @Override
        public boolean shouldDelegateToParent(@NotNull TreeNode targetNode) {
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveDropHandler.shouldDelegateToParent must not be null");
            }
            PsiElement psiElement = this.getPsiElement(targetNode);
            return !MoveHandler.isValidTarget(psiElement);
        }

        @Override
        public void doDropFiles(List<File> fileList, TreeNode targetNode) {
            PsiFileSystemItem[] sourceFileArray = this.getPsiFiles(fileList);
            this.doDrop(targetNode, (PsiElement[])sourceFileArray);
        }
    }

    public abstract class MoveCopyDropHandler
    implements DropHandler {
        @Override
        public boolean isValidSource(@NotNull TreeNode[] sourceNodes) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveCopyDropHandler.isValidSource must not be null");
            }
            return this.canDrop(sourceNodes, null);
        }

        @Override
        public boolean isValidTarget(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveCopyDropHandler.isValidTarget must not be null");
            }
            if (targetNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveCopyDropHandler.isValidTarget must not be null");
            }
            return this.canDrop(sourceNodes, targetNode);
        }

        protected abstract boolean canDrop(@NotNull TreeNode[] var1, @Nullable TreeNode var2);

        @Nullable
        protected PsiElement getPsiElement(@Nullable TreeNode treeNode) {
            return MoveDropTargetListener.this.myPsiRetriever.getPsiElement(treeNode);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        protected PsiElement[] getPsiElements(@NotNull TreeNode[] nodes) {
            PsiElement[] psiElementArray;
            if (nodes == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveCopyDropHandler.getPsiElements must not be null");
            }
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>(nodes.length);
            for (TreeNode node : nodes) {
                PsiElement psiElement = this.getPsiElement(node);
                if (psiElement == null) continue;
                psiElements.add(psiElement);
            }
            if (psiElements.size() != 0) {
                psiElementArray = psiElements.toArray(new PsiElement[psiElements.size()]);
                if (psiElementArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveCopyDropHandler.getPsiElements must not return null");
                return psiElementArray;
            }
            psiElementArray = BaseRefactoringAction.getPsiElementArray(DataManager.getInstance().getDataContext((Component)MoveDropTargetListener.this.myTree));
            if (psiElementArray != null) return psiElementArray;
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/MoveDropTargetListener$MoveCopyDropHandler.getPsiElements must not return null");
        }

        protected boolean fromSameProject(PsiElement[] sourceElements, PsiElement targetElement) {
            return targetElement != null && sourceElements.length > 0 && sourceElements[0] != null && targetElement.getProject() == sourceElements[0].getProject();
        }

        protected PsiFileSystemItem[] getPsiFiles(List<File> fileList) {
            ArrayList<PsiDirectory> sourceFiles = new ArrayList<PsiDirectory>();
            for (File file : fileList) {
                PsiDirectory psiFile;
                VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                if (vFile == null || (psiFile = vFile.isDirectory() ? PsiManager.getInstance((Project)MoveDropTargetListener.this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)MoveDropTargetListener.this.myProject).findFile(vFile)) == null) continue;
                sourceFiles.add(psiFile);
            }
            return sourceFiles.toArray(new PsiFileSystemItem[sourceFiles.size()]);
        }
    }

    private static interface DropHandler {
        public boolean isValidSource(@NotNull TreeNode[] var1);

        public boolean isValidTarget(@NotNull TreeNode[] var1, @NotNull TreeNode var2);

        public boolean shouldDelegateToParent(@NotNull TreeNode var1);

        public boolean isDropRedundant(@NotNull TreeNode var1, @NotNull TreeNode var2);

        public void doDrop(@NotNull TreeNode[] var1, @NotNull TreeNode var2);

        public void doDropFiles(List<File> var1, TreeNode var2);
    }

    public static interface ModifierSource {
        public int getModifiers();
    }
}

