/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SyntheticElement;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class ClassesTreeStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    private final Project myProject;

    public ClassesTreeStructureProvider(Project project) {
        this.myProject = project;
    }

    public Collection<AbstractTreeNode> modify(AbstractTreeNode parent, Collection<AbstractTreeNode> children, ViewSettings settings) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            Object o = child.getValue();
            if (o instanceof PsiClassOwner) {
                ViewSettings settings1 = ((ProjectViewNode)parent).getSettings();
                PsiClassOwner classOwner = (PsiClassOwner)o;
                PsiClass[] classes = classOwner.getClasses();
                VirtualFile file = classOwner.getVirtualFile();
                if (this.fileInRoots(file)) {
                    if (classes.length == 1 && !(classes[0] instanceof SyntheticElement)) {
                        result.add((AbstractTreeNode)new ClassTreeNode(this.myProject, classes[0], settings1));
                        continue;
                    }
                    result.add((AbstractTreeNode)new PsiClassOwnerTreeNode(classOwner, settings1));
                    continue;
                }
            }
            result.add(child);
        }
        return result;
    }

    private boolean fileInRoots(VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return file != null && (index.isInSourceContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file));
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    public PsiElement getTopLevelElement(PsiElement element) {
        PsiClass[] classes;
        PsiElement current;
        PsiFile baseRootFile = ClassesTreeStructureProvider.getBaseRootFile(element);
        if (baseRootFile == null) {
            return null;
        }
        if (!this.fileInRoots(baseRootFile.getVirtualFile())) {
            return baseRootFile;
        }
        for (current = element; current != null && !this.isSelectable(current) && !ClassesTreeStructureProvider.isTopLevelClass(current, baseRootFile); current = current.getParent()) {
        }
        if (current instanceof PsiClassOwner && (classes = ((PsiClassOwner)current).getClasses()).length == 1 && !(classes[0] instanceof SyntheticElement) && ClassesTreeStructureProvider.isTopLevelClass((PsiElement)classes[0], baseRootFile)) {
            current = classes[0];
        }
        return current != null ? current : baseRootFile;
    }

    private boolean isSelectable(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return true;
        }
        if (element instanceof PsiField || element instanceof PsiClass || element instanceof PsiMethod) {
            return !(element.getParent() instanceof PsiAnonymousClass) && !(element instanceof PsiAnonymousClass);
        }
        return false;
    }

    @Nullable
    private static PsiFile getBaseRootFile(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean isTopLevelClass(PsiElement element, PsiFile baseRootFile) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        if (element instanceof PsiAnonymousClass) {
            return false;
        }
        PsiFile parentFile = ClassesTreeStructureProvider.parentFileOf((PsiClass)element);
        return parentFile != null && parentFile.getLanguage() == baseRootFile.getLanguage();
    }

    @Nullable
    private static PsiFile parentFileOf(PsiClass psiClass) {
        return psiClass.getContainingClass() == null ? psiClass.getContainingFile() : null;
    }

    private static class PsiClassOwnerTreeNode
    extends PsiFileNode {
        public PsiClassOwnerTreeNode(PsiClassOwner classOwner, ViewSettings settings) {
            super(classOwner.getProject(), (PsiFile)classOwner, settings);
        }

        @Override
        public Collection<AbstractTreeNode> getChildrenImpl() {
            ViewSettings settings = this.getSettings();
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (PsiClass aClass : ((PsiClassOwner)this.getValue()).getClasses()) {
                if (aClass instanceof SyntheticElement) continue;
                result.add((AbstractTreeNode)new ClassTreeNode(this.myProject, aClass, settings));
            }
            return result;
        }

        @Override
        protected void updateImpl(PresentationData data) {
            super.updateImpl(data);
            data.setPresentableText(((PsiFile)this.getValue()).getName());
            data.setIcons(((PsiFile)this.getValue()).getViewProvider().getVirtualFile().getIcon());
        }
    }
}

