/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.config;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ChangeMasterKeyDialog;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ResetPasswordDialog;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PasswordSafeOptionsPanel {
    private JRadioButton myDoNotRememberPasswordsRadioButton;
    private JRadioButton myRememberPasswordsUntilClosingRadioButton;
    private JRadioButton myRememberOnDiskProtectedRadioButton;
    private JButton myChangeMasterPasswordButton;
    private JButton myResetMasterPasswordButton;
    private JPanel myRoot;

    public PasswordSafeOptionsPanel(PasswordSafe passwordSafe) {
        final PasswordSafeImpl ps = (PasswordSafeImpl)passwordSafe;
        this.$$$setupUI$$$();
        final ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isDisk = PasswordSafeOptionsPanel.this.myRememberOnDiskProtectedRadioButton.isSelected();
                PasswordSafeOptionsPanel.this.myChangeMasterPasswordButton.setEnabled(isDisk && !PasswordSafeOptionsPanel.isMasterKeyEmpty(ps));
                PasswordSafeOptionsPanel.this.myResetMasterPasswordButton.setEnabled(isDisk);
            }
        };
        this.myRememberOnDiskProtectedRadioButton.addChangeListener(listener);
        listener.stateChanged(null);
        this.myChangeMasterPasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PasswordSafeOptionsPanel.isMasterKeyEmpty(ps)) {
                    ChangeMasterKeyDialog.changePassword(null, ps.getMasterKeyProvider());
                    listener.stateChanged(null);
                }
            }
        });
        this.myResetMasterPasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordSafeOptionsPanel.isMasterKeyEmpty(ps)) {
                    ResetPasswordDialog.newPassword(null, ps.getMasterKeyProvider());
                } else {
                    ResetPasswordDialog.resetPassword(null, ps.getMasterKeyProvider());
                }
                listener.stateChanged(null);
            }
        });
    }

    private static boolean isMasterKeyEmpty(PasswordSafeImpl ps) {
        return ps.getMasterKeyProvider().isEmpty();
    }

    public void load(PasswordSafeSettings settings) {
        PasswordSafeSettings.ProviderType t = settings.getProviderType();
        switch (t) {
            case DO_NOT_STORE: {
                this.myDoNotRememberPasswordsRadioButton.setSelected(true);
                break;
            }
            case MEMORY_ONLY: {
                this.myRememberPasswordsUntilClosingRadioButton.setSelected(true);
                break;
            }
            case MASTER_PASSWORD: {
                this.myRememberOnDiskProtectedRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown provider type: " + (Object)((Object)t));
            }
        }
    }

    private PasswordSafeSettings.ProviderType getProviderType() {
        if (this.myDoNotRememberPasswordsRadioButton.isSelected()) {
            return PasswordSafeSettings.ProviderType.DO_NOT_STORE;
        }
        if (this.myRememberPasswordsUntilClosingRadioButton.isSelected()) {
            return PasswordSafeSettings.ProviderType.MEMORY_ONLY;
        }
        return PasswordSafeSettings.ProviderType.MASTER_PASSWORD;
    }

    public boolean isModified(PasswordSafeSettings settings) {
        return this.getProviderType() != settings.getProviderType();
    }

    public void save(PasswordSafeSettings settings) {
        settings.setProviderType(this.getProviderType());
    }

    public JComponent getRoot() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Remembering passwords", 0, 0, null, null));
        this.myDoNotRememberPasswordsRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setToolTipText("Password asked from user each time they are needed.");
        jRadioButton3.setText("Do not remember passwords");
        jRadioButton3.setMnemonic('N');
        jRadioButton3.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRememberPasswordsUntilClosingRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setToolTipText("The passwords are stored only in the memory. They will be forgotten when IDEA session terminates.");
        jRadioButton2.setText("Remember passwords until closing of the application");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(19);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRememberOnDiskProtectedRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setToolTipText("The passwords are saved on disk and after restart only master password will be asked.");
        jRadioButton.setText("Remember on disk (protected with master password)");
        jRadioButton.setMnemonic('D');
        jRadioButton.setDisplayedMnemonicIndex(12);
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myChangeMasterPasswordButton = jButton2 = new JButton();
        jButton2.setText("Change Master Password");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jButton2.setToolTipText("Change master password for the password database.");
        jPanel3.add((Component)jButton2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myResetMasterPasswordButton = jButton = new JButton();
        jButton.setText("Reset Master Password");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jButton.setToolTipText("Reset or specify a password for the password database");
        jPanel3.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

