/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class HierarchyTreeBuilder
extends AbstractTreeBuilder {
    private final Project myProject;
    private final PsiTreeChangeListener myPsiTreeChangeListener;
    private final MyFileStatusListener myFileStatusListener;

    public HierarchyTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, HierarchyTreeStructure treeStructure, Comparator<NodeDescriptor> comparator) {
        super(tree, treeModel, (AbstractTreeStructure)treeStructure, comparator);
        this.myProject = project;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myFileStatusListener = new MyFileStatusListener();
        this.initRootNode();
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener(this.myPsiTreeChangeListener);
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener);
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    public final Object storeExpandedAndSelectedInfo() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        return new Pair(pathsToExpand, selectionPaths);
    }

    public final void restoreExpandedAndSelectedInfo(Object info) {
        Pair pair = (Pair)info;
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, (List)((ArrayList)pair.first), (List)((ArrayList)pair.second), (boolean)true);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((HierarchyTreeStructure)this.getTreeStructure()).isAlwaysShowPlus();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (this.getTreeStructure().getRootElement().equals(nodeDescriptor.getElement())) {
            return true;
        }
        return !(nodeDescriptor instanceof HierarchyNodeDescriptor);
    }

    protected final boolean isSmartExpand() {
        return false;
    }

    protected final boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return false;
    }

    public final void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
            PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(this.myPsiTreeChangeListener);
            FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener((FileStatusListener)this.myFileStatusListener);
        }
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/HierarchyTreeBuilder.createProgressIndicator must not return null");
        }
        return statusBarProgress;
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public final void fileStatusesChanged() {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/HierarchyTreeBuilder$MyFileStatusListener.fileStatusChanged must not be null");
            }
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public final void childAdded(PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childRemoved(PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childReplaced(PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childMoved(PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void childrenChanged(PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }

        public final void propertyChanged(PsiTreeChangeEvent event) {
            HierarchyTreeBuilder.this.getUpdater().addSubtreeToUpdate(HierarchyTreeBuilder.this.getRootNode());
        }
    }
}

