/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class SelectAllAction
extends AnAction
implements DumbAware {
    public SelectAllAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final Editor editor = TextComponentEditorAction.getEditorFromContext(dataContext);
        if (editor == null) {
            return;
        }
        CommandProcessor processor = CommandProcessor.getInstance();
        processor.executeCommand((Project)PlatformDataKeys.PROJECT.getData(dataContext), new Runnable(){

            @Override
            public void run() {
                editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
            }
        }, IdeBundle.message((String)"command.select.all", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Editor editor = TextComponentEditorAction.getEditorFromContext(event.getDataContext());
        presentation.setEnabled(editor != null);
    }
}

