/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class FixLineSeparatorsAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final VirtualFile[] vFiles = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || vFiles == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                for (VirtualFile vFile : vFiles) {
                    FixLineSeparatorsAction.fixSeparators(vFile);
                }
            }
        }, "fixing line separators", null);
    }

    private static void fixSeparators(VirtualFile vFile) {
        if (vFile.isDirectory()) {
            for (VirtualFile child : vFile.getChildren()) {
                FixLineSeparatorsAction.fixSeparators(child);
            }
        } else {
            if (vFile.getFileType().isBinary()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(vFile);
            if (FixLineSeparatorsAction.areSeparatorsBroken(document)) {
                FixLineSeparatorsAction.fixSeparators(document);
            }
        }
    }

    private static boolean areSeparatorsBroken(Document document) {
        int count = document.getLineCount();
        for (int i = 1; i < count; i += 2) {
            if (document.getLineStartOffset(i) == document.getLineEndOffset(i)) continue;
            return false;
        }
        return true;
    }

    private static void fixSeparators(final Document document) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (int i = 1; i < document.getLineCount(); ++i) {
                    int start = document.getLineEndOffset(i);
                    int end = document.getLineEndOffset(i) + document.getLineSeparatorLength(i);
                    document.deleteString(start, end);
                }
            }
        });
    }
}

