/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.pom.Navigatable;
import com.intellij.util.OpenSourceUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNavigateToSourceAction
extends AnAction
implements DumbAware {
    private final boolean myFocusEditor;

    protected BaseNavigateToSourceAction(boolean focusEditor) {
        this.myFocusEditor = focusEditor;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        OpenSourceUtil.navigate((Navigatable[])this.getNavigatables(dataContext), (boolean)this.myFocusEditor);
    }

    public void update(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        boolean enabled = this.isEnabled(dataContext);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(enabled);
        } else {
            event.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(DataContext dataContext) {
        Navigatable[] navigatables = this.getNavigatables(dataContext);
        if (navigatables != null) {
            for (Navigatable navigatable : navigatables) {
                if (!navigatable.canNavigate()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected Navigatable[] getNavigatables(DataContext dataContext) {
        return (Navigatable[])PlatformDataKeys.NAVIGATABLE_ARRAY.getData(dataContext);
    }
}

