/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.FormatUtil;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.revertion.Reverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class RevisionReverter
extends Reverter {
    protected Revision myLeftRevision;
    protected Entry myLeftEntry;
    protected Entry myRightEntry;

    public RevisionReverter(LocalVcs vcs, IdeaGateway gw, Revision leftRevision, Entry leftEntry, Entry rightEntry) {
        super(vcs, gw);
        this.myLeftRevision = leftRevision;
        this.myLeftEntry = leftEntry;
        this.myRightEntry = rightEntry;
    }

    @Override
    public List<String> askUserForProceeding() throws IOException {
        if (this.myLeftEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<Entry> myEntriesWithBigContent = new ArrayList<Entry>();
        if (!this.myLeftEntry.hasUnavailableContent(myEntriesWithBigContent)) {
            return Collections.emptyList();
        }
        String filesList = "";
        for (Entry e : myEntriesWithBigContent) {
            if (filesList.length() > 0) {
                filesList = filesList + "\n";
            }
            filesList = filesList + e.getPath();
        }
        return Collections.singletonList(LocalHistoryBundle.message("revert.message.some.files.have.unversioned.content", filesList));
    }

    @Override
    protected boolean askForReadOnlyStatusClearing() throws IOException {
        if (!this.hasCurrentVersion()) {
            return true;
        }
        return super.askForReadOnlyStatusClearing();
    }

    @Override
    protected String formatCommandName() {
        String date = FormatUtil.formatTimestamp(this.myLeftRevision.getTimestamp());
        return LocalHistoryBundle.message("system.label.revert.to.date", date);
    }

    protected boolean hasPreviousVersion() {
        return this.myLeftEntry != null;
    }

    protected boolean hasCurrentVersion() {
        if (this.myRightEntry == null) {
            return false;
        }
        return this.myGateway.findVirtualFile(this.myRightEntry.getPath()) != null;
    }
}

