/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.ContentFactory;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.history.utils.Reversed;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalHistoryFacade {
    private final LocalVcs myVcs;
    private final IdeaGateway myGateway;
    private int myChangeSetDepth = 0;
    private final List<String> myLog = new ArrayList<String>();

    public LocalHistoryFacade(LocalVcs vcs, IdeaGateway gw) {
        this.myGateway = gw;
        this.myVcs = vcs;
    }

    public void startRefreshing() {
        this.log("refresh started");
        this.beginChangeSet();
    }

    public void finishRefreshing() {
        this.log("refresh finished");
        this.endChangeSet(LocalHistoryBundle.message("system.label.external.change", new Object[0]));
    }

    public void startCommand() {
        this.log("command started");
        this.beginChangeSet();
    }

    public void finishCommand(String name) {
        this.log("command finished: " + name);
        this.endChangeSet(name);
    }

    public void startAction() {
        this.log("action started (depth=" + this.myChangeSetDepth);
        if (this.myChangeSetDepth == 0) {
            this.myVcs.beginChangeSet();
        }
        this.registerUnsavedDocumentChanges();
        this.myVcs.endChangeSet(null);
        if (this.myChangeSetDepth > 0) {
            this.myVcs.beginChangeSet();
        }
        this.beginChangeSet();
    }

    public void finishAction(String name) {
        this.log("action finished: " + name);
        this.registerUnsavedDocumentChanges();
        this.endChangeSet(name);
    }

    private void registerUnsavedDocumentChanges() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
    }

    public void beginChangeSet() {
        ++this.myChangeSetDepth;
        if (this.myChangeSetDepth == 1) {
            this.myVcs.beginChangeSet();
        }
    }

    public void endChangeSet(String name) {
        if (!this.checkDepthIsValid()) {
            return;
        }
        --this.myChangeSetDepth;
        if (this.myChangeSetDepth == 0) {
            this.myVcs.endChangeSet(name);
        }
    }

    private boolean checkDepthIsValid() {
        if (this.myChangeSetDepth > 0) {
            return true;
        }
        String log = "Depth is invalid: " + this.myChangeSetDepth + "\n";
        for (String s : Reversed.list(this.myLog)) {
            log = log + s + "\n";
        }
        LocalHistoryLog.LOG.warn(log);
        return false;
    }

    public void create(VirtualFile f) {
        if (f.isDirectory()) {
            this.myVcs.createDirectory(f.getPath());
        } else {
            this.myVcs.createFile(f.getPath(), this.contentFactoryFor(f), f.getTimeStamp(), !f.isWritable());
        }
    }

    public void restore(VirtualFile f, Entry e) {
        if (f.isDirectory()) {
            this.myVcs.restoreDirectory(e.getId(), f.getPath());
        } else {
            this.myVcs.restoreFile(e.getId(), f.getPath(), this.contentFactoryFor(f), f.getTimeStamp(), e.isReadOnly());
        }
    }

    public void changeFileContent(VirtualFile f) {
        this.myVcs.changeFileContent(f.getPath(), this.contentFactoryFor(f), f.getTimeStamp());
    }

    private ContentFactory contentFactoryFor(final VirtualFile f) {
        return new ContentFactory(){

            @Override
            public byte[] getBytes() throws IOException {
                return f.contentsToByteArray();
            }

            @Override
            public long getLength() throws IOException {
                return f.getLength();
            }
        };
    }

    public void rename(VirtualFile f, String newName) {
        this.myVcs.rename(f.getPath(), newName);
    }

    public void changeROStatus(VirtualFile f) {
        this.myVcs.changeROStatus(f.getPath(), !f.isWritable());
    }

    public void move(VirtualFile file, VirtualFile newParent) {
        this.myVcs.move(file.getPath(), newParent.getPath());
    }

    public void delete(VirtualFile f) {
        this.myVcs.delete(f.getPath());
    }

    private void log(String s) {
        assert (this.myLog.add(s));
    }
}

