/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.Clock;
import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.history.utils.Reversed;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ChangeList {
    private List<Change> myChanges = new ArrayList<Change>();
    private ChangeSet myCurrentChangeSet;
    private int myChangeSetDepth;

    public ChangeList() {
    }

    public ChangeList(Stream s) throws IOException {
        int count = s.readInteger();
        while (count-- > 0) {
            this.myChanges.add(s.readChange());
        }
    }

    public void write(Stream s) throws IOException {
        s.writeInteger(this.myChanges.size());
        for (Change c : this.myChanges) {
            s.writeChange(c);
        }
    }

    public void addChange(Change c) {
        if (this.myChangeSetDepth == 0) {
            this.myChanges.add(c);
        } else {
            this.myCurrentChangeSet.addChange(c);
        }
    }

    public void beginChangeSet() {
        ++this.myChangeSetDepth;
        if (this.myChangeSetDepth == 1) {
            this.myCurrentChangeSet = new ChangeSet(Clock.getCurrentTimestamp());
            this.myChanges.add(this.myCurrentChangeSet);
        }
    }

    public void endChangeSet(String name) {
        if (this.myChangeSetDepth <= 0) {
            LocalHistoryLog.LOG.warn("Depth is invalid: " + this.myChangeSetDepth + "\n" + "ChangeSet's Name: " + name + "\n" + "Current ChangeSet: " + (this.myCurrentChangeSet == null ? null : Integer.valueOf(this.myCurrentChangeSet.getChanges().size())));
            this.myChangeSetDepth = 0;
            return;
        }
        --this.myChangeSetDepth;
        if (this.myChangeSetDepth == 0) {
            if (this.myCurrentChangeSet.getChanges().isEmpty()) {
                this.myChanges.remove(this.myChanges.size() - 1);
            } else {
                this.myCurrentChangeSet.setName(name);
            }
            this.myCurrentChangeSet = null;
        }
    }

    public List<Change> getChanges() {
        ArrayList<Change> result = new ArrayList<Change>(this.myChanges);
        Collections.reverse(result);
        return result;
    }

    public boolean isBefore(Change before, Change after, boolean canBeEqual) {
        int afterIndex;
        int beforeIndex = this.myChanges.indexOf(before);
        return beforeIndex < (afterIndex = this.myChanges.indexOf(after)) || canBeEqual && beforeIndex == afterIndex;
    }

    public List<Change> getChain(Change initialChange) {
        ArrayList<Change> result = new ArrayList<Change>();
        for (Change c : this.myChanges) {
            if (c == initialChange) {
                result.add(c);
                continue;
            }
            if (!c.affectsSameAs(result)) continue;
            result.add(c);
        }
        return result;
    }

    public AcceptFun getAcceptFunc(Entry root, ChangeVisitor v, boolean copyChangeList) throws IOException {
        return new AcceptFun(v, root.copy(), copyChangeList ? new ArrayList<Change>(this.myChanges) : this.myChanges);
    }

    public List<Change> getChangesFor(Entry root, String path) {
        try {
            ChangeCollectingVisitor v = new ChangeCollectingVisitor(path);
            this.getAcceptFunc(root, v, false).doAccept();
            return v.getResult();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void revertUpTo(Entry r, Change target, boolean revertTargetChange) {
        for (Change c : Reversed.list(this.myChanges)) {
            if (c.revertOnUpTo(r, target, revertTargetChange)) continue;
            return;
        }
    }

    public List<Content> purgeObsolete(long period) {
        int i;
        ArrayList<Change> newChanges = new ArrayList<Change>();
        ArrayList<Content> contentsToPurge = new ArrayList<Content>();
        int index = this.getIndexOfLastObsoleteChange(period);
        for (i = index + 1; i < this.myChanges.size(); ++i) {
            newChanges.add(this.myChanges.get(i));
        }
        for (i = 0; i <= index; ++i) {
            contentsToPurge.addAll(this.myChanges.get(i).getContentsToPurge());
        }
        this.myChanges = newChanges;
        return contentsToPurge;
    }

    private int getIndexOfLastObsoleteChange(long period) {
        long prevTimestamp = 0L;
        long length = 0L;
        for (int i = this.myChanges.size() - 1; i >= 0; --i) {
            Change c = this.myChanges.get(i);
            if (prevTimestamp == 0L) {
                prevTimestamp = c.getTimestamp();
            }
            long delta = prevTimestamp - c.getTimestamp();
            prevTimestamp = c.getTimestamp();
            if ((length += delta < this.getIntervalBetweenActivities() ? delta : 1L) < period) continue;
            return i;
        }
        return -1;
    }

    protected long getIntervalBetweenActivities() {
        return 43200000L;
    }

    private static class ChangeCollectingVisitor
    extends ChangeVisitor {
        private final String myPath;
        private Entry myEntry;
        private IdPath myIdPath;
        private Change myChangeToAdd;
        private boolean myExists = true;
        private boolean myDoNotAddAnythingElseFromCurrentChangeSet = false;
        private final List<Change> myResult = new ArrayList<Change>();

        public ChangeCollectingVisitor(String path) {
            this.myPath = path;
        }

        @Override
        public void started(Entry root) throws IOException {
            super.started(root);
            this.myEntry = this.myRoot.getEntry(this.myPath);
            this.myIdPath = this.myEntry.getIdPath();
        }

        public List<Change> getResult() {
            return new ArrayList<Change>(new LinkedHashSet<Change>(this.myResult));
        }

        @Override
        public void begin(ChangeSet c) {
            this.myChangeToAdd = c;
        }

        @Override
        public void end(ChangeSet c) {
            this.myChangeToAdd = null;
            this.myDoNotAddAnythingElseFromCurrentChangeSet = false;
        }

        @Override
        public void visit(PutLabelChange c) {
            if (this.myChangeToAdd == null) {
                this.myChangeToAdd = c;
                this.doVisit(c);
                this.myChangeToAdd = null;
            } else {
                this.doVisit(c);
            }
        }

        @Override
        public void visit(StructuralChange c) {
            this.doVisit(c);
        }

        private void doVisit(Change c) {
            if (this.skippedDueToNonexistence(c)) {
                return;
            }
            this.addIfAffectsAndRevert(c);
            this.myIdPath = this.myEntry.getIdPath();
        }

        @Override
        public void visit(CreateEntryChange c) {
            if (this.skippedDueToNonexistence(c)) {
                return;
            }
            this.addIfAffectsAndRevert(c);
            if (c.isCreationalFor(this.myIdPath)) {
                this.myExists = false;
            }
        }

        @Override
        public void visit(DeleteChange c) {
            if (this.skippedDueToNonexistence(c)) {
                Entry e;
                if (c.isDeletionOf(this.myIdPath) && (e = this.myRoot.findEntry(this.myIdPath)) != null) {
                    this.myEntry = e;
                    this.myExists = true;
                    this.myDoNotAddAnythingElseFromCurrentChangeSet = true;
                }
                return;
            }
            this.addIfAffectsAndRevert(c);
            this.myIdPath = this.myEntry.getIdPath();
        }

        private void addIfAffectsAndRevert(Change c) {
            if (!this.myDoNotAddAnythingElseFromCurrentChangeSet && c.affects(this.myIdPath)) {
                this.myResult.add(this.myChangeToAdd);
            }
            c.revertOn(this.myRoot);
        }

        private boolean skippedDueToNonexistence(Change c) {
            if (this.myExists) {
                return false;
            }
            c.revertOn(this.myRoot);
            return true;
        }
    }

    public static class AcceptFun {
        private final ChangeVisitor myVisitor;
        private final Entry myRoot;
        private final List<Change> myChanges;

        public AcceptFun(ChangeVisitor visitor, Entry root, List<Change> changes) {
            this.myVisitor = visitor;
            this.myRoot = root;
            this.myChanges = changes;
        }

        public void doAccept() throws IOException {
            this.myVisitor.started(this.myRoot);
            try {
                for (Change change : Reversed.list(this.myChanges)) {
                    change.accept(this.myVisitor);
                }
            }
            catch (ChangeVisitor.StopVisitingException stopVisitingException) {
                // empty catch block
            }
            this.myVisitor.finished();
        }
    }
}

