/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FormatProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatProcessor");
    private LeafBlockWrapper myCurrentBlock;
    private Map<AbstractBlockWrapper, Block> myInfos;
    private CompositeBlockWrapper myRootBlockWrapper;
    private TIntObjectHashMap<LeafBlockWrapper> myTextRangeToWrapper;
    private final CodeStyleSettings.IndentOptions myIndentOption;
    private final CodeStyleSettings mySettings;
    private final Collection<AlignmentImpl> myAlignedAlignments = new HashSet<AlignmentImpl>();
    private LeafBlockWrapper myWrapCandidate = null;
    private LeafBlockWrapper myFirstWrappedBlockOnLine = null;
    private LeafBlockWrapper myFirstTokenBlock;
    private LeafBlockWrapper myLastTokenBlock;
    private SortedMap<TextRange, Pair<AbstractBlockWrapper, Boolean>> myPreviousDependancies = new TreeMap<TextRange, Pair<AbstractBlockWrapper, Boolean>>(new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            int offsetsDelta = o1.getEndOffset() - o2.getEndOffset();
            if (offsetsDelta == 0) {
                offsetsDelta = o2.getStartOffset() - o1.getStartOffset();
            }
            return offsetsDelta;
        }
    });
    private final HashSet<WhiteSpace> myAlignAgain = new HashSet();
    private WhiteSpace myLastWhiteSpace;
    private boolean myDisposed;
    private CodeStyleSettings.IndentOptions myJavaIndentOptions;

    public FormatProcessor(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges) {
        this(docModel, rootBlock, settings, indentOptions, affectedRanges, -1);
    }

    public FormatProcessor(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, int interestingOffset) {
        this.myIndentOption = indentOptions;
        this.mySettings = settings;
        InitialInfoBuilder builder = InitialInfoBuilder.buildBlocks(rootBlock, docModel, affectedRanges, indentOptions, interestingOffset);
        this.myInfos = builder.getBlockToInfoMap();
        this.myRootBlockWrapper = builder.getRootBlockWrapper();
        this.myFirstTokenBlock = builder.getFirstTokenBlock();
        this.myLastTokenBlock = builder.getLastTokenBlock();
        this.myCurrentBlock = this.myFirstTokenBlock;
        this.myTextRangeToWrapper = FormatProcessor.buildTextRangeToInfoMap(this.myFirstTokenBlock);
        this.myLastWhiteSpace = new WhiteSpace(this.getLastBlock().getEndOffset(), false);
        this.myLastWhiteSpace.append(docModel.getTextLength(), docModel, indentOptions);
    }

    private LeafBlockWrapper getLastBlock() {
        LeafBlockWrapper result = this.myFirstTokenBlock;
        while (result.getNextBlock() != null) {
            result = result.getNextBlock();
        }
        return result;
    }

    private static TIntObjectHashMap<LeafBlockWrapper> buildTextRangeToInfoMap(LeafBlockWrapper first) {
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (LeafBlockWrapper current = first; current != null; current = current.getNextBlock()) {
            result.put(current.getStartOffset(), (Object)current);
        }
        return result;
    }

    public void format(FormattingModel model) {
        this.formatWithoutRealModifications();
        this.performModifications(model);
    }

    public void formatWithoutRealModifications() {
        while (true) {
            this.myAlignAgain.clear();
            this.myCurrentBlock = this.myFirstTokenBlock;
            while (this.myCurrentBlock != null) {
                this.processToken();
            }
            if (this.myAlignAgain.isEmpty()) {
                return;
            }
            this.reset();
        }
    }

    private void reset() {
        this.myAlignedAlignments.clear();
        this.myPreviousDependancies.clear();
        this.myWrapCandidate = null;
        if (this.myRootBlockWrapper != null) {
            this.myRootBlockWrapper.reset();
        }
    }

    public void performModifications(FormattingModel model) {
        assert (!this.myDisposed);
        List<LeafBlockWrapper> blocksToModify = this.collectBlocksToModify();
        this.reset();
        this.myInfos = null;
        this.myRootBlockWrapper = null;
        this.myTextRangeToWrapper = null;
        this.myPreviousDependancies = null;
        this.myLastWhiteSpace = null;
        this.myFirstTokenBlock = null;
        this.myLastTokenBlock = null;
        this.myDisposed = true;
        if (this.myJavaIndentOptions == null) {
            this.myJavaIndentOptions = this.mySettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        }
        FormatProcessor.doModify(blocksToModify, model, this.myIndentOption, this.myJavaIndentOptions);
    }

    public void setJavaIndentOptions(CodeStyleSettings.IndentOptions javaIndentOptions) {
        this.myJavaIndentOptions = javaIndentOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doModify(List<LeafBlockWrapper> blocksToModify, FormattingModel model, CodeStyleSettings.IndentOptions indentOption, CodeStyleSettings.IndentOptions javaOptions) {
        DocumentEx updatedDocument;
        int blocksToModifyCount = blocksToModify.size();
        boolean bulkReformat = blocksToModifyCount > 50;
        DocumentEx documentEx = updatedDocument = bulkReformat ? FormatProcessor.getAffectedDocument(model) : null;
        if (updatedDocument != null) {
            updatedDocument.setInBulkUpdate(true);
        }
        try {
            int shift = 0;
            for (int i = 0; i < blocksToModifyCount; ++i) {
                LeafBlockWrapper block = blocksToModify.get(i);
                shift = FormatProcessor.replaceWhiteSpace(model, block, shift, block.getWhiteSpace().generateWhiteSpace(indentOption), javaOptions);
                block.getParent().dispose();
                block.dispose();
                blocksToModify.set(i, null);
            }
        }
        finally {
            if (updatedDocument != null) {
                updatedDocument.setInBulkUpdate(false);
            }
            model.commitChanges();
        }
    }

    private static DocumentEx getAffectedDocument(FormattingModel model) {
        Document document;
        if (model instanceof DocumentBasedFormattingModel && (document = ((DocumentBasedFormattingModel)model).getDocument()) instanceof DocumentEx) {
            return (DocumentEx)document;
        }
        return null;
    }

    private static int replaceWhiteSpace(FormattingModel model, @NotNull LeafBlockWrapper block, int shift, CharSequence _newWhiteSpace, CodeStyleSettings.IndentOptions options) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/formatting/FormatProcessor.replaceWhiteSpace must not be null");
        }
        WhiteSpace whiteSpace = block.getWhiteSpace();
        TextRange textRange = whiteSpace.getTextRange();
        TextRange wsRange = FormatProcessor.shiftRange(textRange, shift);
        String newWhiteSpace = ((Object)_newWhiteSpace).toString();
        TextRange newWhiteSpaceRange = model.replaceWhiteSpace(wsRange, newWhiteSpace);
        shift += newWhiteSpaceRange.getLength() - textRange.getLength();
        if (block.isLeaf() && whiteSpace.containsLineFeeds() && block.containsLineFeeds()) {
            TextRange currentBlockRange = FormatProcessor.shiftRange(block.getTextRange(), shift);
            IndentInside lastLineIndent = block.getLastLineIndent();
            IndentInside whiteSpaceIndent = IndentInside.createIndentOn(IndentInside.getLastLine(newWhiteSpace));
            int shiftInside = FormatProcessor.calcShift(lastLineIndent, whiteSpaceIndent, options);
            TextRange newBlockRange = model.shiftIndentInsideRange(currentBlockRange, shiftInside);
            shift += newBlockRange.getLength() - block.getLength();
        }
        return shift;
    }

    private List<LeafBlockWrapper> collectBlocksToModify() {
        ArrayList<LeafBlockWrapper> blocksToModify = new ArrayList<LeafBlockWrapper>();
        for (LeafBlockWrapper block = this.myFirstTokenBlock; block != null; block = block.getNextBlock()) {
            String newWhiteSpace;
            WhiteSpace whiteSpace = block.getWhiteSpace();
            if (whiteSpace.isReadOnly() || whiteSpace.equalsToString(newWhiteSpace = whiteSpace.generateWhiteSpace(this.myIndentOption))) continue;
            blocksToModify.add(block);
        }
        return blocksToModify;
    }

    private static TextRange shiftRange(TextRange textRange, int shift) {
        return new TextRange(textRange.getStartOffset() + shift, textRange.getEndOffset() + shift);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processToken() {
        SpacingImpl spaceProperty = this.myCurrentBlock.getSpaceProperty();
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        whiteSpace.arrangeLineFeeds(spaceProperty, this);
        if (!whiteSpace.containsLineFeeds()) {
            whiteSpace.arrangeSpaces(spaceProperty);
        }
        try {
            if (this.processWrap(spaceProperty)) {
                return;
            }
        }
        finally {
            if (whiteSpace.containsLineFeeds()) {
                this.onCurrentLineChanged();
            }
        }
        if (whiteSpace.containsLineFeeds()) {
            this.adjustLineIndent();
        } else {
            whiteSpace.arrangeSpaces(spaceProperty);
        }
        this.setAlignOffset(this.myCurrentBlock);
        if (this.myCurrentBlock.containsLineFeeds()) {
            this.onCurrentLineChanged();
        }
        if (FormatProcessor.shouldSaveDependancy(spaceProperty, whiteSpace)) {
            this.saveDependancy(spaceProperty);
        }
        if (!whiteSpace.isIsReadOnly() && this.shouldReformatBecauseOfBackwardDependance(whiteSpace.getTextRange())) {
            this.myAlignAgain.add(whiteSpace);
        } else if (!this.myAlignAgain.isEmpty()) {
            this.myAlignAgain.remove(whiteSpace);
        }
        this.myCurrentBlock = this.myCurrentBlock.getNextBlock();
    }

    private boolean shouldReformatBecauseOfBackwardDependance(TextRange changed) {
        SortedMap<TextRange, Pair<AbstractBlockWrapper, Boolean>> sortedHeadMap = this.myPreviousDependancies.tailMap(changed);
        for (Map.Entry<TextRange, Pair<AbstractBlockWrapper, Boolean>> entry : sortedHeadMap.entrySet()) {
            boolean containsLineFeeds;
            Pair<AbstractBlockWrapper, Boolean> pair;
            boolean containedLineFeeds;
            TextRange textRange = entry.getKey();
            if (!textRange.contains(changed) || (containedLineFeeds = ((Boolean)(pair = entry.getValue()).getSecond()).booleanValue()) == (containsLineFeeds = this.containsLineFeeds(textRange))) continue;
            return true;
        }
        return false;
    }

    private void saveDependancy(SpacingImpl spaceProperty) {
        DependantSpacingImpl dependantSpaceProperty = (DependantSpacingImpl)spaceProperty;
        TextRange dependancy = dependantSpaceProperty.getDependancy();
        if (dependantSpaceProperty.wasLFUsed()) {
            this.myPreviousDependancies.put(dependancy, (Pair<AbstractBlockWrapper, Boolean>)new Pair((Object)this.myCurrentBlock, (Object)Boolean.TRUE));
        } else {
            boolean value = this.containsLineFeeds(dependancy);
            if (value) {
                dependantSpaceProperty.setLFWasUsed(true);
            }
            this.myPreviousDependancies.put(dependancy, (Pair<AbstractBlockWrapper, Boolean>)new Pair((Object)this.myCurrentBlock, (Object)value));
        }
    }

    private static boolean shouldSaveDependancy(SpacingImpl spaceProperty, WhiteSpace whiteSpace) {
        if (!(spaceProperty instanceof DependantSpacingImpl)) {
            return false;
        }
        if (whiteSpace.isReadOnly() || whiteSpace.isLineFeedsAreReadOnly()) {
            return false;
        }
        TextRange dependancy = ((DependantSpacingImpl)spaceProperty).getDependancy();
        return whiteSpace.getStartOffset() < dependancy.getEndOffset();
    }

    private boolean processWrap(Spacing spacing) {
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        boolean wrapWasPresent = whiteSpace.containsLineFeeds();
        if (wrapWasPresent) {
            this.myFirstWrappedBlockOnLine = null;
        }
        if (whiteSpace.containsLineFeeds() && !whiteSpace.containsLineFeedsInitially()) {
            whiteSpace.removeLineFeeds(spacing, this);
        }
        boolean wrapIsPresent = whiteSpace.containsLineFeeds();
        ArrayList<WrapImpl> wraps = this.myCurrentBlock.getWraps();
        int wrapsCount = wraps.size();
        for (int i = 0; i < wrapsCount; ++i) {
            wraps.get(i).processNextEntry(this.myCurrentBlock.getStartOffset());
        }
        WrapImpl wrap = this.getWrapToBeUsed(wraps);
        if (wrap != null || wrapIsPresent) {
            if (!wrapIsPresent && !this.canReplaceWrapCandidate(wrap)) {
                this.myCurrentBlock = this.myWrapCandidate;
                return true;
            }
            if (wrap != null && wrap.getFirstEntry() != null) {
                this.myCurrentBlock = this.getFirstBlockOnNewLine();
                wrap.markAsUsed();
                return true;
            }
            if (wrap != null && this.wrapCanBeUsedInTheFuture(wrap)) {
                wrap.markAsUsed();
            }
            if (!whiteSpace.containsLineFeeds()) {
                whiteSpace.ensureLineFeed();
                if (!wrapWasPresent && wrap != null) {
                    if (this.myFirstWrappedBlockOnLine != null && wrap.isChildOf(this.myFirstWrappedBlockOnLine.getWrap(), this.myCurrentBlock)) {
                        wrap.ignoreParentWrap(this.myFirstWrappedBlockOnLine.getWrap(), this.myCurrentBlock);
                        this.myCurrentBlock = this.myFirstWrappedBlockOnLine;
                        return true;
                    }
                    this.myFirstWrappedBlockOnLine = this.myCurrentBlock;
                }
            }
            this.myWrapCandidate = null;
        } else {
            for (int i = 0; i < wrapsCount; ++i) {
                WrapImpl wrap1 = wraps.get(i);
                if (this.isCandidateToBeWrapped(wrap1) && this.canReplaceWrapCandidate(wrap1)) {
                    this.myWrapCandidate = this.myCurrentBlock;
                }
                if (!this.wrapCanBeUsedInTheFuture(wrap1)) continue;
                wrap1.saveFirstEntry(this.myCurrentBlock);
            }
        }
        if (!whiteSpace.containsLineFeeds() && this.myWrapCandidate != null && !whiteSpace.isReadOnly() && this.lineOver()) {
            this.myCurrentBlock = this.myWrapCandidate;
            return true;
        }
        return false;
    }

    private LeafBlockWrapper getFirstBlockOnNewLine() {
        for (LeafBlockWrapper current = this.myCurrentBlock; current != null; current = current.getPreviousBlock()) {
            WhiteSpace whiteSpace = current.getWhiteSpace();
            if (whiteSpace.containsLineFeeds() && whiteSpace.containsLineFeedsInitially()) {
                return current;
            }
            if (current.getPreviousBlock() != null) continue;
            return current;
        }
        return null;
    }

    private boolean canReplaceWrapCandidate(WrapImpl wrap) {
        if (this.myWrapCandidate == null) {
            return true;
        }
        WrapImpl.Type type = wrap.getType();
        if (wrap.isIsActive() && (type == WrapImpl.Type.CHOP_IF_NEEDED || type == WrapImpl.Type.WRAP_ALWAYS)) {
            return true;
        }
        WrapImpl currentWrap = this.myWrapCandidate.getWrap();
        return wrap == currentWrap || !wrap.isChildOf(currentWrap, this.myCurrentBlock);
    }

    private boolean isCandidateToBeWrapped(WrapImpl wrap) {
        return this.isSuitableInTheCurrentPosition(wrap) && (wrap.getType() == WrapImpl.Type.WRAP_AS_NEEDED || wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED) && !this.myCurrentBlock.getWhiteSpace().isReadOnly();
    }

    private void onCurrentLineChanged() {
        this.myAlignedAlignments.clear();
        this.myWrapCandidate = null;
    }

    private void adjustLineIndent() {
        IndentData alignOffset = this.getAlignOffset();
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (alignOffset == null) {
            IndentData offset = this.myCurrentBlock.calculateOffset(this.myIndentOption);
            whiteSpace.setSpaces(offset.getSpaces(), offset.getIndentSpaces());
        } else {
            whiteSpace.setSpaces(alignOffset.getSpaces(), alignOffset.getIndentSpaces());
        }
    }

    @Nullable
    private AbstractBlockWrapper getPreviousIndentedBlock() {
        for (CompositeBlockWrapper current = this.myCurrentBlock.getParent(); current != null; current = current.getParent()) {
            AbstractBlockWrapper prevIndented;
            if (current.getStartOffset() != this.myCurrentBlock.getStartOffset() && current.getWhiteSpace().containsLineFeeds()) {
                return current;
            }
            if (current.getParent() == null || (prevIndented = current.getParent().getPrevIndentedSibling(current)) == null) continue;
            return prevIndented;
        }
        return null;
    }

    private boolean wrapCanBeUsedInTheFuture(WrapImpl wrap) {
        return wrap != null && wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED && this.isSuitableInTheCurrentPosition(wrap);
    }

    private boolean isSuitableInTheCurrentPosition(WrapImpl wrap) {
        if (wrap.getFirstPosition() < this.myCurrentBlock.getStartOffset()) {
            return true;
        }
        if (wrap.isWrapFirstElement()) {
            return true;
        }
        if (wrap.getType() == WrapImpl.Type.WRAP_AS_NEEDED) {
            return this.positionAfterWrappingIsSutable();
        }
        return wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED && this.lineOver() && this.positionAfterWrappingIsSutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean positionAfterWrappingIsSutable() {
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (whiteSpace.containsLineFeeds()) {
            return true;
        }
        int spaces = whiteSpace.getSpaces();
        int indentSpaces = whiteSpace.getIndentSpaces();
        boolean result = true;
        try {
            int offsetBefore = FormatProcessor.getOffsetBefore(this.myCurrentBlock);
            whiteSpace.ensureLineFeed();
            this.adjustLineIndent();
            int offsetAfter = FormatProcessor.getOffsetBefore(this.myCurrentBlock);
            if (offsetBefore <= offsetAfter) {
                result = false;
            }
        }
        finally {
            whiteSpace.removeLineFeeds(this.myCurrentBlock.getSpaceProperty(), this);
            whiteSpace.setSpaces(spaces, indentSpaces);
        }
        return result;
    }

    @Nullable
    private WrapImpl getWrapToBeUsed(ArrayList<WrapImpl> wraps) {
        int wrapsCount = wraps.size();
        if (wrapsCount == 0) {
            return null;
        }
        if (this.myWrapCandidate == this.myCurrentBlock) {
            return wraps.get(0);
        }
        for (int i = 0; i < wrapsCount; ++i) {
            WrapImpl wrap = wraps.get(i);
            if (!this.isSuitableInTheCurrentPosition(wrap)) continue;
            if (wrap.isIsActive()) {
                return wrap;
            }
            WrapImpl.Type type = wrap.getType();
            if (type == WrapImpl.Type.WRAP_ALWAYS) {
                return wrap;
            }
            if (type != WrapImpl.Type.WRAP_AS_NEEDED && type != WrapImpl.Type.CHOP_IF_NEEDED || !this.lineOver()) continue;
            return wrap;
        }
        return null;
    }

    private boolean lineOver() {
        return !this.myCurrentBlock.containsLineFeeds() && FormatProcessor.getOffsetBefore(this.myCurrentBlock) + this.myCurrentBlock.getLength() > this.mySettings.RIGHT_MARGIN;
    }

    private static int getOffsetBefore(LeafBlockWrapper info) {
        if (info != null) {
            int result = 0;
            do {
                WhiteSpace whiteSpace = info.getWhiteSpace();
                result += whiteSpace.getTotalSpaces();
                if (whiteSpace.containsLineFeeds()) {
                    return result;
                }
                if ((info = info.getPreviousBlock()) == null) {
                    return result;
                }
                result += info.getSymbolsAtTheLastLine();
            } while (!info.containsLineFeeds());
            return result;
        }
        return -1;
    }

    private void setAlignOffset(LeafBlockWrapper block) {
        AbstractBlockWrapper current = this.myCurrentBlock;
        do {
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) != null && !this.myAlignedAlignments.contains((Object)alignment)) {
                alignment.setOffsetRespBlock(block);
                this.myAlignedAlignments.add(alignment);
            }
            if ((current = current.getParent()) != null) continue;
            return;
        } while (current.getStartOffset() == this.myCurrentBlock.getStartOffset());
    }

    @Nullable
    private IndentData getAlignOffset() {
        AbstractBlockWrapper current = this.myCurrentBlock;
        do {
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) != null && alignment.getOffsetRespBlockBefore(this.myCurrentBlock) != null) {
                LeafBlockWrapper block = alignment.getOffsetRespBlockBefore(this.myCurrentBlock);
                WhiteSpace whiteSpace = block.getWhiteSpace();
                if (whiteSpace.containsLineFeeds()) {
                    return new IndentData(whiteSpace.getIndentSpaces(), whiteSpace.getSpaces());
                }
                int offsetBeforeBlock = FormatProcessor.getOffsetBefore(block);
                AbstractBlockWrapper prevIndentedBlock = this.getPreviousIndentedBlock();
                if (prevIndentedBlock == null) {
                    return new IndentData(0, offsetBeforeBlock);
                }
                int parentIndent = prevIndentedBlock.getWhiteSpace().getIndentOffset();
                if (parentIndent > offsetBeforeBlock) {
                    return new IndentData(0, offsetBeforeBlock);
                }
                return new IndentData(parentIndent, offsetBeforeBlock - parentIndent);
            }
            if ((current = current.getParent()) != null) continue;
            return null;
        } while (current.getStartOffset() == this.myCurrentBlock.getStartOffset());
        return null;
    }

    public boolean containsLineFeeds(TextRange dependance) {
        LeafBlockWrapper child = (LeafBlockWrapper)this.myTextRangeToWrapper.get(dependance.getStartOffset());
        if (child == null) {
            return false;
        }
        if (child.containsLineFeeds()) {
            return true;
        }
        int endOffset = dependance.getEndOffset();
        while (child.getEndOffset() < endOffset) {
            if ((child = child.getNextBlock()) == null) {
                return false;
            }
            if (child.getWhiteSpace().containsLineFeeds()) {
                return true;
            }
            if (!child.containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public LeafBlockWrapper getBlockAfter(int startOffset) {
        LeafBlockWrapper prevBlock;
        LeafBlockWrapper result = null;
        for (int current = startOffset; current < this.myLastWhiteSpace.getStartOffset(); ++current) {
            LeafBlockWrapper currentValue = (LeafBlockWrapper)this.myTextRangeToWrapper.get(current);
            if (currentValue == null) continue;
            result = currentValue;
            break;
        }
        if ((prevBlock = this.getPrevBlock(result)) != null && prevBlock.contains(startOffset)) {
            return prevBlock;
        }
        return result;
    }

    private LeafBlockWrapper getPrevBlock(LeafBlockWrapper result) {
        if (result != null) {
            return result.getPreviousBlock();
        }
        return this.myLastTokenBlock;
    }

    public void setAllWhiteSpacesAreReadOnly() {
        for (LeafBlockWrapper current = this.myFirstTokenBlock; current != null; current = current.getNextBlock()) {
            current.getWhiteSpace().setReadOnly(true);
        }
    }

    public IndentInfo getIndentAt(int offset) {
        this.processBlocksBefore(offset);
        AbstractBlockWrapper parent = this.getParentFor(offset, this.myCurrentBlock);
        if (parent == null) {
            LeafBlockWrapper previousBlock = this.myCurrentBlock.getPreviousBlock();
            if (previousBlock != null) {
                parent = this.getParentFor(offset, previousBlock);
            }
            if (parent == null) {
                return new IndentInfo(0, 0, 0);
            }
        }
        int index = FormatProcessor.getNewChildPosition(parent, offset);
        Block block = this.myInfos.get(parent);
        if (block == null) {
            return new IndentInfo(0, 0, 0);
        }
        ChildAttributesInfo info = FormatProcessor.getChildAttributesInfo(block, index, parent);
        return this.adjustLineIndent(info.parent, info.attributes, info.index);
    }

    private static ChildAttributesInfo getChildAttributesInfo(Block block, int index, AbstractBlockWrapper parent) {
        ChildAttributes childAttributes = block.getChildAttributes(index);
        if (childAttributes == ChildAttributes.DELEGATE_TO_PREV_CHILD) {
            Block newBlock = (Block)block.getSubBlocks().get(index - 1);
            return FormatProcessor.getChildAttributesInfo(newBlock, newBlock.getSubBlocks().size(), ((CompositeBlockWrapper)parent).getChildren().get(index - 1));
        }
        if (childAttributes == ChildAttributes.DELEGATE_TO_NEXT_CHILD) {
            return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, ((CompositeBlockWrapper)parent).getChildren().get(index));
        }
        return new ChildAttributesInfo(parent, childAttributes, index);
    }

    private IndentInfo adjustLineIndent(AbstractBlockWrapper parent, ChildAttributes childAttributes, int index) {
        int alignOffset = FormatProcessor.getAlignOffsetBefore(childAttributes.getAlignment(), null);
        if (alignOffset == -1) {
            return parent.calculateChildOffset(this.myIndentOption, childAttributes, index).createIndentInfo();
        }
        AbstractBlockWrapper previousIndentedBlock = this.getPreviousIndentedBlock();
        if (previousIndentedBlock == null) {
            return new IndentInfo(0, 0, alignOffset);
        }
        int indentOffset = previousIndentedBlock.getWhiteSpace().getIndentOffset();
        if (indentOffset > alignOffset) {
            return new IndentInfo(0, 0, alignOffset);
        }
        return new IndentInfo(0, indentOffset, alignOffset - indentOffset);
    }

    private static int getAlignOffsetBefore(Alignment alignment, LeafBlockWrapper blockAfter) {
        if (alignment == null) {
            return -1;
        }
        LeafBlockWrapper alignRespBlock = ((AlignmentImpl)alignment).getOffsetRespBlockBefore(blockAfter);
        if (alignRespBlock != null) {
            return FormatProcessor.getOffsetBefore(alignRespBlock);
        }
        return -1;
    }

    private static int getNewChildPosition(AbstractBlockWrapper parent, int offset) {
        if (!(parent instanceof CompositeBlockWrapper)) {
            return 0;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parent).getChildren();
        if (subBlocks != null) {
            for (int i = 0; i < subBlocks.size(); ++i) {
                AbstractBlockWrapper block = subBlocks.get(i);
                if (block.getStartOffset() < offset) continue;
                return i;
            }
            return subBlocks.size();
        }
        return 0;
    }

    @Nullable
    private static AbstractBlockWrapper getParentFor(int offset, AbstractBlockWrapper block) {
        for (AbstractBlockWrapper current = block; current != null; current = current.getParent()) {
            if (current.getStartOffset() >= offset || current.getEndOffset() < offset) continue;
            return current;
        }
        return null;
    }

    @Nullable
    private AbstractBlockWrapper getParentFor(int offset, LeafBlockWrapper block) {
        AbstractBlockWrapper previous = this.getPreviousIncompletedBlock(block, offset);
        if (previous != null) {
            return previous;
        }
        return FormatProcessor.getParentFor(offset, block);
    }

    @Nullable
    private AbstractBlockWrapper getPreviousIncompletedBlock(LeafBlockWrapper block, int offset) {
        if (block == null) {
            if (this.myLastTokenBlock.isIncomplete()) {
                return this.myLastTokenBlock;
            }
            return null;
        }
        AbstractBlockWrapper current = block;
        while (current.getParent() != null && current.getParent().getStartOffset() > offset) {
            current = current.getParent();
        }
        if (current.getParent() == null) {
            return null;
        }
        if (current.getEndOffset() <= offset) {
            while (!current.isIncomplete() && current.getParent() != null && current.getParent().getEndOffset() <= offset) {
                current = current.getParent();
            }
            if (current.isIncomplete()) {
                return current;
            }
        }
        if (current.getParent() == null) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = current.getParent().getChildren();
        int index = subBlocks.indexOf(current);
        if (index < 0) {
            LOG.assertTrue(false);
        }
        if (index == 0) {
            return null;
        }
        AbstractBlockWrapper currentResult = subBlocks.get(index - 1);
        if (!currentResult.isIncomplete()) {
            return null;
        }
        AbstractBlockWrapper lastChild = FormatProcessor.getLastChildOf(currentResult);
        while (lastChild != null && lastChild.isIncomplete()) {
            currentResult = lastChild;
            lastChild = FormatProcessor.getLastChildOf(currentResult);
        }
        return currentResult;
    }

    @Nullable
    private static AbstractBlockWrapper getLastChildOf(AbstractBlockWrapper currentResult) {
        if (!(currentResult instanceof CompositeBlockWrapper)) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)currentResult).getChildren();
        if (subBlocks.isEmpty()) {
            return null;
        }
        return subBlocks.get(subBlocks.size() - 1);
    }

    private void processBlocksBefore(int offset) {
        while (true) {
            this.myAlignAgain.clear();
            this.myCurrentBlock = this.myFirstTokenBlock;
            while (this.myCurrentBlock != null && this.myCurrentBlock.getStartOffset() < offset) {
                this.processToken();
                if (this.myCurrentBlock != null) continue;
                this.myCurrentBlock = this.myLastTokenBlock;
                break;
            }
            if (this.myAlignAgain.isEmpty()) {
                return;
            }
            this.reset();
        }
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myFirstTokenBlock;
    }

    public WhiteSpace getLastWhiteSpace() {
        return this.myLastWhiteSpace;
    }

    private static int calcShift(IndentInside lastLineIndent, IndentInside whiteSpaceIndent, CodeStyleSettings.IndentOptions options) {
        if (lastLineIndent.equals(whiteSpaceIndent)) {
            return 0;
        }
        if (options.USE_TAB_CHARACTER) {
            if (lastLineIndent.whiteSpaces > 0) {
                return whiteSpaceIndent.getSpacesCount(options);
            }
            return whiteSpaceIndent.tabs - lastLineIndent.tabs;
        }
        if (lastLineIndent.tabs > 0) {
            return whiteSpaceIndent.getTabsCount(options);
        }
        return whiteSpaceIndent.whiteSpaces - lastLineIndent.whiteSpaces;
    }

    static class ChildAttributesInfo {
        public final AbstractBlockWrapper parent;
        final ChildAttributes attributes;
        final int index;

        public ChildAttributesInfo(AbstractBlockWrapper parent, ChildAttributes attributes, int index) {
            this.parent = parent;
            this.attributes = attributes;
            this.index = index;
        }
    }
}

