/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandler;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private final FindUsagesOptions myFindClassOptions;
    private final FindUsagesOptions myFindMethodOptions;
    private final FindUsagesOptions myFindPackageOptions;
    private final FindUsagesOptions myFindThrowOptions;
    private final FindUsagesOptions myFindVariableOptions;

    public static JavaFindUsagesHandlerFactory getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandlerFactory.getInstance must not be null");
        }
        return (JavaFindUsagesHandlerFactory)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)EP_NAME, (AreaInstance)project), JavaFindUsagesHandlerFactory.class);
    }

    public JavaFindUsagesHandlerFactory(Project project) {
        FindUsagesOptions findClassOptions = FindUsagesHandler.createFindUsagesOptions(project);
        FindUsagesOptions findMethodOptions = FindUsagesHandler.createFindUsagesOptions(project);
        findMethodOptions.isCheckDeepInheritance = false;
        findMethodOptions.isIncludeSubpackages = false;
        findMethodOptions.isSearchForTextOccurences = false;
        FindUsagesOptions findPackageOptions = FindUsagesHandler.createFindUsagesOptions(project);
        FindUsagesOptions findThrowOptions = FindUsagesHandler.createFindUsagesOptions(project);
        findThrowOptions.isSearchForTextOccurences = false;
        findThrowOptions.isThrowUsages = true;
        FindUsagesOptions findVariableOptions = FindUsagesHandler.createFindUsagesOptions(project);
        findVariableOptions.isCheckDeepInheritance = false;
        findVariableOptions.isIncludeSubpackages = false;
        findVariableOptions.isSearchForTextOccurences = false;
        this.myFindClassOptions = findClassOptions;
        this.myFindMethodOptions = findMethodOptions;
        this.myFindPackageOptions = findPackageOptions;
        this.myFindThrowOptions = findThrowOptions;
        this.myFindVariableOptions = findVariableOptions;
    }

    @Override
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandlerFactory.canFindUsages must not be null");
        }
        return new JavaFindUsagesProvider().canFindUsagesFor(element);
    }

    @Override
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandlerFactory.createFindUsagesHandler must not be null");
        }
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage == null ? null : new JavaFindUsagesHandler((PsiElement)psiPackage, this.myFindClassOptions, this.myFindMethodOptions, this.myFindPackageOptions, this.myFindThrowOptions, this.myFindVariableOptions);
        }
        if (element instanceof PsiMethod && !forHighlightUsages) {
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)element, JavaFindUsagesHandler.ACTION_STRING);
            if (methods.length > 1) {
                return new JavaFindUsagesHandler(element, (PsiElement[])methods, this.myFindClassOptions, this.myFindMethodOptions, this.myFindPackageOptions, this.myFindThrowOptions, this.myFindVariableOptions);
            }
            if (methods.length == 1) {
                return new JavaFindUsagesHandler((PsiElement)methods[0], this.myFindClassOptions, this.myFindMethodOptions, this.myFindPackageOptions, this.myFindThrowOptions, this.myFindVariableOptions);
            }
            return FindUsagesHandler.NULL_HANDLER;
        }
        return new JavaFindUsagesHandler(element, this.myFindClassOptions, this.myFindMethodOptions, this.myFindPackageOptions, this.myFindThrowOptions, this.myFindVariableOptions);
    }

    public FindUsagesOptions getFindClassOptions() {
        return this.myFindClassOptions;
    }

    public FindUsagesOptions getFindMethodOptions() {
        return this.myFindMethodOptions;
    }

    public FindUsagesOptions getFindPackageOptions() {
        return this.myFindPackageOptions;
    }

    public FindUsagesOptions getFindThrowOptions() {
        return this.myFindThrowOptions;
    }

    public FindUsagesOptions getFindVariableOptions() {
        return this.myFindVariableOptions;
    }
}

