/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.RestoreViewAction;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerContentUi
implements ContentUI,
Disposable,
CellTransform.Facade,
ViewContextEx,
PropertyChangeListener {
    @NonNls
    public static final String LAYOUT = "Runner.Layout";
    @NonNls
    public static final String VIEW_POPUP = "Runner.View.Popup";
    @NonNls
    public static final String VIEW_TOOLBAR = "Runner.View.Toolbar";
    ContentManager myManager;
    RunnerLayout myLayoutSettings;
    ActionManager myActionManager;
    String mySessionName;
    MyComponent myComponent = new MyComponent();
    private final Wrapper myToolbar = new Wrapper();
    JBTabs myTabs;
    private final Comparator<TabInfo> myTabsComparator = new Comparator<TabInfo>(){

        @Override
        public int compare(TabInfo o1, TabInfo o2) {
            return RunnerContentUi.this.getTabFor(o1).getIndex() - RunnerContentUi.this.getTabFor(o2).getIndex();
        }
    };
    Project myProject;
    ActionGroup myTopActions = new DefaultActionGroup();
    DefaultActionGroup myMinimizedViewActions = new DefaultActionGroup();
    Map<GridImpl, Wrapper> myMinimizedButtonsPlaceholder = new HashMap<GridImpl, Wrapper>();
    Map<GridImpl, Wrapper> myCommonActionsPlaceholder = new HashMap<GridImpl, Wrapper>();
    Map<GridImpl, Set<Content>> myContextActions = new HashMap<GridImpl, Set<Content>>();
    boolean myUiLastStateWasRestored;
    private final Set<Object> myRestoreStateRequestors = new HashSet<Object>();
    public static final DataKey<RunnerContentUi> KEY = DataKey.create((String)"DebuggerContentUI");
    private String myActionsPlace = "unknown";
    private final IdeFocusManager myFocusManager;
    private boolean myMinimizeActionEnabled = true;
    private boolean myMoveToGridActionEnabled = true;
    private final RunnerLayoutUi myRunnerUi;
    private final Map<String, LayoutAttractionPolicy> myAttractions = new HashMap<String, LayoutAttractionPolicy>();
    private final Map<String, LayoutAttractionPolicy> myConditionAttractions = new HashMap<String, LayoutAttractionPolicy>();
    private ActionGroup myAdditonalFocusActions;
    private final ActionCallback myInitialized = new ActionCallback();
    private boolean myToDisposeRemovedContent = true;
    private int myAttractionCount;
    int consoleCount;

    public RunnerContentUi(Project project, RunnerLayoutUi ui, ActionManager actionManager, IdeFocusManager focusManager, RunnerLayout settings, String sessionName) {
        this.myProject = project;
        this.myRunnerUi = ui;
        this.myLayoutSettings = settings;
        this.myActionManager = actionManager;
        this.mySessionName = sessionName;
        this.myFocusManager = focusManager;
    }

    public void setTopActions(@NotNull ActionGroup topActions, @NotNull String place) {
        if (topActions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerContentUi.setTopActions must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerContentUi.setTopActions must not be null");
        }
        this.myTopActions = topActions;
        this.myActionsPlace = place;
        this.rebuildCommonActions();
    }

    public void setAdditionalFocusActions(ActionGroup group) {
        this.myAdditonalFocusActions = group;
        this.rebuildTabPopup();
    }

    public void setLeftToolbar(ActionGroup group, String place) {
        ActionToolbar tb = this.myActionManager.createActionToolbar(place, group, false);
        tb.setTargetComponent((JComponent)((Object)this.myComponent));
        this.myToolbar.setContent(tb.getComponent());
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void initUi() {
        if (this.myTabs != null) {
            return;
        }
        this.myTabs = new JBTabsImpl(this.myProject, this.myActionManager, this.myFocusManager, (Disposable)this).setDataProvider(new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (ViewContext.CONTENT_KEY.is(dataId)) {
                    TabInfo info = RunnerContentUi.this.myTabs.getTargetInfo();
                    if (info != null) {
                        return RunnerContentUi.this.getGridFor(info).getData(dataId);
                    }
                } else if (ViewContext.CONTEXT_KEY.is(dataId)) {
                    return RunnerContentUi.this;
                }
                return null;
            }
        }).setInnerInsets(new Insets(1, 0, 0, 0)).setToDrawBorderIfTabsHidden(false).setUiDecorator(new UiDecorator(){

            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(1, 8, 1, 8));
                if (uiDecoration == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerContentUi$2.getDecoration must not return null");
                }
                return uiDecoration;
            }
        }).getJBTabs();
        this.rebuildTabPopup();
        this.myTabs.getPresentation().setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(2).setPaintFocus(false).setRequestFocusOnLastFocusedComponent(true);
        NonOpaquePanel wrappper = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 0));
        wrappper.add((Component)this.myToolbar, (Object)"West");
        wrappper.add((Component)this.myTabs.getComponent(), (Object)"Center");
        this.myComponent.setContent((JComponent)wrappper);
        this.myTabs.addListener(new TabsListener(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridImpl grid;
                if (oldSelection != null && !RunnerContentUi.this.isStateBeingRestored() && (grid = RunnerContentUi.this.getGridFor(oldSelection)) != null) {
                    grid.saveUiState();
                }
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (!RunnerContentUi.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                    RunnerContentUi.this.getGridFor(newSelection).processAddToUi(false);
                }
                if (oldSelection != null) {
                    RunnerContentUi.this.getGridFor(oldSelection).processRemoveFromUi();
                }
            }
        });
    }

    private void rebuildTabPopup() {
        this.myTabs.setPopupGroup(this.getCellPopupGroup("debuggerTabPopup"), "debuggerTabPopup", true);
        ArrayList<GridImpl> grids = this.getGrids();
        for (GridImpl each : grids) {
            each.rebuildTabPopup();
        }
    }

    @Override
    public ActionGroup getCellPopupGroup(String place) {
        ActionGroup original = (ActionGroup)this.myActionManager.getAction(VIEW_POPUP);
        ActionGroup focusPlaceholder = (ActionGroup)this.myActionManager.getAction("Runner.Focus");
        DefaultActionGroup group = new DefaultActionGroup(VIEW_POPUP, original.isPopup());
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), place, new Presentation(), ActionManager.getInstance(), 0);
        AnAction[] originalActions = original.getChildren(event);
        for (int i = 0; i < originalActions.length; ++i) {
            AnAction each = originalActions[i];
            if (each == focusPlaceholder) {
                AnAction[] addins;
                AnAction[] focusActions;
                for (AnAction eachFocus : focusActions = ((ActionGroup)each).getChildren(event)) {
                    group.add(eachFocus);
                }
                if (this.myAdditonalFocusActions == null) continue;
                for (AnAction eachAddin : addins = this.myAdditonalFocusActions.getChildren(event)) {
                    group.add(eachAddin);
                }
                continue;
            }
            group.add(each);
        }
        return group;
    }

    @Override
    public void doWhenInitialized(Runnable runnable) {
        this.myInitialized.doWhenDone(runnable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Content content = (Content)evt.getSource();
        GridImpl grid = this.getGridFor(content, false);
        if (grid == null) {
            return;
        }
        GridCellImpl cell = grid.findCell(content);
        if (cell == null) {
            return;
        }
        String property = evt.getPropertyName();
        if ("alerting".equals(property)) {
            this.attract(content, true);
        } else if ("displayName".equals(property) || "icon".equals(property) || "actions".equals(property) || "description".equals(property)) {
            cell.updateTabPresentation(content);
            this.updateTabsUI(false);
        }
    }

    public void processBounce(Content content, boolean activate) {
        GridImpl grid = this.getGridFor(content, false);
        if (grid == null) {
            return;
        }
        GridCellImpl cell = grid.findCell(content);
        if (cell == null) {
            return;
        }
        TabInfo tab = this.myTabs.findInfo((Component)((Object)grid));
        if (tab == null) {
            return;
        }
        if (this.getSelectedGrid() != grid) {
            tab.setAlertIcon(content.getAlertIcon());
            if (activate) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        } else {
            grid.processAlert(content, activate);
        }
    }

    public JComponent getComponent() {
        this.initUi();
        return this.myComponent;
    }

    public void setManager(ContentManager manager) {
        assert (this.myManager == null);
        this.myManager = manager;
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(ContentManagerEvent event) {
                GridImpl grid = RunnerContentUi.this.getGridFor(event.getContent(), true);
                grid.add(event.getContent(), false);
                if (RunnerContentUi.this.getSelectedGrid() == grid) {
                    grid.processAddToUi(false);
                }
                RunnerContentUi.this.updateTabsUI(false);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
            }

            public void contentRemoved(ContentManagerEvent event) {
                event.getContent().removePropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                GridImpl grid = (GridImpl)RunnerContentUi.this.findGridFor(event.getContent());
                if (grid != null) {
                    grid.remove(event.getContent());
                    grid.processRemoveFromUi();
                    RunnerContentUi.this.removeGridIfNeeded(grid);
                }
                RunnerContentUi.this.updateTabsUI(false);
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
            }

            public void selectionChanged(ContentManagerEvent event) {
                if (RunnerContentUi.this.isStateBeingRestored()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    RunnerContentUi.this.select(event.getContent(), false);
                }
            }
        });
    }

    private GridImpl getSelectedGrid() {
        TabInfo selection = this.myTabs.getSelectedInfo();
        return selection != null ? this.getGridFor(selection) : null;
    }

    private void removeGridIfNeeded(GridImpl grid) {
        if (grid.isEmpty()) {
            this.myTabs.removeTab(this.myTabs.findInfo((Component)((Object)grid)));
            this.myMinimizedButtonsPlaceholder.remove((Object)grid);
            this.myCommonActionsPlaceholder.remove((Object)grid);
            Disposer.dispose((Disposable)grid);
        }
    }

    @Nullable
    private GridImpl getGridFor(Content content, boolean createIfMissing) {
        GridImpl grid = (GridImpl)this.findGridFor(content);
        if (grid != null || !createIfMissing) {
            return grid;
        }
        grid = new GridImpl(this, this.mySessionName);
        grid.setBorder(new EmptyBorder(1, 0, 0, 0));
        TabInfo tab = new TabInfo((JComponent)((Object)grid)).setObject((Object)this.getStateFor(content).getTab()).setText("Tab");
        Wrapper left = new Wrapper();
        this.myCommonActionsPlaceholder.put(grid, left);
        Wrapper minimizedToolbar = new Wrapper();
        this.myMinimizedButtonsPlaceholder.put(grid, minimizedToolbar);
        Wrapper searchComponent = new Wrapper();
        if (content.getSearchComponent() != null) {
            searchComponent.setContent(content.getSearchComponent());
        }
        TwoSideComponent right = new TwoSideComponent((JComponent)searchComponent, (JComponent)minimizedToolbar);
        TwoSideComponent sideComponent = new TwoSideComponent((JComponent)left, (JComponent)((Object)right));
        tab.setSideComponent((JComponent)((Object)sideComponent));
        tab.setTabLabelActions((ActionGroup)this.myActionManager.getAction(VIEW_TOOLBAR), "debuggerTabToolbar");
        this.myTabs.addTab(tab);
        this.myTabs.sortTabs(this.myTabsComparator);
        return grid;
    }

    @Nullable
    public GridCell findCellFor(Content content) {
        GridImpl cell = this.getGridFor(content, false);
        return cell != null ? cell.getCellFor(content) : null;
    }

    private boolean rebuildToolbar() {
        boolean hasToolbarContent = this.rebuildCommonActions();
        return hasToolbarContent |= this.rebuildMinimizedActions();
    }

    private boolean rebuildCommonActions() {
        boolean hasToolbarContent = false;
        for (GridImpl each : this.myCommonActionsPlaceholder.keySet()) {
            DefaultActionGroup groupToBuild;
            Wrapper eachPlaceholder = this.myCommonActionsPlaceholder.get((Object)each);
            JComponent contextComponent = null;
            List<Content> contentList = each.getContents();
            HashSet<Content> contents = new HashSet<Content>();
            contents.addAll(contentList);
            if (this.isHorizontalToolbar() && contents.size() == 1) {
                Content content = contentList.get(0);
                groupToBuild = new DefaultActionGroup();
                if (content.getActions() != null) {
                    groupToBuild.addAll(content.getActions());
                    groupToBuild.addSeparator();
                    contextComponent = content.getActionsContextComponent();
                }
                groupToBuild.addAll(this.myTopActions);
            } else {
                DefaultActionGroup group = new DefaultActionGroup();
                group.addAll(this.myTopActions);
                groupToBuild = group;
            }
            if (!((Object)contents).equals(this.myContextActions.get((Object)each))) {
                ActionToolbar tb = this.myActionManager.createActionToolbar(this.myActionsPlace, (ActionGroup)groupToBuild, true);
                tb.setTargetComponent(contextComponent);
                eachPlaceholder.setContent(tb.getComponent());
            }
            if (groupToBuild.getChildrenCount() > 0) {
                hasToolbarContent = true;
            }
            this.myContextActions.put(each, contents);
        }
        return hasToolbarContent;
    }

    private boolean rebuildMinimizedActions() {
        for (GridImpl each : this.myMinimizedButtonsPlaceholder.keySet()) {
            Wrapper eachPlaceholder = this.myMinimizedButtonsPlaceholder.get((Object)each);
            ActionToolbar tb = this.myActionManager.createActionToolbar("DebuggerToolbar", (ActionGroup)this.myMinimizedViewActions, true);
            tb.setReservePlaceAutoPopupIcon(false);
            JComponent minimized = tb.getComponent();
            eachPlaceholder.setContent(minimized);
        }
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
        return this.myMinimizedViewActions.getChildrenCount() > 0;
    }

    private void updateTabsUI(boolean validateNow) {
        boolean hasToolbarContent = this.rebuildToolbar();
        List tabs = this.myTabs.getTabs();
        for (TabInfo each : tabs) {
            hasToolbarContent |= this.updateTabUI(each);
        }
        this.myTabs.getPresentation().setHideTabs(!hasToolbarContent);
        this.myTabs.updateTabActions(validateNow);
        if (validateNow) {
            this.myTabs.sortTabs(this.myTabsComparator);
        }
    }

    private boolean updateTabUI(TabInfo tab) {
        String title = this.getTabFor(tab).getDisplayName();
        Icon icon = this.getTabFor(tab).getIcon();
        GridImpl grid = this.getGridFor(tab);
        boolean hasToolbarContent = grid.updateGridUI();
        List<Content> contents = grid.getContents();
        if (title == null) {
            title = "";
            Iterator<Content> all = contents.iterator();
            while (all.hasNext()) {
                Content each = all.next();
                title = title + each.getTabName();
                if (!all.hasNext()) continue;
                title = title + " | ";
            }
        }
        if (icon == null && contents.size() == 1) {
            icon = contents.get(0).getIcon();
        }
        tab.setText(title).setIcon(grid.getTab().isDefault() ? null : icon);
        return hasToolbarContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionCallback restoreLastUiState() {
        if (this.isStateBeingRestored()) {
            return new ActionCallback.Rejected();
        }
        try {
            this.setStateIsBeingRestored(true, this);
            ArrayList tabs = new ArrayList();
            tabs.addAll(this.myTabs.getTabs());
            ActionCallback result = new ActionCallback(tabs.size());
            for (TabInfo each : tabs) {
                this.getGridFor(each).restoreLastUiState().notifyWhenDone(result);
            }
            ActionCallback actionCallback = result;
            return actionCallback;
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
    }

    public void saveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        for (TabInfo each : this.myTabs.getTabs()) {
            GridImpl eachGrid = this.getGridFor(each);
            eachGrid.saveUiState();
        }
    }

    public Tab getTabFor(Grid grid) {
        TabInfo info = this.myTabs.findInfo((Component)grid);
        return this.getTabFor(info);
    }

    private TabImpl getTabFor(TabInfo tab) {
        return (TabImpl)tab.getObject();
    }

    private GridImpl getGridFor(TabInfo tab) {
        return (GridImpl)((Object)tab.getComponent());
    }

    @Nullable
    public Grid findGridFor(Content content) {
        TabImpl tab = (TabImpl)this.getStateFor(content).getTab();
        for (TabInfo each : this.myTabs.getTabs()) {
            if (!this.getTabFor(each).equals(tab)) continue;
            return this.getGridFor(each);
        }
        return null;
    }

    private ArrayList<GridImpl> getGrids() {
        ArrayList<GridImpl> result = new ArrayList<GridImpl>();
        for (TabInfo each : this.myTabs.getTabs()) {
            result.add(this.getGridFor(each));
        }
        return result;
    }

    public void setHorizontalToolbar(boolean state) {
        this.myLayoutSettings.setToolbarHorizontal(state);
        for (GridImpl each : this.getGrids()) {
            each.setToolbarHorizontal(state);
        }
        this.myContextActions.clear();
        this.updateTabsUI(false);
    }

    public boolean isSingleSelection() {
        return false;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return true;
    }

    public void beforeDispose() {
        if (this.myComponent.getRootPane() != null) {
            this.saveUiState();
        }
    }

    public boolean canChangeSelectionTo(Content content, boolean implicit) {
        GridImpl grid;
        if (implicit && (grid = this.getGridFor(content, false)) != null) {
            return !grid.isMinimized(content);
        }
        return true;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreLayout() {
        Content[] all = this.myManager.getContents();
        this.setStateIsBeingRestored(true, this);
        try {
            this.myManager.removeAllContents(false);
            this.myMinimizedViewActions.removeAll();
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.myLayoutSettings.resetToDefault();
        for (Content each : all) {
            this.myManager.addContent(each);
        }
        this.restoreLastUiState();
        this.updateTabsUI(true);
    }

    public boolean isStateBeingRestored() {
        return this.myRestoreStateRequestors.size() > 0;
    }

    public void setStateIsBeingRestored(boolean restoredNow, Object requestor) {
        if (restoredNow) {
            this.myRestoreStateRequestors.add(requestor);
        } else {
            this.myRestoreStateRequestors.remove(requestor);
        }
    }

    public ActionGroup getLayoutActions() {
        return (ActionGroup)this.myActionManager.getAction(LAYOUT);
    }

    public void updateActionsImmediately() {
        if (this.myToolbar.getTargetComponent() instanceof ActionToolbar) {
            ((ActionToolbar)this.myToolbar.getTargetComponent()).updateActionsImmediately();
        }
    }

    public void setMinimizeActionEnabled(boolean enabled) {
        this.myMinimizeActionEnabled = enabled;
    }

    public void setMovetoGridActionEnabled(boolean enabled) {
        this.myMoveToGridActionEnabled = enabled;
    }

    public boolean isMinimizeActionEnabled() {
        return this.myMinimizeActionEnabled;
    }

    public boolean isMoveToGridActionEnabled() {
        return this.myMoveToGridActionEnabled;
    }

    public void setPolicy(String contentId, LayoutAttractionPolicy policy) {
        this.myAttractions.put(contentId, policy);
    }

    public void setConditionPolicy(String condition, LayoutAttractionPolicy policy) {
        this.myConditionAttractions.put(condition, policy);
    }

    private LayoutAttractionPolicy getOrCreatePolicyFor(String key, Map<String, LayoutAttractionPolicy> map, LayoutAttractionPolicy defaultPolicy) {
        LayoutAttractionPolicy policy = map.get(key);
        if (policy == null) {
            policy = defaultPolicy;
            map.put(key, policy);
        }
        return policy;
    }

    public Content findContent(String key) {
        Content[] contents;
        ContentManager manager = this.getContentManager();
        if (manager == null || key == null) {
            return null;
        }
        for (Content content : contents = manager.getContents()) {
            String kind = (String)content.getUserData(ViewImpl.ID);
            if (!key.equals(kind)) continue;
            return content;
        }
        return null;
    }

    public void setToDisposeRemovedContent(boolean toDispose) {
        this.myToDisposeRemovedContent = toDispose;
    }

    public boolean isToDisposeRemovedContent() {
        return this.myToDisposeRemovedContent;
    }

    private void attractOnStartup() {
        final int currentCount = this.myAttractionCount;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (currentCount < RunnerContentUi.this.myAttractionCount) {
                    return;
                }
                RunnerContentUi.this.attractByCondition("startup", false);
            }
        });
    }

    public void attract(Content content, boolean afterInitialized) {
        this.processAttraction((String)content.getUserData(ViewImpl.ID), this.myAttractions, (LayoutAttractionPolicy)new LayoutAttractionPolicy.Bounce(), afterInitialized, true);
    }

    public void attractByCondition(String condition, boolean afterInitialized) {
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), this.myConditionAttractions, this.myLayoutSettings.getAttractionPolicy(condition), afterInitialized, true);
    }

    public void clearAttractionByCondition(String condition, boolean afterInitialized) {
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), this.myConditionAttractions, (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(), afterInitialized, false);
    }

    private void processAttraction(final String contentId, final Map<String, LayoutAttractionPolicy> policyMap, final LayoutAttractionPolicy defaultPolicy, final boolean afterInitialized, final boolean activate) {
        IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                RunnerContentUi.this.myInitialized.processOnDone(new Runnable(){

                    @Override
                    public void run() {
                        Content content = RunnerContentUi.this.findContent(contentId);
                        if (content == null) {
                            return;
                        }
                        LayoutAttractionPolicy policy = RunnerContentUi.this.getOrCreatePolicyFor(contentId, policyMap, defaultPolicy);
                        if (activate) {
                            RunnerContentUi.this.myAttractionCount++;
                            policy.attract(content, RunnerContentUi.this.myRunnerUi);
                        } else {
                            policy.clearAttraction(content, RunnerContentUi.this.myRunnerUi);
                        }
                    }
                }, afterInitialized);
            }
        });
    }

    public static boolean ensureValid(JComponent c) {
        Container eachParent;
        if (c.getRootPane() == null) {
            return false;
        }
        for (eachParent = c.getParent(); eachParent != null && eachParent.isValid(); eachParent = eachParent.getParent()) {
        }
        if (eachParent == null) {
            eachParent = c.getRootPane();
        }
        eachParent.validate();
        return true;
    }

    public ContentUI getContentUI() {
        return this;
    }

    public void minimize(final Content content, final CellTransform.Restore restore) {
        final Ref restoreAction = new Ref();
        restoreAction.set((Object)new RestoreViewAction(content, new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                RunnerContentUi.this.myMinimizedViewActions.remove((AnAction)restoreAction.get());
                return restore.restoreInGrid().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        RunnerContentUi.this.saveUiState();
                        RunnerContentUi.this.select(content, true);
                        RunnerContentUi.this.updateTabsUI(false);
                    }
                });
            }
        }));
        this.myMinimizedViewActions.add((AnAction)restoreAction.get());
        this.saveUiState();
        this.updateTabsUI(false);
    }

    private static boolean willBeEmptyOnRemove(GridImpl grid, List<Content> toRemove) {
        List<Content> attachedToGrid = grid.getAttachedContents();
        for (Content each : attachedToGrid) {
            if (toRemove.contains(each)) continue;
            return false;
        }
        return true;
    }

    public CellTransform.Restore detach(Content[] content) {
        List<Content> contents = Arrays.asList(content);
        for (Content each : content) {
            GridImpl eachGrid = this.getGridFor(each, false);
            if (!RunnerContentUi.willBeEmptyOnRemove(eachGrid, contents)) continue;
            this.myTabs.findInfo((Component)((Object)eachGrid)).setHidden(true);
        }
        this.updateTabsUI(true);
        return new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                RunnerContentUi.this.showHiddenTabs();
                RunnerContentUi.this.updateTabsUI(true);
                return new ActionCallback.Done();
            }
        };
    }

    private void showHiddenTabs() {
        List tabs = this.myTabs.getTabs();
        for (TabInfo eachInfos : tabs) {
            GridImpl eachGrid = (GridImpl)((Object)eachInfos.getComponent());
            if (eachGrid.getAttachedContents().size() <= 0) continue;
            eachInfos.setHidden(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToTab(Content content) {
        this.saveUiState();
        this.setStateIsBeingRestored(true, this);
        try {
            this.myManager.removeContent(content, false);
            this.getStateFor(content).assignTab((Tab)this.myLayoutSettings.createNewTab());
            this.getStateFor(content).setPlaceInGrid(PlaceInGrid.center);
            this.myManager.addContent(content);
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.saveUiState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToGrid(Content content) {
        this.saveUiState();
        this.setStateIsBeingRestored(true, this);
        try {
            this.myManager.removeContent(content, false);
            this.getStateFor(content).assignTab((Tab)this.myLayoutSettings.getDefaultTab());
            this.getStateFor(content).setPlaceInGrid(this.myLayoutSettings.getDefaultGridPlace(content));
            this.myManager.addContent(content);
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.select(content, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                RunnerContentUi.this.saveUiState();
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    public CellTransform.Facade getCellTransform() {
        return this;
    }

    public ContentManager getContentManager() {
        return this.myManager;
    }

    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    @Override
    public RunnerLayout getLayoutSettings() {
        return this.myLayoutSettings;
    }

    public View getStateFor(Content content) {
        return this.myLayoutSettings.getStateFor(content);
    }

    public boolean isHorizontalToolbar() {
        return this.myLayoutSettings.isToolbarHorizontal();
    }

    public ActionCallback select(final Content content, final boolean requestFocus) {
        final GridImpl grid = (GridImpl)this.findGridFor(content);
        if (grid == null) {
            return new ActionCallback.Done();
        }
        TabInfo info = this.myTabs.findInfo((Component)((Object)grid));
        if (info == null) {
            return new ActionCallback.Done();
        }
        final ActionCallback result = new ActionCallback();
        if (grid.isDetached(content)) {
            if (requestFocus) {
                grid.select(content, requestFocus).notifyWhenDone(result);
            }
        } else {
            this.myTabs.select(info, false).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    grid.select(content, requestFocus).notifyWhenDone(result);
                }
            });
        }
        return result;
    }

    public void validate(Content content, final ActiveRunnable toRestore) {
        final TabInfo current = this.myTabs.getSelectedInfo();
        this.myTabs.getPresentation().setPaintBlocked(true, true);
        this.select(content, false).doWhenDone(new Runnable(){

            @Override
            public void run() {
                RunnerContentUi.this.myTabs.getComponent().validate();
                toRestore.run().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        RunnerContentUi.this.myTabs.select(current, true);
                        RunnerContentUi.this.myTabs.getPresentation().setPaintBlocked(false, true);
                    }
                });
            }
        });
    }

    public IdeFocusManager getFocusManager() {
        return this.myFocusManager;
    }

    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerUi;
    }

    private static class CommonToolbarLayout
    extends AbstractLayoutManager {
        private final JComponent myLeft;
        private final JComponent myRight;

        public CommonToolbarLayout(JComponent left, JComponent right) {
            this.myLeft = left;
            this.myRight = right;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size = new Dimension();
            Dimension leftSize = this.myLeft.getPreferredSize();
            Dimension rightSize = this.myRight.getPreferredSize();
            size.width = leftSize.width + rightSize.width;
            size.height = Math.max(leftSize.height, rightSize.height);
            return size;
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Dimension prefSize = parent.getPreferredSize();
            if (prefSize.width <= size.width) {
                this.myLeft.setBounds(0, 0, this.myLeft.getPreferredSize().width, parent.getHeight());
                Dimension rightSize = this.myRight.getPreferredSize();
                this.myRight.setBounds(parent.getWidth() - rightSize.width, 0, rightSize.width, parent.getHeight());
            } else {
                Dimension leftMinSize = this.myLeft.getMinimumSize();
                Dimension rightMinSize = this.myRight.getMinimumSize();
                int delta = (prefSize.width - size.width) / 2;
                this.myLeft.setBounds(0, 0, this.myLeft.getPreferredSize().width - delta, parent.getHeight());
                int rightX = (int)this.myLeft.getBounds().getMaxX();
                int rightWidth = size.width - rightX;
                if (rightWidth < rightMinSize.width) {
                    Dimension leftSize = this.myLeft.getSize();
                    int diffToRightMin = rightMinSize.width - rightWidth;
                    if (leftSize.width - diffToRightMin >= leftMinSize.width) {
                        leftSize.width -= diffToRightMin;
                        this.myLeft.setSize(leftSize);
                    }
                }
                this.myRight.setBounds((int)this.myLeft.getBounds().getMaxX(), 0, parent.getWidth() - this.myLeft.getWidth(), parent.getHeight());
            }
            this.toMakeVerticallyInCenter(this.myLeft, parent);
            this.toMakeVerticallyInCenter(this.myRight, parent);
        }

        private void toMakeVerticallyInCenter(JComponent comp, Container parent) {
            Rectangle compBounds = comp.getBounds();
            int compHeight = comp.getPreferredSize().height;
            int parentHeight = parent.getHeight();
            if (compHeight > parentHeight) {
                compHeight = parentHeight;
            }
            int y = (int)Math.floor((double)parentHeight / 2.0 - (double)compHeight / 2.0);
            comp.setBounds(compBounds.x, y, compBounds.width, compHeight);
        }
    }

    private class TwoSideComponent
    extends NonOpaquePanel {
        private TwoSideComponent(JComponent left, JComponent right) {
            this.setLayout((LayoutManager)((Object)new CommonToolbarLayout(left, right)));
            this.add(left);
            this.add(right);
        }
    }

    private class MyComponent
    extends Wrapper.FocusHolder
    implements DataProvider {
        private boolean myWasEverAdded;

        public MyComponent() {
            this.setOpaque(true);
            this.setFocusCycleRoot(true);
            this.setBorder((Border)new ToolWindow.Border(true, false, true, true));
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return RunnerContentUi.this;
            }
            return null;
        }

        public void addNotify() {
            super.addNotify();
            if (!RunnerContentUi.this.myUiLastStateWasRestored) {
                RunnerContentUi.this.myUiLastStateWasRestored = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunnerContentUi.this.restoreLastUiState().doWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                if (!MyComponent.this.myWasEverAdded) {
                                    MyComponent.this.myWasEverAdded = true;
                                    RunnerContentUi.this.attractOnStartup();
                                    RunnerContentUi.this.myInitialized.setDone();
                                }
                            }
                        });
                    }
                });
            }
        }

        public void removeNotify() {
            super.removeNotify();
            if (Disposer.isDisposed((Disposable)RunnerContentUi.this)) {
                return;
            }
            RunnerContentUi.this.saveUiState();
        }
    }
}

