/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.HashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GridImpl
extends Wrapper
implements Grid,
Disposable,
CellTransform.Facade,
DataProvider {
    private final ThreeComponentsSplitter myTopSplit = new ThreeComponentsSplitter();
    private final Splitter mySplitter = new Splitter(true);
    private final HashMap<PlaceInGrid, GridCellImpl> myPlaceInGrid2Cell = new HashMap();
    private final Placeholder myLeft = new Placeholder();
    private final Placeholder myCenter = new Placeholder();
    private final Placeholder myRight = new Placeholder();
    private final Placeholder myBottom = new Placeholder();
    private final String mySessionName;
    private final List<Content> myContents = new ArrayList<Content>();
    private final Map<Content, GridCellImpl> myContent2Cell = new java.util.HashMap<Content, GridCellImpl>();
    private final Comparator<Content> myContentComparator = new Comparator<Content>(){

        @Override
        public int compare(Content o1, Content o2) {
            return GridImpl.this.getCellFor(o1).getPlaceInGrid().compareTo((Enum)GridImpl.this.getCellFor(o2).getPlaceInGrid());
        }
    };
    private boolean myLastUiStateWasRestored;
    private final ViewContextEx myViewContext;

    public GridImpl(ViewContextEx viewContext, String sessionName) {
        this.myViewContext = viewContext;
        this.mySessionName = sessionName;
        Disposer.register((Disposable)this.myViewContext, (Disposable)this);
        this.myPlaceInGrid2Cell.put((Object)PlaceInGrid.left, (Object)new GridCellImpl(this.myViewContext, this, this.myLeft, PlaceInGrid.left));
        this.myPlaceInGrid2Cell.put((Object)PlaceInGrid.center, (Object)new GridCellImpl(this.myViewContext, this, this.myCenter, PlaceInGrid.center));
        this.myPlaceInGrid2Cell.put((Object)PlaceInGrid.right, (Object)new GridCellImpl(this.myViewContext, this, this.myRight, PlaceInGrid.right));
        this.myPlaceInGrid2Cell.put((Object)PlaceInGrid.bottom, (Object)new GridCellImpl(this.myViewContext, this, this.myBottom, PlaceInGrid.bottom));
        this.setContent((JComponent)this.mySplitter);
        this.setOpaque(false);
        this.setFocusCycleRoot(true);
        this.myTopSplit.setFirstComponent((JComponent)((Object)this.myLeft));
        this.myTopSplit.setInnerComponent((JComponent)((Object)this.myCenter));
        this.myTopSplit.setLastComponent((JComponent)((Object)this.myRight));
        this.mySplitter.setFirstComponent((JComponent)this.myTopSplit);
        this.mySplitter.setSecondComponent((JComponent)((Object)this.myBottom));
    }

    public void addNotify() {
        super.addNotify();
        this.processAddToUi(true);
    }

    public void removeNotify() {
        super.removeNotify();
        this.processRemoveFromUi();
    }

    public void processAddToUi(boolean restoreProportions) {
        if (restoreProportions) {
            for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
                cell.restoreProportions();
            }
        }
        this.updateSelection(true);
    }

    public void processRemoveFromUi() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.updateSelection(false);
    }

    private void updateSelection(boolean isShowing) {
        for (GridCellImpl each : this.myPlaceInGrid2Cell.values()) {
            each.updateSelection(isShowing);
        }
    }

    public void add(Content content, boolean select) {
        GridCellImpl cell = this.getCellFor(content);
        cell.add(content);
        this.myContents.add(content);
        this.myContent2Cell.put(content, cell);
        Collections.sort(this.myContents, this.myContentComparator);
    }

    public void remove(Content content) {
        this.getCellFor(content).remove(content);
        this.myContents.remove(content);
        this.myContent2Cell.remove(content);
    }

    public void setToolbarHorizontal(boolean horizontal) {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.setToolbarHorizontal(horizontal);
        }
    }

    public GridCellImpl getCellFor(Content content) {
        GridCellImpl cell = (GridCellImpl)this.myPlaceInGrid2Cell.get((Object)this.getStateFor(content).getPlaceInGrid());
        assert (cell != null) : "Unknown place in grid: " + this.getStateFor(content).getPlaceInGrid().name();
        return cell;
    }

    View getStateFor(Content content) {
        return this.myViewContext.getStateFor(content);
    }

    public boolean updateGridUI() {
        Content onlyContent;
        boolean hasToolbarContent = true;
        boolean wasHidden = false;
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            boolean eachToHide = this.myContents.size() == 1 && !cell.isDetached();
            cell.setHideTabs(eachToHide);
            wasHidden |= eachToHide;
        }
        if (wasHidden) {
            hasToolbarContent = false;
        }
        hasToolbarContent = (onlyContent = this.myContents.get(0)).getSearchComponent() != null;
        return hasToolbarContent;
    }

    public boolean isEmpty() {
        return this.myContent2Cell.isEmpty();
    }

    public ActionCallback restoreLastUiState() {
        this.myLastUiStateWasRestored = true;
        ActionCallback result = new ActionCallback(this.myPlaceInGrid2Cell.values().size());
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.restoreLastUiState().notifyWhenDone(result);
        }
        return result;
    }

    public void saveUiState() {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.saveUiState();
        }
    }

    public Tab getTabIndex() {
        return this.getTab();
    }

    public ActionCallback select(Content content, boolean requestFocus) {
        return this.getCellFor(content).select(content, requestFocus);
    }

    public void processAlert(Content content, boolean activate) {
        GridCellImpl cell = this.getCellFor(content);
        cell.processAlert(content, activate);
    }

    @Nullable
    public GridCellImpl findCell(Content content) {
        return this.myContent2Cell.get(content);
    }

    public void rebuildTabPopup() {
        List<Content> contents = this.getContents();
        for (Content each : contents) {
            this.findCell(each).rebuildPopupGroup();
        }
    }

    public boolean isMinimized(Content content) {
        return this.getCellFor(content).isMinimized(content);
    }

    public void dispose() {
    }

    void saveSplitterProportions(PlaceInGrid placeInGrid) {
        if (this.getRootPane() == null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            return;
        }
        GridCellImpl cell = (GridCellImpl)this.myPlaceInGrid2Cell.get((Object)placeInGrid);
        if (!cell.isValidForCalculatePropertions()) {
            return;
        }
        TabImpl tab = (TabImpl)this.getTab();
        switch (placeInGrid) {
            case left: {
                tab.setLeftProportion(this.getLeftProportion());
                break;
            }
            case right: {
                tab.setRightProportion(this.getRightProportion());
                break;
            }
            case bottom: {
                tab.setBottomProportion(this.getBottomPropertion());
            }
        }
    }

    public Tab getTab() {
        return this.myViewContext.getTabFor(this);
    }

    void restoreLastSplitterProportions(PlaceInGrid placeInGrid) {
        if (this.getRootPane() == null) {
            return;
        }
        if (!RunnerContentUi.ensureValid((JComponent)((Object)this))) {
            return;
        }
        TabImpl tab = (TabImpl)this.getTab();
        switch (placeInGrid) {
            case left: {
                this.setLeftProportion(tab.getLeftProportion());
                break;
            }
            case right: {
                this.setRightProportion(tab.getRightProportion());
                break;
            }
            case bottom: {
                this.mySplitter.setProportion(tab.getBottomProportion());
            }
        }
    }

    float getLeftProportion() {
        float totalSize = this.myTopSplit.getOrientation() ? (float)this.myTopSplit.getHeight() : (float)this.myTopSplit.getWidth();
        float componentSize = this.myTopSplit.getFirstSize();
        return componentSize / (totalSize - 2.0f * (float)this.myTopSplit.getDividerWidth());
    }

    void setLeftProportion(float proportion) {
        int totalSize = this.myTopSplit.getOrientation() ? this.myTopSplit.getHeight() : this.myTopSplit.getWidth();
        this.myTopSplit.setFirstSize((int)(proportion * (float)(totalSize - 2 * this.myTopSplit.getDividerWidth())));
    }

    float getRightProportion() {
        float totalSize = this.myTopSplit.getOrientation() ? (float)this.myTopSplit.getHeight() : (float)this.myTopSplit.getWidth();
        float componentSize = this.myTopSplit.getLastSize();
        return componentSize / (totalSize - 2.0f * (float)this.myTopSplit.getDividerWidth());
    }

    float getBottomPropertion() {
        float totalSize = this.mySplitter.getOrientation() ? (float)this.mySplitter.getHeight() : (float)this.mySplitter.getWidth();
        float componentSize = this.mySplitter.getOrientation() ? (float)this.mySplitter.getFirstComponent().getHeight() : (float)this.mySplitter.getFirstComponent().getWidth();
        return componentSize / (totalSize - (float)this.mySplitter.getDividerWidth());
    }

    void setRightProportion(float proportion) {
        int componentSize = this.myTopSplit.getOrientation() ? this.myTopSplit.getHeight() : this.myTopSplit.getWidth();
        this.myTopSplit.setLastSize((int)(proportion * (float)(componentSize - 2 * this.myTopSplit.getDividerWidth())));
    }

    public List<Content> getAttachedContents() {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content each : this.getContents()) {
            if (this.isDetached(each)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean isDetached(Content content) {
        return this.getCellFor(content).isDetached();
    }

    public List<Content> getContents() {
        return this.myContents;
    }

    public void minimize(Content content, final CellTransform.Restore restore) {
        this.myViewContext.getCellTransform().minimize(content, new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                return restore.restoreInGrid();
            }
        });
    }

    public void moveToTab(Content content) {
        this.myViewContext.getCellTransform().moveToTab(content);
    }

    public void moveToGrid(Content content) {
        this.myViewContext.getCellTransform().moveToGrid(content);
    }

    public CellTransform.Restore detach(Content[] content) {
        CellTransform.Restore.List restore = new CellTransform.Restore.List();
        restore.add(this.myViewContext.getCellTransform().detach(content));
        restore.add(new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                GridImpl.this.revalidate();
                GridImpl.this.repaint();
                return new ActionCallback.Done();
            }
        });
        return restore;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ViewContext.CONTEXT_KEY.is(dataId)) {
            return this.myViewContext;
        }
        if (ViewContext.CONTENT_KEY.is(dataId)) {
            List<Content> contents = this.getContents();
            return contents.toArray(new Content[contents.size()]);
        }
        return null;
    }

    public String getSessionName() {
        return this.mySessionName;
    }

    static class Placeholder
    extends Wrapper
    implements NullableComponent {
        private JComponent myContent;

        Placeholder() {
        }

        public boolean isNull() {
            return this.getComponentCount() == 0;
        }

        public CellTransform.Restore detach() {
            if (this.getComponentCount() == 1) {
                this.myContent = (JComponent)this.getComponent(0);
                this.removeAll();
            }
            if (this.getParent() instanceof JComponent) {
                ((JComponent)this.getParent()).revalidate();
                this.getParent().repaint();
            }
            return new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    if (Placeholder.this.myContent != null) {
                        Placeholder.this.setContent(Placeholder.this.myContent);
                        Placeholder.this.myContent = null;
                    }
                    return new ActionCallback.Done();
                }
            };
        }
    }
}

