/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.sm.runner.ui.statistics.BaseColumn;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColoredRenderer;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnTest;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ColumnDuration
extends BaseColumn
implements Comparator<SMTestProxy> {
    public ColumnDuration() {
        super(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.title", new Object[0]));
    }

    public String valueOf(SMTestProxy testProxy) {
        return TestsPresentationUtil.getDurationPresentation(testProxy);
    }

    @Nullable
    public Comparator<SMTestProxy> getComparator() {
        return this;
    }

    @Override
    public int compare(SMTestProxy proxy1, SMTestProxy proxy2) {
        Integer duration1 = proxy1.getDuration();
        Integer duration2 = proxy2.getDuration();
        if (duration1 == null) {
            return duration2 == null ? 0 : -1;
        }
        if (duration2 == null) {
            return 1;
        }
        return duration1.compareTo(duration2);
    }

    public TableCellRenderer getRenderer(SMTestProxy proxy) {
        return new DurationCellRenderer(proxy);
    }

    public static class DurationCellRenderer
    extends ColoredTableCellRenderer
    implements ColoredRenderer {
        private final SMTestProxy myProxy;

        public DurationCellRenderer(SMTestProxy proxy) {
            this.myProxy = proxy;
        }

        @Override
        public void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            assert (value != null);
            String title = value.toString();
            SimpleTextAttributes attributes = this.myProxy.isSuite() && ColumnTest.TestsCellRenderer.isFirstLine(row) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            this.append(title, attributes);
        }
    }
}

