/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RestartAction
extends AnAction
implements DumbAware {
    private ProcessHandler myProcessHandler;
    private final ProgramRunner myRunner;
    private final RunContentDescriptor myDescriptor;
    private final Executor myExecutor;
    private final ExecutionEnvironment myEnvironment;

    public RestartAction(Executor executor, ProgramRunner runner, ProcessHandler processHandler, Icon icon, RunContentDescriptor descritor, ExecutionEnvironment env) {
        super(null, null, icon);
        this.myEnvironment = env;
        this.getTemplatePresentation().setEnabled(false);
        this.myProcessHandler = processHandler;
        this.myRunner = runner;
        this.myDescriptor = descritor;
        this.myExecutor = executor;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        this.doRestart(dataContext);
    }

    public void restart() {
        this.doRestart(DataManager.getInstance().getDataContext((Component)this.myDescriptor.getComponent()));
    }

    private void doRestart(final DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        try {
            ExecutionEnvironment old = this.myEnvironment;
            this.myRunner.execute(this.myExecutor, new ExecutionEnvironment(old.getRunProfile(), old.getRunnerSettings(), old.getConfigurationSettings(), new DataContext(){

                public Object getData(String dataId) {
                    if (GenericProgramRunner.CONTENT_TO_REUSE_DATA_KEY.is(dataId)) {
                        return RestartAction.this.myDescriptor;
                    }
                    return dataContext.getData(dataId);
                }
            }));
        }
        catch (RunCanceledByUserException ignore) {
        }
        catch (ExecutionException e1) {
            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)ExecutionBundle.message((String)"restart.error.message.title", (Object[])new Object[0]));
        }
    }

    public void update(AnActionEvent event) {
        boolean isRunning;
        Presentation presentation = event.getPresentation();
        presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{this.myEnvironment.getRunProfile().getName()}));
        boolean bl = isRunning = this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
        if (this.myProcessHandler != null && !isRunning) {
            this.myProcessHandler = null;
        }
        presentation.setEnabled(!isRunning);
    }

    public void registerShortcut(JComponent component) {
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("Rerun")), component);
    }
}

