/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.EditLogPatternDialog;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogConfigurationPanel<T extends RunConfigurationBase>
extends SettingsEditor<RunConfigurationBase> {
    private final TableView myFilesTable;
    private final ListTableModel myModel;
    private JPanel myWholePanel;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JPanel myScrollPanel;
    private final Map<LogFileOptions, PredefinedLogFile> myLog2Predefined;
    private final List<PredefinedLogFile> myUnresolvedPredefined;
    private final ColumnInfo<LogFileOptions, Boolean> IS_SHOW;
    private final ColumnInfo<LogFileOptions, LogFileOptions> FILE;
    private final ColumnInfo<LogFileOptions, Boolean> IS_SKIP_CONTENT;

    public LogConfigurationPanel() {
        this.$$$setupUI$$$();
        this.myLog2Predefined = new HashMap<LogFileOptions, PredefinedLogFile>();
        this.myUnresolvedPredefined = new ArrayList<PredefinedLogFile>();
        this.IS_SHOW = new MyIsActiveColumnInfo();
        this.FILE = new MyLogFileColumnInfo();
        this.IS_SKIP_CONTENT = new MyIsSkippColumnInfo();
        this.myModel = new ListTableModel(new ColumnInfo[]{this.IS_SHOW, this.FILE, this.IS_SKIP_CONTENT});
        this.myFilesTable = new TableView(this.myModel);
        JTableHeader tableHeader = this.myFilesTable.getTableHeader();
        FontMetrics fontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int preferredWidth = fontMetrics.stringWidth(this.IS_SHOW.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 0);
        preferredWidth = fontMetrics.stringWidth(this.IS_SKIP_CONTENT.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 2);
        this.myFilesTable.setColumnSelectionAllowed(false);
        this.myFilesTable.setShowGrid(false);
        this.myFilesTable.setDragEnabled(false);
        this.myFilesTable.setShowHorizontalLines(false);
        this.myFilesTable.setShowVerticalLines(false);
        this.myFilesTable.setIntercellSpacing(new Dimension(0, 0));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<LogFileOptions> newList = new ArrayList<LogFileOptions>(LogConfigurationPanel.this.myModel.getItems());
                LogFileOptions selectedNameLocation = LogConfigurationPanel.showEditorDialog("", "", false);
                if (selectedNameLocation != null) {
                    newList.add(new LogFileOptions(selectedNameLocation.getName(), selectedNameLocation.getPathPattern(), true, true, selectedNameLocation.isShowAll()));
                    LogConfigurationPanel.this.myModel.setItems(newList);
                    int index = LogConfigurationPanel.this.myModel.getRowCount() - 1;
                    LogConfigurationPanel.this.myModel.fireTableRowsInserted(index, index);
                    LogConfigurationPanel.this.myFilesTable.setRowSelectionInterval(index, index);
                }
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                TableUtil.stopEditing((JTable)LogConfigurationPanel.this.myFilesTable);
                int[] selected = LogConfigurationPanel.this.myFilesTable.getSelectedRows();
                if (selected == null || selected.length == 0) {
                    return;
                }
                for (i = selected.length - 1; i >= 0; --i) {
                    LogConfigurationPanel.this.myModel.removeRow(selected[i]);
                }
                for (i = selected.length - 1; i >= 0; --i) {
                    int idx = selected[i];
                    LogConfigurationPanel.this.myModel.fireTableRowsDeleted(idx, idx);
                }
                int selection = selected[0];
                if (selection >= LogConfigurationPanel.this.myModel.getRowCount()) {
                    selection = LogConfigurationPanel.this.myModel.getRowCount() - 1;
                }
                if (selection >= 0) {
                    LogConfigurationPanel.this.myFilesTable.setRowSelectionInterval(selection, selection);
                }
                LogConfigurationPanel.this.myFilesTable.requestFocus();
            }
        });
        this.myRemoveButton.setEnabled(false);
        this.myFilesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogConfigurationPanel.this.myRemoveButton.setEnabled(LogConfigurationPanel.this.myFilesTable.getSelectedRowCount() >= 1);
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myFilesTable);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.myScrollPanel.add((Component)scrollPane, "Center");
        this.myWholePanel.setPreferredSize(new Dimension(-1, 150));
    }

    private void setUpColumnWidth(JTableHeader tableHeader, int preferredWidth, int columnIdx) {
        this.myFilesTable.getColumnModel().getColumn(columnIdx).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn tableColumn = tableHeader.getColumnModel().getColumn(columnIdx);
        tableColumn.setWidth(preferredWidth);
        tableColumn.setPreferredWidth(preferredWidth);
        tableColumn.setMinWidth(preferredWidth);
        tableColumn.setMaxWidth(preferredWidth);
    }

    public void refreshPredefinedLogFiles(RunConfigurationBase configurationBase) {
        PredefinedLogFile[] unresolved;
        List items = this.myModel.getItems();
        ArrayList<LogFileOptions> newItems = new ArrayList<LogFileOptions>();
        boolean changed = false;
        for (LogFileOptions item : items) {
            PredefinedLogFile predefined = this.myLog2Predefined.get(item);
            if (predefined != null) {
                LogFileOptions options = configurationBase.getOptionsForPredefinedLogFile(predefined);
                if (LogFileOptions.areEqual((LogFileOptions)item, (LogFileOptions)options)) {
                    newItems.add(item);
                    continue;
                }
                changed = true;
                this.myLog2Predefined.remove(item);
                if (options == null) {
                    this.myUnresolvedPredefined.add(predefined);
                    continue;
                }
                newItems.add(options);
                this.myLog2Predefined.put(options, predefined);
                continue;
            }
            newItems.add(item);
        }
        for (PredefinedLogFile logFile : unresolved = this.myUnresolvedPredefined.toArray(new PredefinedLogFile[this.myUnresolvedPredefined.size()])) {
            LogFileOptions options = configurationBase.getOptionsForPredefinedLogFile(logFile);
            if (options == null) continue;
            changed = true;
            this.myUnresolvedPredefined.remove(logFile);
            this.myLog2Predefined.put(options, logFile);
            newItems.add(options);
        }
        if (changed) {
            this.myModel.setItems(newItems);
        }
    }

    protected void resetEditorFrom(RunConfigurationBase configuration) {
        this.clearModel();
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>();
        ArrayList logFiles = configuration.getLogFiles();
        for (LogFileOptions setting : logFiles) {
            list.add(new LogFileOptions(setting.getName(), setting.getPathPattern(), setting.isEnabled(), setting.isSkipContent(), setting.isShowAll()));
        }
        this.myLog2Predefined.clear();
        this.myUnresolvedPredefined.clear();
        ArrayList predefinedLogFiles = configuration.getPredefinedLogFiles();
        for (PredefinedLogFile predefinedLogFile : predefinedLogFiles) {
            PredefinedLogFile logFile = new PredefinedLogFile(predefinedLogFile);
            LogFileOptions options = configuration.getOptionsForPredefinedLogFile(logFile);
            if (options != null) {
                this.myLog2Predefined.put(options, logFile);
                list.add(options);
                continue;
            }
            this.myUnresolvedPredefined.add(logFile);
        }
        this.myModel.setItems(list);
    }

    protected void applyEditorTo(RunConfigurationBase configuration) throws ConfigurationException {
        this.myFilesTable.stopEditing();
        configuration.removeAllLogFiles();
        configuration.removeAllPredefinedLogFiles();
        for (int i = 0; i < this.myModel.getRowCount(); ++i) {
            LogFileOptions pair = (LogFileOptions)this.myModel.getValueAt(i, 1);
            if (Comparing.equal((String)pair.getPathPattern(), (String)"")) continue;
            Boolean checked = (Boolean)this.myModel.getValueAt(i, 0);
            Boolean skipped = (Boolean)this.myModel.getValueAt(i, 2);
            PredefinedLogFile predefined = this.myLog2Predefined.get(pair);
            if (predefined != null && !LogConfigurationPanel.isPredefinedChanged(configuration, predefined, pair)) {
                configuration.addPredefinedLogFile(new PredefinedLogFile(predefined.getId(), pair.isEnabled()));
                continue;
            }
            configuration.addLogFile(pair.getPathPattern(), pair.getName(), checked.booleanValue(), skipped.booleanValue(), pair.isShowAll());
        }
        for (PredefinedLogFile logFile : this.myUnresolvedPredefined) {
            configuration.addPredefinedLogFile(logFile);
        }
    }

    private static boolean isPredefinedChanged(RunConfigurationBase configuration, PredefinedLogFile predefined, LogFileOptions options) {
        LogFileOptions oldOptions = configuration.getOptionsForPredefinedLogFile(predefined);
        return oldOptions == null || !oldOptions.getPathPattern().equals(options.getPathPattern()) || oldOptions.isSkipContent() != options.isSkipContent() || oldOptions.isShowAll() != options.isShowAll() || !oldOptions.getName().equals(options.getName());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/diagnostic/logging/LogConfigurationPanel.createEditor must not return null");
        }
        return jPanel;
    }

    protected void disposeEditor() {
    }

    public JComponent getLoggerComponent() {
        return this.getComponent();
    }

    public void addLogFile(String file, String alias, boolean isShowAll, boolean checked, boolean skipContent) {
        List itemsUnmodifiable = this.myModel.getItems();
        ArrayList<LogFileOptions> items = new ArrayList<LogFileOptions>();
        items.addAll(itemsUnmodifiable);
        items.add(new LogFileOptions(alias, file, checked, skipContent, isShowAll));
        this.myModel.setItems(items);
    }

    private void clearModel() {
        this.myModel.setItems(new ArrayList());
    }

    @Nullable
    private static LogFileOptions showEditorDialog(String name, String location, boolean showAll) {
        EditLogPatternDialog dialog = new EditLogPatternDialog();
        dialog.init(name, location, showAll);
        dialog.show();
        if (dialog.isOK()) {
            location = dialog.getLogPattern();
            name = dialog.getName();
            showAll = dialog.isShowAllFiles();
            return new LogFileOptions(name, location, false, false, showAll);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 2, 0, 2), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 3, null, null, null));
        this.myAddButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.add.button"));
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.remove.button"));
        jPanel3.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.monitor.group"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScrollPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class LogFileCellEditor
    extends AbstractTableCellEditor {
        private final CellEditorComponentWithBrowseButton<JTextField> myComponent;
        private LogFileOptions myLogFileOptions;

        public LogFileCellEditor(LogFileOptions options) {
            this.myLogFileOptions = options;
            this.myComponent = new CellEditorComponentWithBrowseButton(new TextFieldWithBrowseButton(), (TableCellEditor)((Object)this));
            this.getChildComponent().setEditable(false);
            this.getChildComponent().setBorder(null);
            this.myComponent.getComponentWithButton().getButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogFileOptions newValue = LogConfigurationPanel.showEditorDialog(LogFileCellEditor.this.myLogFileOptions.getName(), LogFileCellEditor.this.myLogFileOptions.getPathPattern(), LogFileCellEditor.this.myLogFileOptions.isShowAll());
                    if (newValue != null) {
                        LogConfigurationPanel.this.myLog2Predefined.remove(LogFileCellEditor.this.myLogFileOptions);
                        LogFileCellEditor.this.myLogFileOptions = newValue;
                    }
                    JTextField textField = LogFileCellEditor.this.getChildComponent();
                    textField.setText(LogFileCellEditor.this.myLogFileOptions.getName());
                    textField.requestFocus();
                }
            });
        }

        public Object getCellEditorValue() {
            return this.myLogFileOptions;
        }

        private JTextField getChildComponent() {
            return this.myComponent.getChildComponent();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.getChildComponent().setText(((LogFileOptions)value).getName());
            return this.myComponent;
        }
    }

    private class MyIsSkippColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsSkippColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.skipped.column", new Object[0]));
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions element) {
            return element.isSkipContent();
        }

        public boolean isCellEditable(LogFileOptions element) {
            return true;
        }

        public void setValue(LogFileOptions element, Boolean skipped) {
            if (element.isSkipContent() != skipped.booleanValue()) {
                LogConfigurationPanel.this.myLog2Predefined.remove(element);
            }
            element.setSkipContent(skipped.booleanValue());
        }
    }

    private class MyIsActiveColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsActiveColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.active.column", new Object[0]));
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions object) {
            return object.isEnabled();
        }

        public boolean isCellEditable(LogFileOptions element) {
            return true;
        }

        public void setValue(LogFileOptions element, Boolean checked) {
            PredefinedLogFile predefinedLogFile = (PredefinedLogFile)LogConfigurationPanel.this.myLog2Predefined.get(element);
            if (predefinedLogFile != null) {
                predefinedLogFile.setEnabled(checked.booleanValue());
            }
            element.setEnable(checked.booleanValue());
        }
    }

    private class MyLogFileColumnInfo
    extends ColumnInfo<LogFileOptions, LogFileOptions> {
        public MyLogFileColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.log.file.column", new Object[0]));
        }

        public TableCellRenderer getRenderer(LogFileOptions p0) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(((LogFileOptions)value).getName());
                    this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    this.setBorder(null);
                    return renderer;
                }
            };
        }

        public LogFileOptions valueOf(LogFileOptions object) {
            return object;
        }

        public TableCellEditor getEditor(LogFileOptions item) {
            return new LogFileCellEditor(item);
        }

        public void setValue(LogFileOptions o, LogFileOptions aValue) {
            if (aValue != null) {
                if (!o.getName().equals(aValue.getName()) || !o.getPathPattern().equals(aValue.getPathPattern()) || o.isShowAll() != aValue.isShowAll()) {
                    LogConfigurationPanel.this.myLog2Predefined.remove(o);
                }
                o.setName(aValue.getName());
                o.setLast(!aValue.isShowAll());
                o.setPathPattern(aValue.getPathPattern());
            }
        }

        public boolean isCellEditable(LogFileOptions o) {
            return true;
        }
    }
}

