/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.FrameDebuggerTree;
import com.intellij.debugger.ui.impl.ValueNodeDnD;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class VariablesPanel
extends DebuggerTreePanel
implements DataProvider {
    @NonNls
    private static final String HELP_ID = "debugging.debugFrame";

    public VariablesPanel(Project project, DebuggerStateManager stateManager, Disposable parent) {
        super(project, stateManager);
        this.setBorder(null);
        FrameDebuggerTree frameTree = this.getFrameTree();
        this.add((Component)new JScrollPane((Component)((Object)frameTree)), "Center");
        this.registerDisposable(DebuggerAction.installEditAction((JTree)((Object)frameTree), "Debugger.EditNodeSource"));
        this.overrideShortcut((JComponent)((Object)frameTree), "Debugger.SetValue", new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)));
        new ValueNodeDnD(this.myTree, parent);
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new FrameDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.FramePanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.FramePanelPopup", group);
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    public FrameDebuggerTree getFrameTree() {
        return (FrameDebuggerTree)this.getTree();
    }
}

