/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FieldBreakpointPropertiesPanel
extends BreakpointPropertiesPanel {
    private JCheckBox myWatchAccessCheckBox;
    private JCheckBox myWatchModificationCheckBox;

    public FieldBreakpointPropertiesPanel(Project project) {
        super(project, FieldBreakpoint.CATEGORY);
    }

    @Override
    protected JComponent createSpecialBox() {
        this.myWatchAccessCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.filed.breakpoint.properties.panel.field.access", (Object[])new Object[0]));
        this.myWatchModificationCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.filed.breakpoint.properties.panel.field.modification", (Object[])new Object[0]));
        Box watchBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchAccessCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchModificationCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)watchBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), DebuggerBundle.message((String)"label.group.watch.events", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox toCheck = null;
                if (!FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox.isSelected() && !FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox.isSelected()) {
                    Object source = e.getSource();
                    if (FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox.equals(source)) {
                        toCheck = FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox;
                    } else if (FieldBreakpointPropertiesPanel.this.myWatchModificationCheckBox.equals(source)) {
                        toCheck = FieldBreakpointPropertiesPanel.this.myWatchAccessCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myWatchAccessCheckBox.addActionListener(listener);
        this.myWatchModificationCheckBox.addActionListener(listener);
        return _panel;
    }

    @Override
    public void initFrom(Breakpoint breakpoint) {
        super.initFrom(breakpoint);
        FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)breakpoint;
        this.myWatchAccessCheckBox.setSelected(fieldBreakpoint.WATCH_ACCESS);
        this.myWatchModificationCheckBox.setSelected(fieldBreakpoint.WATCH_MODIFICATION);
    }

    @Override
    public void saveTo(Breakpoint breakpoint, Runnable afterUpdate) {
        FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)breakpoint;
        fieldBreakpoint.WATCH_ACCESS = this.myWatchAccessCheckBox.isSelected();
        fieldBreakpoint.WATCH_MODIFICATION = this.myWatchModificationCheckBox.isSelected();
        super.saveTo(breakpoint, afterUpdate);
    }
}

