/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;

public class DebuggerExpressionTextField
extends DebuggerEditorImpl {
    private final EditorTextField myEditor;
    private final JTextField myStubField = new JTextField();
    private final JPanel myMainPanel = new JPanel(new CardLayout());
    @NonNls
    private static final String EDITOR = "editor";
    @NonNls
    private static final String STUB = "stub";

    public DebuggerExpressionTextField(Project project, PsiElement context, @NonNls String recentsId) {
        super(project, context, recentsId, DefaultCodeFragmentFactory.getInstance());
        this.myStubField.setEnabled(false);
        this.myEditor = new EditorTextField("", project, (FileType)StdFileTypes.JAVA);
        this.setLayout(new BorderLayout());
        this.myMainPanel.add((Component)this.myStubField, STUB);
        this.myMainPanel.add((Component)this.myEditor, EDITOR);
        this.add((Component)this.myMainPanel, "Center");
        ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, this.isEnabled() ? EDITOR : STUB);
        this.setText(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, ""));
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getEditor().getContentComponent();
    }

    public void selectAll() {
        this.myEditor.selectAll();
    }

    @Override
    public TextWithImports getText() {
        return this.createItem(this.myEditor.getDocument(), this.getProject());
    }

    @Override
    public void setText(TextWithImports text) {
        this.myEditor.setDocument(this.createDocument(text));
        Editor editor = this.myEditor.getEditor();
        if (editor != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).updateVisibleHighlighters(editor);
        }
    }

    @Override
    public TextWithImports createText(String text, String importsString) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text, importsString);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            TextWithImports text = this.getText();
            this.myStubField.setText(text.getText());
            ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, enabled ? EDITOR : STUB);
        }
    }
}

