/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.InternalIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class RendererConfiguration
implements Cloneable,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.settings.NodeRendererSettings");
    private static final int VERSION = 8;
    private List<NodeRenderer> myRepresentationNodes = new ArrayList<NodeRenderer>();
    private final NodeRendererSettings myRendererSettings;

    protected RendererConfiguration(NodeRendererSettings rendererSettings) {
        this.myRendererSettings = rendererSettings;
    }

    public RendererConfiguration clone() {
        RendererConfiguration result = null;
        try {
            result = (RendererConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
        result.myRepresentationNodes = new ArrayList<NodeRenderer>();
        Iterator<NodeRenderer> iterator = this.myRepresentationNodes.iterator();
        while (iterator.hasNext()) {
            result.addRenderer((NodeRenderer)iterator.next().clone());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RendererConfiguration)) {
            return false;
        }
        return DebuggerUtilsEx.externalizableEqual(this, (RendererConfiguration)o);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (NodeRenderer renderer : this.myRepresentationNodes) {
            element.addContent(this.myRendererSettings.writeRenderer(renderer));
        }
        element.setAttribute("VERSION", String.valueOf(8));
    }

    public void readExternal(Element root) {
        String versionAttrib = root.getAttributeValue("VERSION");
        int configurationVersion = -1;
        if (versionAttrib != null) {
            try {
                configurationVersion = Integer.parseInt(versionAttrib);
            }
            catch (NumberFormatException e) {
                configurationVersion = -1;
            }
        }
        if (configurationVersion != 8) {
            return;
        }
        List children = root.getChildren("Renderer");
        this.myRepresentationNodes.clear();
        for (Element nodeElement : children) {
            try {
                this.addRenderer((NodeRenderer)this.myRendererSettings.readRenderer(nodeElement));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public void addRenderer(NodeRenderer renderer) {
        this.myRepresentationNodes.add(renderer);
    }

    public void removeRenderer(NodeRenderer renderer) {
        this.myRepresentationNodes.remove(renderer);
    }

    public void removeAllRenderers() {
        this.myRepresentationNodes.clear();
    }

    public void iterateRenderers(InternalIterator<NodeRenderer> iterator) {
        NodeRenderer renderer;
        boolean shouldContinue;
        Iterator<NodeRenderer> it = this.myRepresentationNodes.iterator();
        while (it.hasNext() && (shouldContinue = iterator.visit((Object)(renderer = it.next())))) {
        }
    }

    public int getRendererCount() {
        return this.myRepresentationNodes.size();
    }
}

