/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CompilerUIConfigurable
implements SearchableConfigurable {
    private JPanel myPanel;
    private final Project myProject;
    private JTextField myResourcePatternsField;
    private JCheckBox myCbCompileInBackground;
    private JCheckBox myCbClearOutputDirectory;
    private JCheckBox myCbCompileDependent;
    private JCheckBox myCbAssertNotNull;
    private JLabel myPatternLegendLabel;

    public CompilerUIConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public void reset() {
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        this.myCbCompileInBackground.setSelected(workspaceConfiguration.COMPILE_IN_BACKGROUND);
        this.myCbCompileDependent.setSelected(workspaceConfiguration.COMPILE_DEPENDENT_FILES);
        this.myCbClearOutputDirectory.setSelected(workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY);
        this.myCbAssertNotNull.setSelected(workspaceConfiguration.ASSERT_NOT_NULL);
        configuration.convertPatterns();
        this.myResourcePatternsField.setText(CompilerUIConfigurable.patternsToString(configuration.getResourceFilePatterns()));
    }

    private static String patternsToString(String[] patterns) {
        StringBuffer extensionsString = new StringBuffer();
        for (int idx = 0; idx < patterns.length; ++idx) {
            if (idx > 0) {
                extensionsString.append(";");
            }
            extensionsString.append(patterns[idx]);
        }
        return extensionsString.toString();
    }

    public void apply() throws ConfigurationException {
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        workspaceConfiguration.COMPILE_IN_BACKGROUND = this.myCbCompileInBackground.isSelected();
        workspaceConfiguration.COMPILE_DEPENDENT_FILES = this.myCbCompileDependent.isSelected();
        workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY = this.myCbClearOutputDirectory.isSelected();
        workspaceConfiguration.ASSERT_NOT_NULL = this.myCbAssertNotNull.isSelected();
        configuration.removeResourceFilePatterns();
        String extensionString = this.myResourcePatternsField.getText().trim();
        CompilerUIConfigurable.applyResourcePatterns(extensionString, (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject));
        TranslatingCompilerFilesMonitor.getInstance().scanSourcesForCompilableFiles(this.myProject);
    }

    private static void applyResourcePatterns(String extensionString, CompilerConfigurationImpl configuration) throws ConfigurationException {
        StringTokenizer tokenizer = new StringTokenizer(extensionString, ";", false);
        ArrayList<String[]> errors = new ArrayList<String[]>();
        while (tokenizer.hasMoreTokens()) {
            String namePattern = tokenizer.nextToken();
            try {
                configuration.addResourceFilePattern(namePattern);
            }
            catch (MalformedPatternException e) {
                errors.add(new String[]{namePattern, e.getLocalizedMessage()});
            }
        }
        if (errors.size() > 0) {
            StringBuffer pattersnsWithErrors = new StringBuffer();
            Iterator i$ = errors.iterator();
            while (i$.hasNext()) {
                String[] error;
                String[] pair = error = (String[])i$.next();
                pattersnsWithErrors.append("\n");
                pattersnsWithErrors.append(pair[0]);
                pattersnsWithErrors.append(": ");
                pattersnsWithErrors.append(pair[1]);
            }
            throw new ConfigurationException(CompilerBundle.message((String)"error.compiler.configurable.malformed.patterns", (Object[])new Object[]{pattersnsWithErrors.toString()}), CompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
        }
    }

    public boolean isModified() {
        boolean isModified = false;
        CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        isModified |= ComparingUtils.isModified(this.myCbCompileInBackground, workspaceConfiguration.COMPILE_IN_BACKGROUND);
        isModified |= ComparingUtils.isModified(this.myCbCompileDependent, workspaceConfiguration.COMPILE_DEPENDENT_FILES);
        isModified |= ComparingUtils.isModified(this.myCbAssertNotNull, workspaceConfiguration.ASSERT_NOT_NULL);
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        isModified |= ComparingUtils.isModified(this.myCbClearOutputDirectory, workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY);
        return isModified |= ComparingUtils.isModified(this.myResourcePatternsField, CompilerUIConfigurable.patternsToString(compilerConfiguration.getResourceFilePatterns()));
    }

    public String getDisplayName() {
        return "General";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public String getId() {
        return "compiler.general";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.resource.patterns.text"), 0, 0, null, null));
        this.myResourcePatternsField = jTextField = new JTextField();
        jTextField.setMargin(new Insets(0, 2, 0, 0));
        jTextField.setText("");
        jTextField.setFocusable(true);
        jPanel3.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 9, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPatternLegendLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.resource.patterns.legend"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCbClearOutputDirectory = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 3, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.clear.output.directory.on.rebuild"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCompileDependent = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.honor.dependencies"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbAssertNotNull = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CompilerBundle").getString("add.notnull.assertions"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCompileInBackground = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 3, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.option.compile.in.background"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

