/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends InspectionTreeNode {
    private static final Icon INFO = IconLoader.getIcon((String)"/compiler/information.png");
    private static final Icon ERROR = IconLoader.getIcon((String)"/compiler/error.png");
    private static final Icon WARNING = IconLoader.getIcon((String)"/compiler/warning.png");
    protected RefEntity myElement;
    private CommonProblemDescriptor myDescriptor;
    protected DescriptorProviderInspection myTool;

    public ProblemDescriptionNode(Object userObject, DescriptorProviderInspection tool) {
        super(userObject);
        this.myTool = tool;
    }

    public ProblemDescriptionNode(RefEntity element, CommonProblemDescriptor descriptor, DescriptorProviderInspection descriptorProviderInspection) {
        super(descriptor);
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myTool = descriptorProviderInspection;
    }

    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.myDescriptor instanceof ProblemDescriptorImpl) {
            ProblemHighlightType problemHighlightType = ((ProblemDescriptorImpl)this.myDescriptor).getHighlightType();
            if (problemHighlightType == ProblemHighlightType.ERROR) {
                return ERROR;
            }
            if (problemHighlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
                return WARNING;
            }
        }
        return INFO;
    }

    @Override
    public int getProblemCount() {
        return 1;
    }

    @Override
    public boolean isValid() {
        if (this.myElement instanceof RefElement && !((RefElement)this.myElement).isValid()) {
            return false;
        }
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isResolved() {
        return this.myElement instanceof RefElement && this.myTool.isElementIgnored(this.myElement);
    }

    @Override
    public void ignoreElement() {
        this.myTool.ignoreCurrentElement(this.getElement());
    }

    @Override
    public void amnesty() {
        this.myTool.amnesty(this.getElement());
    }

    @Override
    public FileStatus getNodeStatus() {
        if (this.myElement instanceof RefElement) {
            return this.myTool.getProblemStatus(this.myDescriptor);
        }
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String toString() {
        return ProblemDescriptionNode.renderDescriptionMessage(this.getDescriptor());
    }

    private static String renderDescriptionMessage(@Nullable CommonProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        String message = descriptor != null ? descriptor.getDescriptionTemplate().replaceAll("<[^>]*>", "") : "";
        message = StringUtil.replace((String)message, (String)"#loc", (String)"");
        int endIndex = (message = StringUtil.replace((String)message, (String)"#ref", (String)ProblemDescriptionNode.extractHighlightedText(descriptor, psiElement))).indexOf("#end");
        if (endIndex > 0) {
            message = message.substring(0, endIndex);
        }
        message = StringUtil.unescapeXml((String)message);
        return message;
    }

    public static String extractHighlightedText(CommonProblemDescriptor descriptor, PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (descriptor instanceof ProblemDescriptorImpl) {
            TextRange textRange = ((ProblemDescriptorImpl)descriptor).getTextRange();
            TextRange elementRange = psiElement.getTextRange();
            if (textRange != null && elementRange != null && (textRange = textRange.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && textRange.getEndOffset() <= ref.length()) {
                ref = textRange.substring(ref);
            }
        }
        return ref;
    }
}

