/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.testOnly;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestOnlyInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.test.only.problems.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/testOnly/TestOnlyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("TestOnlyProblems" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/testOnly/TestOnlyInspection.getShortName must not return null");
        }
        return "TestOnlyProblems";
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/testOnly/TestOnlyInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder h, boolean isOnTheFly) {
        if (h == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/testOnly/TestOnlyInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression e) {
                TestOnlyInspection.this.validate(e, h);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/testOnly/TestOnlyInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private void validate(PsiCallExpression e, ProblemsHolder h) {
        if (!this.isTestOnlyMethodCalled(e)) {
            return;
        }
        if (this.isInsideTestOnlyMethod(e)) {
            return;
        }
        if (this.isInsideTestClass(e)) {
            return;
        }
        if (this.isUnderTestSources(e)) {
            return;
        }
        this.reportProblem(e, h);
    }

    private boolean isTestOnlyMethodCalled(PsiCallExpression e) {
        return this.isAnnotatedAsTestOnly(e.resolveMethod());
    }

    private boolean isInsideTestOnlyMethod(PsiCallExpression e) {
        PsiMethod m = this.getTopLevelParentOfType((PsiElement)e, PsiMethod.class);
        return this.isAnnotatedAsTestOnly(m);
    }

    private boolean isAnnotatedAsTestOnly(@Nullable PsiMethod m) {
        if (m == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)m, (String)"org.jetbrains.annotations.TestOnly", (boolean)false);
    }

    private boolean isInsideTestClass(PsiCallExpression e) {
        PsiClass c = this.getTopLevelParentOfType((PsiElement)e, PsiClass.class);
        if (c == null) {
            return false;
        }
        return TestUtil.isTestClass((PsiClass)c);
    }

    private <T extends PsiElement> T getTopLevelParentOfType(PsiElement e, Class<T> c) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)e, c);
        if (parent == null) {
            return null;
        }
        PsiElement next;
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)parent, c)) != null) {
            parent = next;
        }
        return (T)parent;
    }

    private boolean isUnderTestSources(PsiCallExpression e) {
        ProjectRootManager rm = ProjectRootManager.getInstance((Project)e.getProject());
        VirtualFile f = e.getContainingFile().getVirtualFile();
        if (f == null) {
            return false;
        }
        return rm.getFileIndex().isInTestSourceContent(f);
    }

    private void reportProblem(PsiCallExpression e, ProblemsHolder h) {
        String message = InspectionsBundle.message((String)"inspection.test.only.problems.test.only.method.call", (Object[])new Object[0]);
        h.registerProblem((PsiElement)e, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }
}

