/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.offlineViewer.OfflineRefElementNode;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class OfflineInspectionRVContentProvider
extends InspectionRVContentProvider {
    private final Map<String, Map<String, Set<OfflineProblemDescriptor>>> myContent;

    public OfflineInspectionRVContentProvider(Map<String, Map<String, Set<OfflineProblemDescriptor>>> content, Project project) {
        super(project);
        this.myContent = content;
    }

    @Override
    public boolean checkReportedProblems(InspectionTool tool) {
        Map<String, Set<OfflineProblemDescriptor>> content = this.getFilteredContent(tool);
        return content != null && !content.values().isEmpty();
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(InspectionTool tool, InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        final ArrayList selectedElements = new ArrayList();
        final HashMap<RefEntity, Set<QuickFix>> actions = new HashMap<RefEntity, Set<QuickFix>>();
        for (TreePath selectionPath : treePaths) {
            TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (!((InspectionTreeNode)node).isValid()) {
                        return true;
                    }
                    if (node instanceof OfflineProblemDescriptorNode) {
                        QuickFix[] fixes;
                        CommonProblemDescriptor descriptor;
                        OfflineProblemDescriptorNode descriptorNode = (OfflineProblemDescriptorNode)node;
                        RefEntity element = descriptorNode.getElement();
                        selectedElements.add(element);
                        Set quickFixes = (Set)actions.get(element);
                        if (quickFixes == null) {
                            quickFixes = new HashSet();
                            actions.put(element, quickFixes);
                        }
                        if ((descriptor = descriptorNode.getDescriptor()) != null && (fixes = descriptor.getFixes()) != null) {
                            quickFixes.addAll(Arrays.asList(fixes));
                        }
                    } else if (node instanceof RefElementNode) {
                        selectedElements.add(((RefElementNode)node).getElement());
                    }
                    return true;
                }
            });
        }
        if (selectedElements.isEmpty()) {
            return null;
        }
        RefEntity[] selectedRefElements = selectedElements.toArray(new RefEntity[selectedElements.size()]);
        if (tool instanceof DescriptorProviderInspection) {
            return ((DescriptorProviderInspection)tool).extractActiveFixes(selectedRefElements, actions);
        }
        return tool.getQuickFixes(selectedRefElements);
    }

    @Override
    public boolean isContentLoaded() {
        return false;
    }

    @Override
    public void appendToolNodeContent(InspectionNode toolNode, InspectionTreeNode parentNode, boolean showStructure) {
        InspectionTool tool = toolNode.getTool();
        Map filteredContent = this.getFilteredContent(tool);
        if (filteredContent != null && !filteredContent.values().isEmpty()) {
            Function<OfflineProblemDescriptor, InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor>> computeContainer = new Function<OfflineProblemDescriptor, InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor>>(){

                public InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor> fun(OfflineProblemDescriptor descriptor) {
                    return new OfflineProblemDescriptorContainer(descriptor);
                }
            };
            List<InspectionTreeNode> list = this.buildTree(filteredContent, false, tool, computeContainer, showStructure);
            for (InspectionTreeNode node : list) {
                toolNode.add(node);
            }
            parentNode.add(toolNode);
        }
    }

    @Nullable
    private Map<String, Set<OfflineProblemDescriptor>> getFilteredContent(InspectionTool tool) {
        Map<String, Set<OfflineProblemDescriptor>> content = this.myContent.get(tool.getShortName());
        if (content == null) {
            return null;
        }
        if (tool.getContext().getUIOptions().FILTER_RESOLVED_ITEMS) {
            HashMap<String, Set<OfflineProblemDescriptor>> current = new HashMap<String, Set<OfflineProblemDescriptor>>(content);
            content = null;
            for (RefEntity refEntity : tool.getIgnoredRefElements()) {
                if (!(refEntity instanceof RefElement)) continue;
                OfflineInspectionRVContentProvider.excludeProblem(refEntity.getExternalName(), current);
            }
            return current;
        }
        return content;
    }

    private static void excludeProblem(String externalName, Map<String, Set<OfflineProblemDescriptor>> content) {
        Iterator<String> iter = content.keySet().iterator();
        while (iter.hasNext()) {
            String packageName = iter.next();
            HashSet excluded = new HashSet((Collection)content.get(packageName));
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                OfflineProblemDescriptor ex = (OfflineProblemDescriptor)it.next();
                if (!Comparing.strEqual((String)ex.getFQName(), (String)externalName)) continue;
                it.remove();
            }
            if (excluded.isEmpty()) {
                iter.remove();
                continue;
            }
            content.put(packageName, (Set<OfflineProblemDescriptor>)excluded);
        }
    }

    @Override
    protected void appendDescriptor(InspectionTool tool, InspectionRVContentProvider.UserObjectContainer container, InspectionPackageNode packageNode, boolean canPackageRepeat) {
        RefElementNode elemNode = OfflineInspectionRVContentProvider.addNodeToParent(container, tool, packageNode);
        if (tool instanceof DescriptorProviderInspection) {
            elemNode.add(new OfflineProblemDescriptorNode(((OfflineProblemDescriptorContainer)container).getUserObject(), (DescriptorProviderInspection)tool));
        }
    }

    private static class OfflineProblemDescriptorContainer
    implements InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor> {
        private final OfflineProblemDescriptor myDescriptor;

        public OfflineProblemDescriptorContainer(OfflineProblemDescriptor descriptor) {
            this.myDescriptor = descriptor;
        }

        @Nullable
        public OfflineProblemDescriptorContainer getOwner() {
            OfflineProblemDescriptor descriptor = this.myDescriptor.getOwner();
            if (descriptor != null) {
                OfflineProblemDescriptorContainer container = new OfflineProblemDescriptorContainer(descriptor);
                return container.supportStructure() ? container : null;
            }
            return null;
        }

        @Override
        public RefElementNode createNode(InspectionTool tool) {
            return new OfflineRefElementNode(this.myDescriptor, tool);
        }

        @Override
        public OfflineProblemDescriptor getUserObject() {
            return this.myDescriptor;
        }

        @Override
        public String getModule() {
            return this.myDescriptor.getModuleName();
        }

        @Override
        public boolean areEqual(OfflineProblemDescriptor o1, OfflineProblemDescriptor o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            if (!Comparing.strEqual((String)o1.getFQName(), (String)o2.getFQName())) {
                return false;
            }
            return Comparing.strEqual((String)o1.getType(), (String)o2.getType());
        }

        @Override
        public boolean supportStructure() {
            return !Comparing.strEqual((String)this.myDescriptor.getType(), (String)"module") && !Comparing.strEqual((String)this.myDescriptor.getType(), (String)"package") && !Comparing.strEqual((String)this.myDescriptor.getType(), (String)"project");
        }
    }
}

