/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BinopInstruction
extends BranchingInstruction {
    private final String myOperationSign;
    private final Project myProject;

    public BinopInstruction(@NonNls String opSign, PsiElement psiAnchor, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/dataFlow/instructions/BinopInstruction.<init> must not be null");
        }
        this.myProject = project;
        this.myOperationSign = opSign != null && ("==".equals(opSign) || "!=".equals(opSign) || "instanceof".equals(opSign) || "+".equals(opSign)) ? opSign : null;
        this.setPsiAnchor(psiAnchor);
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitBinop(this, runner, stateBefore);
    }

    public DfaValue getNonNullStringValue(DfaValueFactory factory) {
        PsiElement anchor = this.getPsiAnchor();
        Project project = this.myProject;
        PsiClassType string = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)(anchor == null ? GlobalSearchScope.allScope((Project)project) : anchor.getResolveScope()));
        return factory.getNotNullFactory().create((PsiType)string);
    }

    @Override
    public String toString() {
        return "BINOP " + this.myOperationSign;
    }

    public String getOperationSign() {
        return this.myOperationSign;
    }
}

