/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnnotatorBasedInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AnnotatorBasedInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public void runInspection(AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        scope.accept((PsiElementVisitor)new MyPsiRecursiveElementVisitor(manager, globalContext, problemDescriptionsProcessor));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AnnotatorBasedInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Annotator" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AnnotatorBasedInspection.getDisplayName must not return null");
        }
        return "Annotator";
    }

    @NotNull
    public String getShortName() {
        if ("Annotator" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AnnotatorBasedInspection.getShortName must not return null");
        }
        return "Annotator";
    }

    private static class MyPsiRecursiveElementVisitor
    extends PsiRecursiveElementVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor {
        private final AnnotationHolder myHolder;
        private List<Annotator> annotators;
        private PsiFile myFile;

        public MyPsiRecursiveElementVisitor(final InspectionManager manager, final GlobalInspectionContext globalContext, final ProblemDescriptionsProcessor problemDescriptionsProcessor) {
            this.myHolder = new AnnotationHolderImpl(){

                @Override
                public Annotation createErrorAnnotation(@NotNull PsiElement elt, String message) {
                    if (elt == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/AnnotatorBasedInspection$MyPsiRecursiveElementVisitor$1.createErrorAnnotation must not be null");
                    }
                    return this.createProblem(elt, message, ProblemHighlightType.ERROR, HighlightSeverity.ERROR, null);
                }

                @Override
                public Annotation createWarningAnnotation(PsiElement elt, String message) {
                    return this.createProblem(elt, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, HighlightSeverity.WARNING, null);
                }

                @Override
                public Annotation createInfoAnnotation(PsiElement elt, String message) {
                    return super.createInfoAnnotation(elt, message);
                }

                @Override
                public Annotation createInformationAnnotation(PsiElement elt, String message) {
                    return this.createProblem(elt, message, ProblemHighlightType.INFORMATION, HighlightSeverity.INFORMATION, null);
                }

                private Annotation createProblem(PsiElement elt, String message, ProblemHighlightType problemHighlightType, HighlightSeverity severity, TextRange range) {
                    GlobalInspectionUtil.createProblem(elt, message, problemHighlightType, range, manager, problemDescriptionsProcessor, globalContext);
                    return super.createAnnotation(elt.getTextRange(), severity, message);
                }

                @Override
                public Annotation createErrorAnnotation(ASTNode node, String message) {
                    return this.createErrorAnnotation(node.getPsi(), message);
                }

                @Override
                public Annotation createWarningAnnotation(ASTNode node, String message) {
                    return this.createWarningAnnotation(node.getPsi(), message);
                }

                @Override
                public Annotation createInformationAnnotation(ASTNode node, String message) {
                    return this.createInformationAnnotation(node.getPsi(), message);
                }

                @Override
                public Annotation createInfoAnnotation(ASTNode node, String message) {
                    return this.createInfoAnnotation(node.getPsi(), message);
                }

                @Override
                protected Annotation createAnnotation(TextRange range, HighlightSeverity severity, String message) {
                    if (severity != HighlightSeverity.INFORMATION) {
                        GlobalInspectionUtil.createProblem((PsiElement)MyPsiRecursiveElementVisitor.this.myFile, message, HighlightInfo.convertSeverityToProblemHighlight(severity), range, manager, problemDescriptionsProcessor, globalContext);
                    }
                    return super.createAnnotation(range, severity, message);
                }
            };
        }

        public void visitFile(PsiFile file) {
            this.myFile = file;
            super.visitFile(file);
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            List elemAnnos = this.annotators != null ? this.annotators : LanguageAnnotators.INSTANCE.allForLanguage(element.getLanguage());
            for (Annotator annotator : elemAnnos) {
                annotator.annotate(element, this.myHolder);
            }
            if (element instanceof PsiLanguageInjectionHost) {
                ((PsiLanguageInjectionHost)element).processInjectedPsi((PsiLanguageInjectionHost.InjectedPsiVisitor)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/AnnotatorBasedInspection$MyPsiRecursiveElementVisitor.visit must not be null");
            }
            if (places == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/AnnotatorBasedInspection$MyPsiRecursiveElementVisitor.visit must not be null");
            }
            try {
                this.annotators = LanguageAnnotators.INSTANCE.allForLanguage(injectedPsi.getLanguage());
                injectedPsi.acceptChildren((PsiElementVisitor)this);
            }
            finally {
                this.annotators = null;
            }
        }
    }
}

