/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.text.BlockSupport;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeMacro
implements Macro {
    public String getName() {
        return "expectedType";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.expected.type", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ExpectedTypeMacro.calculateResult must not be null");
        }
        PsiType[] types = ExpectedTypeMacro.getExpectedTypes(params, context);
        if (types == null || types.length == 0) {
            return null;
        }
        return new PsiTypeResult(types[0], context.getProject());
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ExpectedTypeMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/ExpectedTypeMacro.calculateLookupItems must not be null");
        }
        PsiType[] types = ExpectedTypeMacro.getExpectedTypes(params, context);
        if (types == null || types.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        for (PsiType type : types) {
            JavaTemplateUtil.addTypeLookupItem(set, type);
        }
        return set.toArray(new LookupElement[set.size()]);
    }

    @Nullable
    private static PsiType[] getExpectedTypes(Expression[] params, ExpressionContext context) {
        ExpectedTypeInfo[] infos;
        if (params.length != 0) {
            return null;
        }
        final Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiType[] types = null;
        final int offset = context.getTemplateStartOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        assert (file != null);
        final PsiFile fileCopy = (PsiFile)file.copy();
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(com.intellij.openapi.application.Result result) throws Throwable {
                BlockSupport blockSupport = (BlockSupport)ServiceManager.getService((Project)project, BlockSupport.class);
                blockSupport.reparseRange(fileCopy, offset, offset, "IntellijIdeaRulezzz ");
            }
        }.execute();
        PsiElement element = fileCopy.findElementAt(offset);
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiExpression && (infos = ExpectedTypesProvider.getInstance(project).getExpectedTypes((PsiExpression)element.getParent(), true)).length > 0) {
            types = new PsiType[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                ExpectedTypeInfo info = infos[i];
                types[i] = info.getType();
            }
        }
        return types;
    }
}

