/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTypeDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(AnActionEvent event) {
        if (((TypeDeclarationProvider[])Extensions.getExtensions(TypeDeclarationProvider.EP_NAME)).length == 0) {
            event.getPresentation().setVisible(false);
        } else {
            super.update(event);
        }
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        try {
            PsiElement[] symbolTypes = GotoTypeDeclarationAction.findSymbolTypes(editor, offset);
            if (symbolTypes == null || symbolTypes.length == 0) {
                return;
            }
            if (symbolTypes.length == 1) {
                GotoTypeDeclarationAction.navigate(project, symbolTypes[0]);
            } else {
                NavigationUtil.getPsiElementPopup(symbolTypes, CodeInsightBundle.message((String)"choose.type.popup.title", (Object[])new Object[0])).showInBestPositionFor(editor);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Type information is not available during index update");
        }
    }

    private static void navigate(@NotNull Project project, @NotNull PsiElement symbolType) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction.navigate must not be null");
        }
        if (symbolType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction.navigate must not be null");
        }
        PsiElement element = symbolType.getNavigationElement();
        assert (element != null);
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (file != null) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, element.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findSymbolType(Editor editor, int offset) {
        PsiElement[] psiElements = GotoTypeDeclarationAction.findSymbolTypes(editor, offset);
        if (psiElements != null && psiElements.length > 0) {
            return psiElements[0];
        }
        return null;
    }

    @Nullable
    public static PsiElement[] findSymbolTypes(Editor editor, int offset) {
        PsiElement targetElement = TargetElementUtilBase.getInstance().findTargetElement(editor, 11, offset);
        if (targetElement != null) {
            PsiElement[] symbolType = GotoTypeDeclarationAction.getSymbolTypeDeclarations(targetElement);
            return symbolType == null ? PsiElement.EMPTY_ARRAY : symbolType;
        }
        PsiReference psiReference = TargetElementUtilBase.findReference(editor, offset);
        if (psiReference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)psiReference).multiResolve(false);
            THashSet types = new THashSet();
            for (ResolveResult r : results) {
                PsiElement[] declarations = GotoTypeDeclarationAction.getSymbolTypeDeclarations(r.getElement());
                if (declarations == null) continue;
                for (PsiElement declaration : declarations) {
                    assert (declaration != null);
                    types.add(declaration);
                }
            }
            if (!types.isEmpty()) {
                return types.toArray(new PsiElement[types.size()]);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement[] getSymbolTypeDeclarations(PsiElement targetElement) {
        for (TypeDeclarationProvider provider : (TypeDeclarationProvider[])Extensions.getExtensions(TypeDeclarationProvider.EP_NAME)) {
            PsiElement[] result = provider.getSymbolTypeDeclarations(targetElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

