/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.ShowLookupActionsHandler;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.plaf.beg.BegPopupMenuBorder;
import com.intellij.ui.popup.PopupIcons;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AsyncProcessIcon;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupImpl
extends LightweightHint
implements Lookup,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupImpl");
    private static final int MAX_PREFERRED_COUNT = 5;
    private static final LookupItem EMPTY_LOOKUP_ITEM = LookupItem.fromString("preselect");
    private final Project myProject;
    private final Editor myEditor;
    private final Map<LookupElement, Collection<LookupElementAction>> myItemActions;
    private int myMinPrefixLength;
    private int myPreferredItemsCount;
    private RangeMarker myInitialOffset;
    private RangeMarker myInitialSelection;
    private long myShownStamp;
    private String myInitialPrefix;
    private final LookupArranger myArranger;
    private final ArrayList<LookupElement> myItems;
    @Nullable
    private List<LookupElement> mySortedItems;
    private RangeMarker myLookupStartMarker;
    private int myOldLookupStartOffset;
    private final JList myList;
    private final LookupCellRenderer myCellRenderer;
    private Boolean myPositionedAbove;
    private CaretListener myEditorCaretListener;
    private SelectionListener myEditorSelectionListener;
    private EditorMouseListener myEditorMouseListener;
    private final ArrayList<LookupListener> myListeners;
    private boolean myDisposed;
    private boolean myHidden;
    private LookupElement myPreselectedItem;
    private boolean myDirty;
    private String myAdditionalPrefix;
    private final AsyncProcessIcon myProcessIcon;
    private volatile boolean myCalculating;
    private final JLabel myAdComponent;
    private volatile String myAdText;
    private volatile int myLookupWidth;
    private static final int LOOKUP_HEIGHT = Integer.getInteger("idea.lookup.height", 11);

    public LookupImpl(Project project, Editor editor, @NotNull LookupArranger arranger) {
        if (arranger == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/LookupImpl.<init> must not be null");
        }
        super(new JPanel(new BorderLayout()));
        this.myItemActions = new ConcurrentHashMap();
        this.myShownStamp = -1L;
        this.myPositionedAbove = null;
        this.myListeners = new ArrayList();
        this.myDisposed = false;
        this.myHidden = false;
        this.myPreselectedItem = EMPTY_LOOKUP_ITEM;
        this.myAdditionalPrefix = "";
        this.myLookupWidth = 50;
        this.myProject = project;
        this.myEditor = editor;
        this.myArranger = arranger;
        this.myItems = new ArrayList();
        this.setInitialOffset(this.myEditor.getCaretModel().getOffset(), this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
        this.myProcessIcon = new AsyncProcessIcon("Completion progress");
        this.myProcessIcon.setVisible(false);
        this.myList = new JList(new DefaultListModel());
        this.myCellRenderer = new LookupCellRenderer(this);
        this.myList.setCellRenderer(this.myCellRenderer);
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(0);
        this.myList.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        JScrollPane scrollPane = new JScrollPane(this.myList);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.getComponent().add((Component)scrollPane, "North");
        scrollPane.setBorder(null);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.myProcessIcon, "East");
        this.myAdComponent = HintUtil.createAdComponent(null);
        bottomPanel.add((Component)this.myAdComponent, "Center");
        this.getComponent().add((Component)bottomPanel, "South");
        this.getComponent().setBorder(new BegPopupMenuBorder());
        ListModel model = this.myList.getModel();
        this.addEmptyItem((DefaultListModel)model);
        this.updateListHeight(model);
    }

    public AsyncProcessIcon getProcessIcon() {
        return this.myProcessIcon;
    }

    public boolean isCalculating() {
        return this.myCalculating;
    }

    public void setCalculating(boolean calculating) {
        this.myCalculating = calculating;
    }

    public int getPreferredItemsCount() {
        return this.myPreferredItemsCount;
    }

    public void markDirty() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.myDirty = true;
        this.myPreselectedItem = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resort() {
        ArrayList<LookupElement> items;
        this.myDirty = false;
        this.myPreselectedItem = EMPTY_LOOKUP_ITEM;
        ArrayList<LookupElement> arrayList = this.myItems;
        synchronized (arrayList) {
            items = new ArrayList<LookupElement>(this.myItems);
            this.myItems.clear();
            this.mySortedItems = null;
        }
        for (LookupElement item : items) {
            this.addItem(item);
        }
        this.updateList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(LookupElement item) {
        CollectConsumer consumer = new CollectConsumer();
        for (LookupActionProvider provider : (LookupActionProvider[])LookupActionProvider.EP_NAME.getExtensions()) {
            provider.fillActions(item, this, (Consumer<LookupElementAction>)consumer);
        }
        this.myItemActions.put(item, consumer.getResult());
        int maxWidth = this.myCellRenderer.updateMaximumWidth(item);
        this.myLookupWidth = Math.max(maxWidth, this.myLookupWidth);
        ArrayList<LookupElement> arrayList = this.myItems;
        synchronized (arrayList) {
            this.myItems.add(item);
            this.mySortedItems = null;
        }
    }

    public Collection<LookupElementAction> getActionsFor(LookupElement element) {
        Collection<LookupElementAction> collection = this.myItemActions.get(element);
        return collection == null ? Collections.emptyList() : collection;
    }

    public int getMinPrefixLength() {
        return this.myMinPrefixLength;
    }

    public JList getList() {
        return this.myList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<LookupElement> getSortedItems() {
        ArrayList<LookupElement> arrayList = this.myItems;
        // MONITORENTER : arrayList
        List<LookupElement> sortedItems = this.mySortedItems;
        if (sortedItems == null) {
            sortedItems = new ArrayList<LookupElement>(this.myItems);
            this.myArranger.sortItems(sortedItems);
            this.mySortedItems = sortedItems;
        }
        List<LookupElement> list = sortedItems;
        // MONITOREXIT : arrayList
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/impl/LookupImpl.getSortedItems must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LookupElement> getItems() {
        Object[] objects;
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        JList jList = this.myList;
        synchronized (jList) {
            objects = ((DefaultListModel)this.myList.getModel()).toArray();
        }
        for (Object object : objects) {
            if (object instanceof EmptyLookupItem) continue;
            result.add((LookupElement)object);
        }
        return result;
    }

    public void setAdvertisementText(@Nullable String text) {
        this.myAdText = text;
    }

    public String getAdvertisementText() {
        return this.myAdText;
    }

    public String getAdditionalPrefix() {
        return this.myAdditionalPrefix;
    }

    public void setAdditionalPrefix(String additionalPrefix) {
        this.myAdditionalPrefix = additionalPrefix;
        this.myInitialPrefix = null;
        this.markDirty();
        this.updateList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList() {
        boolean hasItems;
        boolean hasPreselectedItem;
        boolean hasExactPrefixes;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        List<LookupElement> items = this.getSortedItems();
        TreeMap<Comparable, ArrayList<LookupElement>> itemsMap = new TreeMap<Comparable, ArrayList<LookupElement>>();
        int minPrefixLength = items.isEmpty() ? 0 : Integer.MAX_VALUE;
        for (LookupElement item : items) {
            minPrefixLength = Math.min(item.getPrefixMatcher().getPrefix().length(), minPrefixLength);
            Comparable relevance = this.myArranger.getRelevance(item);
            ArrayList<LookupElement> list = (ArrayList<LookupElement>)itemsMap.get(relevance);
            if (list == null) {
                list = new ArrayList<LookupElement>();
                itemsMap.put(relevance, list);
            }
            list.add(item);
        }
        if (this.myMinPrefixLength != minPrefixLength) {
            this.myLookupStartMarker = null;
            this.myOldLookupStartOffset = -1;
        }
        this.myMinPrefixLength = minPrefixLength;
        Object oldSelected = !this.myDirty ? null : this.myList.getSelectedValue();
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        LookupElement preselectedItem = this.myPreselectedItem;
        JList jList = this.myList;
        synchronized (jList) {
            model.clear();
            THashSet firstItems = new THashSet();
            hasExactPrefixes = this.addExactPrefixItems(model, (Set<LookupElement>)firstItems, items);
            this.addMostRelevantItems(model, (Set<LookupElement>)firstItems, itemsMap.values());
            hasPreselectedItem = this.addPreselectedItem(model, (Set<LookupElement>)firstItems, preselectedItem);
            this.myPreferredItemsCount = firstItems.size();
            this.addRemainingItemsLexicographically(model, (Set<LookupElement>)firstItems, items);
            boolean bl = hasItems = model.getSize() != 0;
            if (!hasItems) {
                this.addEmptyItem(model);
            }
        }
        this.updateListHeight(model);
        this.myAdComponent.setText(this.myAdText);
        if (hasItems) {
            this.myList.setFixedCellWidth(Math.max(this.myLookupWidth, this.myAdComponent.getPreferredSize().width));
        }
        if (hasItems) {
            if (oldSelected != null) {
                if (hasExactPrefixes || !ListScrollingUtil.selectItem((JList)this.myList, oldSelected)) {
                    this.selectMostPreferableItem();
                }
            } else if (preselectedItem == EMPTY_LOOKUP_ITEM) {
                this.selectMostPreferableItem();
                this.myPreselectedItem = this.getCurrentItem();
            } else if (hasPreselectedItem && !hasExactPrefixes) {
                ListScrollingUtil.selectItem((JList)this.myList, (Object)preselectedItem);
            } else {
                this.selectMostPreferableItem();
            }
        }
    }

    private void updateListHeight(ListModel model) {
        this.myList.setFixedCellHeight(this.myCellRenderer.getListCellRendererComponent((JList)this.myList, model.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height);
        this.myList.setVisibleRowCount(Math.min(model.getSize(), LOOKUP_HEIGHT));
    }

    private void addEmptyItem(DefaultListModel model) {
        EmptyLookupItem item = new EmptyLookupItem(this.myCalculating ? " " : LangBundle.message("completion.no.suggestions", new Object[0]));
        item.setPrefixMatcher(new CamelHumpMatcher(""));
        if (!this.myCalculating) {
            int maxWidth = this.myCellRenderer.updateMaximumWidth((LookupElement)item);
            this.myList.setFixedCellWidth(Math.max(maxWidth, this.myLookupWidth));
        }
        model.addElement(item);
    }

    private void addRemainingItemsLexicographically(DefaultListModel model, Set<LookupElement> firstItems, List<LookupElement> myItems) {
        for (LookupElement item : myItems) {
            if (firstItems.contains(item) || !this.prefixMatches(item)) continue;
            model.addElement(item);
        }
    }

    private boolean addPreselectedItem(DefaultListModel model, Set<LookupElement> firstItems, @Nullable LookupElement preselectedItem) {
        boolean hasPreselectedItem;
        boolean bl = hasPreselectedItem = !this.myDirty && preselectedItem != EMPTY_LOOKUP_ITEM && preselectedItem != null;
        if (hasPreselectedItem && !firstItems.contains(preselectedItem)) {
            firstItems.add(preselectedItem);
            model.addElement(preselectedItem);
        }
        return hasPreselectedItem;
    }

    private void addMostRelevantItems(DefaultListModel model, Set<LookupElement> firstItems, Collection<List<LookupElement>> sortedItems) {
        for (List<LookupElement> elements : sortedItems) {
            SmartList suitable = new SmartList();
            for (LookupElement item : elements) {
                if (firstItems.contains(item) || !this.prefixMatches(item)) continue;
                suitable.add(item);
            }
            if (firstItems.size() + suitable.size() > 5) break;
            for (LookupElement item : suitable) {
                firstItems.add(item);
                model.addElement(item);
            }
        }
    }

    private boolean addExactPrefixItems(DefaultListModel model, Set<LookupElement> firstItems, List<LookupElement> elements) {
        SortedList sorted = new SortedList((Comparator)new Comparator<LookupElement>(){

            @Override
            public int compare(LookupElement o1, LookupElement o2) {
                return LookupImpl.this.myArranger.getRelevance(o1).compareTo(LookupImpl.this.myArranger.getRelevance(o2));
            }
        });
        for (LookupElement item : elements) {
            if (!this.isExactPrefixItem(item)) continue;
            sorted.add(item);
        }
        for (LookupElement item : sorted) {
            model.addElement(item);
            firstItems.add(item);
        }
        return !firstItems.isEmpty();
    }

    private boolean isExactPrefixItem(LookupElement item) {
        return item.getAllLookupStrings().contains(item.getPrefixMatcher().getPrefix() + this.myAdditionalPrefix);
    }

    private boolean prefixMatches(LookupElement item) {
        if (this.myAdditionalPrefix.length() == 0) {
            return item.isPrefixMatched();
        }
        return item.getPrefixMatcher().cloneWithPrefix(item.getPrefixMatcher().getPrefix() + this.myAdditionalPrefix).prefixMatches(item);
    }

    public Point calculatePosition() {
        int wshift;
        Dimension dim = this.getComponent().getPreferredSize();
        int lookupStart = this.getLookupStart();
        if (lookupStart < 0) {
            LOG.error(lookupStart + "; minprefix=" + this.myMinPrefixLength + "; offset=" + this.myEditor.getCaretModel().getOffset() + "; element=" + this.getPsiElement());
        }
        LogicalPosition pos = this.myEditor.offsetToLogicalPosition(lookupStart);
        Point location = this.myEditor.logicalPositionToXY(pos);
        location.y += this.myEditor.getLineHeight();
        JComponent editorComponent = this.myEditor.getComponent();
        JComponent internalComponent = this.myEditor.getContentComponent();
        JRootPane rootPane = editorComponent.getRootPane();
        if (rootPane == null) {
            LOG.error((Object)this.myArranger);
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Point layeredPanePoint = SwingUtilities.convertPoint(internalComponent, location, layeredPane);
        layeredPanePoint.x -= this.myCellRenderer.getIconIndent();
        if (dim.width > layeredPane.getWidth()) {
            dim.width = layeredPane.getWidth();
        }
        if ((wshift = layeredPane.getWidth() - (layeredPanePoint.x + dim.width)) < 0) {
            layeredPanePoint.x += wshift;
        }
        int shiftLow = layeredPane.getHeight() - (layeredPanePoint.y + dim.height);
        int shiftHigh = layeredPanePoint.y - dim.height;
        Boolean bl = this.myPositionedAbove = shiftLow < 0 && shiftLow < shiftHigh ? Boolean.TRUE : Boolean.FALSE;
        if (this.myPositionedAbove.booleanValue()) {
            layeredPanePoint.y -= dim.height + this.myEditor.getLineHeight();
        }
        return layeredPanePoint;
    }

    public void finishLookup(char completionChar) {
        if (this.myShownStamp > 0L && System.currentTimeMillis() - this.myShownStamp < 42L && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final LookupElement item = (LookupElement)this.myList.getSelectedValue();
        this.doHide(false);
        if (item == null || item instanceof EmptyLookupItem || item.getObject() instanceof DeferredUserLookupValue && item.as(LookupItem.class) != null && !((DeferredUserLookupValue)item.getObject()).handleUserSelection((LookupItem)item.as(LookupItem.class), this.myProject)) {
            this.fireItemSelected(null, completionChar);
            return;
        }
        PsiFile file = this.getPsiFile();
        if (file != null && !WriteCommandAction.ensureFilesWritable((Project)this.myProject, Arrays.asList(file))) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                EditorModificationUtil.deleteSelectedText((Editor)LookupImpl.this.myEditor);
                int caretOffset = LookupImpl.this.myEditor.getCaretModel().getOffset();
                String prefix = item.getPrefixMatcher().getPrefix();
                int lookupStart = caretOffset - prefix.length() - LookupImpl.this.myAdditionalPrefix.length();
                String lookupString = item.getLookupString();
                if (!StringUtil.startsWithConcatenationOf((String)lookupString, (String)prefix, (String)LookupImpl.this.myAdditionalPrefix)) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
                }
                LookupImpl.this.myEditor.getDocument().replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
                int offset = lookupStart + lookupString.length();
                LookupImpl.this.myEditor.getCaretModel().moveToOffset(offset);
                LookupImpl.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                LookupImpl.this.myEditor.getSelectionModel().removeSelection();
            }
        });
        this.fireItemSelected(item, completionChar);
    }

    public int getLookupStart() {
        return this.myLookupStartMarker != null ? this.myLookupStartMarker.getStartOffset() : this.calcLookupStart();
    }

    @Override
    protected void beforeShow() {
        if (this.isRealPopup()) {
            this.getComponent().setBorder(null);
        }
    }

    public void show() {
        int lookupStart;
        assert (!this.myDisposed);
        this.myOldLookupStartOffset = lookupStart = this.calcLookupStart();
        this.myLookupStartMarker = this.myEditor.getDocument().createRangeMarker(lookupStart, lookupStart);
        this.myLookupStartMarker.setGreedyToLeft(true);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (LookupImpl.this.myLookupStartMarker != null && !LookupImpl.this.myLookupStartMarker.isValid()) {
                    LookupImpl.this.hide();
                }
            }
        }, (Disposable)this);
        this.myEditorCaretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                LookupImpl.this.caretOrSelectionChanged();
            }
        };
        this.myEditorSelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                LookupImpl.this.caretOrSelectionChanged();
            }
        };
        this.myEditor.getCaretModel().addCaretListener(this.myEditorCaretListener);
        this.myEditor.getSelectionModel().addSelectionListener(this.myEditorSelectionListener);
        this.myEditorMouseListener = new EditorMouseAdapter(){

            public void mouseClicked(EditorMouseEvent e) {
                e.consume();
                LookupImpl.this.hide();
            }
        };
        this.myEditor.addEditorMouseListener(this.myEditorMouseListener);
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private LookupElement oldItem = null;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LookupElement item = LookupImpl.this.getCurrentItem();
                if (this.oldItem != item) {
                    LookupImpl.this.fireCurrentItemChanged(item);
                }
                this.oldItem = item;
            }
        });
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Collection<LookupElementAction> actions;
                LookupElement selected;
                Point point = e.getPoint();
                int i = LookupImpl.this.myList.locationToIndex(point);
                if (i >= 0 && (selected = (LookupElement)LookupImpl.this.myList.getModel().getElementAt(i)) != null && !(actions = LookupImpl.this.getActionsFor(selected)).isEmpty() && e.getClickCount() == 1 && point.x >= ((LookupImpl)LookupImpl.this).myList.getCellBounds((int)i, (int)i).width - PopupIcons.EMPTY_ICON.getIconWidth()) {
                    ShowLookupActionsHandler.showItemActions(LookupImpl.this, actions);
                    return;
                }
                if (e.getClickCount() == 2) {
                    CommandProcessor.getInstance().executeCommand(LookupImpl.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            LookupImpl.this.finishLookup('\n');
                        }
                    }, "", null);
                }
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Point p = this.calculatePosition();
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        hintManager.showEditorHint((LightweightHint)this, this.myEditor, p, 129, 0, false);
        this.myShownStamp = System.currentTimeMillis();
    }

    private void caretOrSelectionChanged() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LookupImpl.this.myEditor.isDisposed() || LookupImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (!LookupImpl.this.myInitialOffset.isValid() || !LookupImpl.this.myInitialSelection.isValid()) {
                    LookupImpl.this.hide();
                    return;
                }
                SelectionModel selectionModel = LookupImpl.this.myEditor.getSelectionModel();
                if (selectionModel.hasSelection()) {
                    if (LookupImpl.this.myInitialSelection.getStartOffset() != selectionModel.getSelectionStart() || LookupImpl.this.myInitialSelection.getEndOffset() != selectionModel.getSelectionEnd()) {
                        LookupImpl.this.hide();
                        return;
                    }
                } else if (LookupImpl.this.myEditor.getCaretModel().getOffset() != LookupImpl.this.myInitialOffset.getStartOffset() + LookupImpl.this.myAdditionalPrefix.length()) {
                    LookupImpl.this.hide();
                    return;
                }
                if (LookupImpl.this.myOldLookupStartOffset != LookupImpl.this.getLookupStart()) {
                    LookupImpl.this.refreshUi();
                }
            }
        });
    }

    private int calcLookupStart() {
        int offset = this.myEditor.getSelectionModel().hasSelection() ? this.myEditor.getSelectionModel().getSelectionStart() : this.myEditor.getCaretModel().getOffset();
        return Math.max(offset - this.myMinPrefixLength, 0);
    }

    private void selectMostPreferableItem() {
        List<LookupElement> sortedItems = this.getItems();
        int index = this.doSelectMostPreferableItem(sortedItems);
        this.myList.setSelectedIndex(index);
        if (index >= 0 && index < this.myList.getModel().getSize()) {
            ListScrollingUtil.selectItem((JList)this.myList, (int)index);
        } else if (!sortedItems.isEmpty()) {
            ListScrollingUtil.selectItem((JList)this.myList, (int)0);
        }
    }

    @Override
    @Nullable
    public LookupElement getCurrentItem() {
        LookupElement item = (LookupElement)this.myList.getSelectedValue();
        return item instanceof EmptyLookupItem ? null : item;
    }

    @Override
    public void setCurrentItem(LookupElement item) {
        ListScrollingUtil.selectItem((JList)this.myList, (Object)item);
    }

    @Override
    public void addLookupListener(LookupListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeLookupListener(LookupListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public Rectangle getCurrentItemBounds() {
        int index = this.myList.getSelectedIndex();
        Rectangle itmBounds = this.myList.getCellBounds(index, index);
        if (itmBounds == null) {
            return null;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint(this.myList, itmBounds.x, itmBounds.y, this.getComponent());
        itmBounds.x = layeredPanePoint.x;
        itmBounds.y = layeredPanePoint.y;
        return itmBounds;
    }

    public void fireItemSelected(LookupElement item, char completionChar) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (item != null) {
            this.myArranger.itemSelected(item, this);
        }
        if (!this.myListeners.isEmpty()) {
            LookupListener[] listeners;
            LookupEvent event = new LookupEvent(this, item, completionChar);
            for (LookupListener listener : listeners = this.myListeners.toArray(new LookupListener[this.myListeners.size()])) {
                try {
                    listener.itemSelected(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireLookupCanceled() {
        if (!this.myListeners.isEmpty()) {
            LookupListener[] listeners;
            LookupEvent event = new LookupEvent(this, null);
            for (LookupListener listener : listeners = this.myListeners.toArray(new LookupListener[this.myListeners.size()])) {
                try {
                    listener.lookupCanceled(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireCurrentItemChanged(LookupElement item) {
        if (!this.myListeners.isEmpty()) {
            LookupListener[] listeners;
            LookupEvent event = new LookupEvent(this, item);
            for (LookupListener listener : listeners = this.myListeners.toArray(new LookupListener[this.myListeners.size()])) {
                listener.currentItemChanged(event);
            }
        }
    }

    private static int divideString(String lookupString, PrefixMatcher matcher) {
        for (int i = matcher.getPrefix().length(); i <= lookupString.length(); ++i) {
            if (!matcher.prefixMatches(lookupString.substring(0, i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillInCommonPrefix(boolean explicitlyInvoked) {
        if (explicitlyInvoked && this.myCalculating) {
            return false;
        }
        if (!explicitlyInvoked && this.myDirty) {
            return false;
        }
        ListModel listModel = this.myList.getModel();
        if (listModel.getSize() <= 1) {
            return false;
        }
        if (listModel.getSize() == 0) {
            return false;
        }
        LookupElement firstItem = (LookupElement)listModel.getElementAt(0);
        if (listModel.getSize() == 1 && firstItem instanceof EmptyLookupItem) {
            return false;
        }
        PrefixMatcher firstItemMatcher = firstItem.getPrefixMatcher();
        String oldPrefix = firstItemMatcher.getPrefix();
        String presentPrefix = oldPrefix + this.myAdditionalPrefix;
        PrefixMatcher matcher = firstItemMatcher.cloneWithPrefix(presentPrefix);
        String lookupString = firstItem.getLookupString();
        int div = LookupImpl.divideString(lookupString, matcher);
        if (div < 0) {
            return false;
        }
        String beforeCaret = lookupString.substring(0, div);
        String afterCaret = lookupString.substring(div);
        for (int i = 1; i < listModel.getSize(); ++i) {
            LookupElement item = (LookupElement)listModel.getElementAt(i);
            if (!oldPrefix.equals(item.getPrefixMatcher().getPrefix())) {
                return false;
            }
            lookupString = item.getLookupString();
            div = LookupImpl.divideString(lookupString, item.getPrefixMatcher().cloneWithPrefix(presentPrefix));
            if (div < 0) {
                return false;
            }
            String _afterCaret = lookupString.substring(div);
            if (!(beforeCaret == null || div == beforeCaret.length() && lookupString.startsWith(beforeCaret))) {
                beforeCaret = null;
            }
            while (afterCaret.length() > 0 && !_afterCaret.startsWith(afterCaret)) {
                afterCaret = afterCaret.substring(0, afterCaret.length() - 1);
            }
            if (afterCaret.length() != 0) continue;
            return false;
        }
        this.myInitialPrefix = this.myAdditionalPrefix.length() == 0 && this.myInitialPrefix == null && !explicitlyInvoked ? presentPrefix : null;
        EditorModificationUtil.deleteSelectedText((Editor)this.myEditor);
        int offset = this.myEditor.getCaretModel().getOffset();
        if (beforeCaret != null) {
            int start = offset - presentPrefix.length();
            this.setInitialOffset(offset, offset, offset);
            this.myAdditionalPrefix = "";
            this.myEditor.getDocument().replaceString(start, offset, (CharSequence)beforeCaret);
            presentPrefix = beforeCaret;
        }
        offset = this.myEditor.getCaretModel().getOffset();
        this.myEditor.getDocument().insertString(offset, (CharSequence)afterCaret);
        String newPrefix = presentPrefix + afterCaret;
        ArrayList<LookupElement> arrayList = this.myItems;
        synchronized (arrayList) {
            Iterator<LookupElement> iterator = this.myItems.iterator();
            while (iterator.hasNext()) {
                LookupElement item = iterator.next();
                if (item.setPrefixMatcher(item.getPrefixMatcher().cloneWithPrefix(newPrefix))) continue;
                iterator.remove();
                this.mySortedItems = null;
            }
        }
        this.myAdditionalPrefix = "";
        this.myAdditionalPrefix = "";
        this.updateList();
        this.setInitialOffset(offset += afterCaret.length(), offset, offset);
        this.myEditor.getCaretModel().moveToOffset(offset);
        return true;
    }

    private void setInitialOffset(int offset, int selStart, int selEnd) {
        this.myInitialOffset = this.myEditor.getDocument().createRangeMarker(TextRange.from((int)offset, (int)0));
        this.myInitialSelection = this.myEditor.getDocument().createRangeMarker(new TextRange(selStart, selEnd));
    }

    @Override
    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myEditor.getProject()).getPsiFile(this.myEditor.getDocument());
    }

    @Override
    public boolean isCompletion() {
        return this.myArranger instanceof CompletionLookupArranger;
    }

    @Override
    public PsiElement getPsiElement() {
        PsiFile file = this.getPsiFile();
        if (file == null) {
            return null;
        }
        int offset = this.getLookupStart();
        if (offset > 0) {
            return file.findElementAt(offset - 1);
        }
        return file.findElementAt(0);
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean isPositionedAboveCaret() {
        return this.myPositionedAbove != null && this.myPositionedAbove != false;
    }

    @Override
    public void hide() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myDisposed) {
            return;
        }
        this.doHide(true);
    }

    private void doHide(boolean fireCanceled) {
        assert (!this.myDisposed);
        this.myHidden = true;
        super.hide();
        Disposer.dispose((Disposable)this);
        if (fireCanceled) {
            this.fireLookupCanceled();
        }
    }

    public void restorePrefix() {
        if (this.myInitialPrefix != null) {
            this.myEditor.getDocument().replaceString(this.getLookupStart(), this.myEditor.getCaretModel().getOffset(), (CharSequence)this.myInitialPrefix);
        }
    }

    public void dispose() {
        assert (this.myHidden);
        assert (!this.myDisposed);
        this.myDisposed = true;
        this.myProcessIcon.dispose();
        if (this.myEditorCaretListener != null) {
            this.myEditor.getCaretModel().removeCaretListener(this.myEditorCaretListener);
            this.myEditor.getSelectionModel().removeSelectionListener(this.myEditorSelectionListener);
        }
        if (this.myEditorMouseListener != null) {
            this.myEditor.removeEditorMouseListener(this.myEditorMouseListener);
        }
    }

    private int doSelectMostPreferableItem(List<LookupElement> items) {
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return 0;
        }
        for (int i = 0; i < items.size(); ++i) {
            LookupElement item = items.get(i);
            if (!this.isExactPrefixItem(item)) continue;
            return i;
        }
        int index = this.myArranger.suggestPreselectedItem(items);
        assert (index >= 0 && index < items.size());
        return index;
    }

    public void refreshUi() {
        this.updateList();
        if (this.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myEditor.getComponent().getRootPane() == null) {
                LOG.error("Null root pane");
            }
            Point point = this.calculatePosition();
            Dimension preferredSize = this.getComponent().getPreferredSize();
            this.setBounds(point.x, point.y, preferredSize.width, preferredSize.height);
            HintManagerImpl.adjustEditorHintPosition(this, this.myEditor, point);
        }
    }

    public LookupArranger getLookupModel() {
        return this.myArranger;
    }
}

