/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JavaDocExternalFilter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocExternalFilter");
    private final Project myProject;
    private final PsiManager myManager;
    @NonNls
    protected static final Pattern ourHTMLsuffix = Pattern.compile("[.][hH][tT][mM][lL]?");
    @NonNls
    protected static final Pattern ourParentFolderprefix = Pattern.compile("^[.][.]/");
    @NonNls
    protected static final Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");
    @NonNls
    protected static final Pattern ourHTMLFilesuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    @NonNls
    private static final Pattern ourHREFselector = Pattern.compile("<A.*?HREF=\"([^>\"]*)\"");
    @NonNls
    private static final Pattern ourAnnihilator = Pattern.compile("/[^/^.]*/[.][.]/");
    @NonNls
    private static final Pattern ourIMGselector = Pattern.compile("<IMG[ \\t\\n\\r\\f]+SRC=\"([^>]*)\"");
    @NonNls
    private static final Pattern ourMethodHeading = Pattern.compile("<H3>(.+?)</H3>", 34);
    @NonNls
    protected static final String DOC_ELEMENT_PROTOCOL = "doc_element://";
    @NonNls
    protected static final String PSI_ELEMENT_PROTOCOL = "psi_element://";
    @NonNls
    private static final String JAR_PROTOCOL = "jar:";
    @NonNls
    private static final String DOC_START_MARKER = "Generated by javadoc";
    @NonNls
    private static final String HR = "<HR>";
    @NonNls
    private static final String P = "<P>";
    @NonNls
    private static final String DL = "<DL>";
    @NonNls
    private static final String H2 = "</H2>";
    @NonNls
    protected static final String HTML_CLOSE = "</HTML>";
    @NonNls
    protected static final String HTML = "<HTML>";
    @NonNls
    private static final String BR = "<BR>";
    @NonNls
    private static final String DT = "<DT>";
    protected final RefConvertor myIMGConvertor = new RefConvertor(ourIMGselector){

        @Override
        protected String convertReference(String root, String href) {
            if (StringUtil.startsWithChar((CharSequence)href, (char)'#')) {
                return JavaDocExternalFilter.DOC_ELEMENT_PROTOCOL + root + href;
            }
            return ourHTMLFilesuffix.matcher(root).replaceAll("/") + href;
        }
    };
    private final RefConvertor[] myReferenceConvertors = new RefConvertor[]{new RefConvertor(ourHREFselector){

        @Override
        protected String convertReference(String root, String href) {
            if (BrowserUtil.isAbsoluteURL((String)href)) {
                return href;
            }
            if (StringUtil.startsWithChar((CharSequence)href, (char)'#')) {
                return JavaDocExternalFilter.DOC_ELEMENT_PROTOCOL + root + href;
            }
            String nakedRoot = ourHTMLFilesuffix.matcher(root).replaceAll("/");
            String stripped = ourHTMLsuffix.matcher(href).replaceAll("");
            int len = stripped.length();
            while (len > (len = (stripped = ourParentFolderprefix.matcher(stripped).replaceAll("")).length())) {
            }
            String elementRef = stripped.replaceAll("/", ".");
            String classRef = ourAnchorsuffix.matcher(elementRef).replaceAll("");
            return JavaPsiFacade.getInstance((Project)JavaDocExternalFilter.this.myManager.getProject()).findClass(classRef, GlobalSearchScope.allScope((Project)JavaDocExternalFilter.this.myProject)) != null ? JavaDocExternalFilter.PSI_ELEMENT_PROTOCOL + elementRef : JavaDocExternalFilter.DOC_ELEMENT_PROTOCOL + JavaDocExternalFilter.doAnnihilate(nakedRoot + href);
        }
    }, this.myIMGConvertor};

    public JavaDocExternalFilter(Project project) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
    }

    protected static String doAnnihilate(String path) {
        int len = path.length();
        while (len > (len = (path = ourAnnihilator.matcher(path).replaceAll("/")).length())) {
        }
        return path;
    }

    public static boolean isJavaDocURL(final String url) throws Exception {
        final Waiter waiter = new Waiter(){
            Boolean key = Boolean.FALSE;
            final Object LOCK = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sayYes() {
                this.key = Boolean.TRUE;
                Object object = this.LOCK;
                synchronized (object) {
                    this.LOCK.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean runMe() {
                try {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.LOCK.wait(600L);
                    }
                }
                catch (InterruptedException e) {
                    return false;
                }
                return this.key;
            }
        };
        final boolean[] fail = new boolean[1];
        final Exception[] ex = new Exception[1];
        final HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Reader stream = null;
                try {
                    stream = JavaDocExternalFilter.getReaderByUrl(url, httpConfigurable, ProgressManager.getInstance().getProgressIndicator());
                }
                catch (IOException e) {
                    ex[0] = e;
                }
                if (stream == null) {
                    fail[0] = true;
                    return;
                }
                try {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(stream);
                        for (int lookUp = 6; lookUp > 0; --lookUp) {
                            if (reader.readLine().indexOf(JavaDocExternalFilter.DOC_START_MARKER) == -1) continue;
                            waiter.sayYes();
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Exception e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return !fail[0] && waiter.runMe();
    }

    private String correctRefs(String root, String read) {
        String result = read;
        for (RefConvertor myReferenceConvertor : this.getRefConvertors()) {
            result = myReferenceConvertor.refFilter(root, result);
        }
        return result;
    }

    protected RefConvertor[] getRefConvertors() {
        return this.myReferenceConvertors;
    }

    @Nullable
    public static String filterInternalDocInfo(String text) {
        if (text == null) {
            return null;
        }
        text = JavaDocUtil.fixupText(text);
        return text;
    }

    @Nullable
    private static Reader getReaderByUrl(String surl, HttpConfigurable httpConfigurable, ProgressIndicator pi) throws IOException {
        if (surl.startsWith(JAR_PROTOCOL)) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(BrowserUtil.getDocURL((String)surl));
            if (file == null) {
                return null;
            }
            return new StringReader(VfsUtil.loadText((VirtualFile)file));
        }
        URL url = BrowserUtil.getURL((String)surl);
        httpConfigurable.prepareURL(url.toString());
        URLConnection urlConnection = url.openConnection();
        String contentEncoding = urlConnection.getContentEncoding();
        InputStream inputStream = pi != null ? UrlConnectionUtil.getConnectionInputStreamWithException(urlConnection, pi) : urlConnection.getInputStream();
        return contentEncoding != null ? new InputStreamReader(inputStream, contentEncoding) : new InputStreamReader(inputStream);
    }

    @Nullable
    public String getExternalDocInfo(String surl) throws Exception {
        if (surl == null) {
            return null;
        }
        if (MyJavadocFetcher.isFree()) {
            MyJavadocFetcher fetcher = new MyJavadocFetcher(surl, new MyDocBuilder(){

                @Override
                public void buildFromStream(String surl, Reader input, StringBuffer result) throws IOException {
                    JavaDocExternalFilter.this.doBuildFromStream(surl, input, result);
                }
            });
            Future fetcherFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)fetcher);
            try {
                fetcherFuture.get();
            }
            catch (Exception e) {
                return null;
            }
            Exception exception = fetcher.getException();
            if (exception != null) {
                fetcher.cleanup();
                throw exception;
            }
            String docText = this.correctRefs(ourAnchorsuffix.matcher(surl).replaceAll(""), fetcher.getData());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Filtered JavaDoc: " + docText + "\n");
            }
            return JavaDocUtil.fixupText(docText);
        }
        return null;
    }

    @Nullable
    public String getExternalDocInfoForElement(String docURL, final PsiElement element) throws Exception {
        String externalDoc = this.getExternalDocInfo(docURL);
        if (externalDoc != null && element instanceof PsiMethod) {
            String className = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return ((PsiMethod)element).getContainingClass().getQualifiedName();
                }
            });
            Matcher matcher = ourMethodHeading.matcher(externalDoc);
            StringBuilder buffer = new StringBuilder();
            DocumentationManager.createHyperlink(buffer, className, className, false);
            return matcher.replaceFirst("<H3>" + buffer.toString() + "</H3>");
        }
        return externalDoc;
    }

    protected void doBuildFromStream(String surl, Reader input, StringBuffer data) throws IOException {
        String read;
        BufferedReader buf = new BufferedReader(input);
        Matcher anchorMatcher = ourAnchorsuffix.matcher(surl);
        String startSection = "<!-- ======== START OF CLASS DATA ======== -->";
        String endSection = "SUMMARY ========";
        String greatestEndSection = "<!-- ========= END OF CLASS DATA ========= -->";
        boolean isClassDoc = true;
        if (anchorMatcher.find()) {
            isClassDoc = false;
            startSection = "<A NAME=\"" + anchorMatcher.group(1).toUpperCase() + "\"";
            endSection = "<A NAME=";
        }
        data.append(HTML);
        while ((read = buf.readLine()) != null && read.toUpperCase().indexOf(startSection) == -1) {
        }
        if (read == null) {
            data.delete(0, data.length());
            return;
        }
        JavaDocExternalFilter.appendLine(data, read);
        if (isClassDoc) {
            boolean skip = false;
            while ((read = buf.readLine()) != null && !read.toUpperCase().equals(DL)) {
                if (read.toUpperCase().indexOf(H2) != -1) {
                    data.append(H2);
                    skip = true;
                    continue;
                }
                if (skip) continue;
                JavaDocExternalFilter.appendLine(data, read);
            }
            data.append(DL);
            StringBuffer classDetails = new StringBuffer();
            while ((read = buf.readLine()) != null && !read.toUpperCase().equals(HR) && !read.toUpperCase().equals(P)) {
                JavaDocExternalFilter.appendLine(classDetails, read);
            }
            while ((read = buf.readLine()) != null && !read.toUpperCase().equals(P) && !read.toUpperCase().equals(HR)) {
                JavaDocExternalFilter.appendLine(data, read.replaceAll(DT, "<DT><BR>"));
            }
            data.append(classDetails);
            data.append(P);
        }
        while ((read = buf.readLine()) != null && read.indexOf(endSection) == -1 && read.indexOf(greatestEndSection) == -1) {
            if (read.toUpperCase().indexOf(HR) != -1) continue;
            JavaDocExternalFilter.appendLine(data, read);
        }
        data.append(HTML_CLOSE);
    }

    private static void appendLine(StringBuffer buffer, String read) {
        buffer.append(read);
        buffer.append("\n");
    }

    private static class MyJavadocFetcher
    implements Runnable {
        private static boolean ourFree = true;
        private final StringBuffer data = new StringBuffer();
        private final String surl;
        private final MyDocBuilder myBuilder;
        private final Exception[] myExceptions = new Exception[1];
        private final HttpConfigurable myHttpConfigurable;

        public MyJavadocFetcher(String surl, MyDocBuilder builder) {
            this.surl = surl;
            this.myBuilder = builder;
            ourFree = false;
            this.myHttpConfigurable = HttpConfigurable.getInstance();
        }

        public static boolean isFree() {
            return ourFree;
        }

        public String getData() {
            return this.data.toString();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Exception getException() {
            return this.myExceptions[0];
        }

        public void cleanup() {
            this.myExceptions[0] = null;
        }
    }

    private static interface MyDocBuilder {
        public void buildFromStream(String var1, Reader var2, StringBuffer var3) throws IOException;
    }

    private static interface Waiter {
        public void sayYes();

        public boolean runMe();
    }

    protected static abstract class RefConvertor {
        private final Pattern mySelector;

        public RefConvertor(Pattern selector) {
            this.mySelector = selector;
        }

        protected abstract String convertReference(String var1, String var2);

        public String refFilter(final String root, String read) {
            String toMatch = read.toUpperCase();
            StringBuffer ready = new StringBuffer();
            int prev = 0;
            Matcher matcher = this.mySelector.matcher(toMatch);
            while (matcher.find()) {
                String before = read.substring(prev, matcher.start(1) - 1);
                final String href = read.substring(matcher.start(1), matcher.end(1));
                prev = matcher.end(1) + 1;
                ready.append(before);
                ready.append("\"");
                ready.append((String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return RefConvertor.this.convertReference(root, href);
                    }
                }));
                ready.append("\"");
            }
            ready.append(read.substring(prev, read.length()));
            return ready.toString();
        }
    }
}

