/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertAbsolutePathToRelativeIntentionAction
extends PsiElementBaseIntentionAction {
    protected boolean isConvertToRelative() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        FileReference fileReference;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        PsiReference reference = containingFile.findReferenceAt(editor.getCaretModel().getOffset());
        FileReference fileReference2 = fileReference = reference == null ? null : ConvertAbsolutePathToRelativeIntentionAction.findFileReference(reference);
        if (fileReference != null) {
            FileReferenceSet set = fileReference.getFileReferenceSet();
            FileReference lastReference = set.getLastReference();
            return set.couldBeConvertedTo(this.isConvertToRelative()) && lastReference != null && (!this.isConvertToRelative() && !set.isAbsolutePathReference() || this.isConvertToRelative() && set.isAbsolutePathReference()) && lastReference.resolve() != null;
        }
        return false;
    }

    @Nullable
    private static FileReference findFileReference(@NotNull PsiReference original) {
        FileReference fileReference;
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction.findFileReference must not be null");
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference)) continue;
                return (FileReference)reference;
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)original).getLastFileReference()) != null) {
            return fileReference;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Convert " + (this.isConvertToRelative() ? "absolute" : "relative") + " path to " + (this.isConvertToRelative() ? "relative" : "absolute");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction.getFamilyName must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        FileReference lastReference;
        FileReference fileReference;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction.invoke must not be null");
        }
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        FileReference fileReference2 = fileReference = reference == null ? null : ConvertAbsolutePathToRelativeIntentionAction.findFileReference(reference);
        if (fileReference != null && (lastReference = fileReference.getFileReferenceSet().getLastReference()) != null) {
            lastReference.bindToElement((PsiElement)lastReference.resolve(), !this.isConvertToRelative());
        }
    }

    @NotNull
    public String getText() {
        String string = "Convert path to " + (this.isConvertToRelative() ? "relative" : "absolute");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction.getText must not return null");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

