/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;

public class JavaImplementMethodsHandler
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(file.getProject(), editor, file, false);
        return aClass != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/JavaImplementMethodsHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/JavaImplementMethodsHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/JavaImplementMethodsHandler.invoke must not be null");
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(project, editor, file, false);
        if (aClass == null) {
            return;
        }
        if (OverrideImplementUtil.getMethodSignaturesToImplement(aClass).isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No methods to implement have been found");
            return;
        }
        OverrideImplementUtil.chooseAndImplementMethods(project, editor, aClass);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

