/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.editorActions.smartEnter.AfterSemicolonEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.BlockBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.BreakingControlFlowEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.CatchDeclarationFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CommentBreakerEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.DoWhileConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.EnumFieldFixer;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.IfConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.LiteralFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MethodCallFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayInitializerBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingCatchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingForBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingForeachBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingIfBranchesFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingReturnExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSwitchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSynchronizedBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingThrowExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingWhileBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParameterListFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParenthesizedFixer;
import com.intellij.codeInsight.editorActions.smartEnter.PlainEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SemicolonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SwitchExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.WhileConditionFixer;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor");
    private static final Fixer[] ourFixers;
    private static final EnterProcessor[] ourEnterProcessors;
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.process must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.process must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.process must not be null");
        }
        Document document = editor.getDocument();
        String textForRollback = document.getText();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor, psiFile, 0);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), (CharSequence)textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int attempt) throws TooManyAttemptsException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.process must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.process must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.process must not be null");
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file);
            if (atCaret == null) {
                if (!new CommentBreakerEnterProcessor().doEnter(editor, (PsiElement)file, false)) {
                    JavaSmartEnterProcessor.plainEnter(editor);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            JavaSmartEnterProcessor.collectAllElements(atCaret, queue, true);
            queue.add(atCaret);
            for (PsiElement psiElement : queue) {
                for (Fixer fixer : ourFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance(project).getActiveLookup() != null) {
                        return;
                    }
                    if (!JavaSmartEnterProcessor.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file);
                    this.process(project, editor, file, attempt + 1);
                    return;
                }
            }
            this.doEnter(atCaret, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        PsiElement parent = atCaret.getParent();
        if (parent instanceof PsiCodeBlock) {
            PsiCodeBlock block = (PsiCodeBlock)parent;
            if (block.getStatements().length > 0 && block.getStatements()[0] == atCaret) {
                atCaret = block;
            }
        } else if (parent instanceof PsiForStatement) {
            atCaret = parent;
        }
        super.reformat(atCaret);
    }

    private void doEnter(PsiElement atCaret, Editor editor) throws IncorrectOperationException {
        PsiFile psiFile = atCaret.getContainingFile();
        RangeMarker rangeMarker = this.createRangeMarker((PsiElement)atCaret);
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat((PsiElement)atCaret);
            return;
        }
        this.reformat((PsiElement)atCaret);
        this.commit(editor);
        atCaret = CodeInsightUtil.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), atCaret.getClass());
        for (EnterProcessor processor : ourEnterProcessors) {
            if (atCaret == null) break;
            if (!processor.doEnter(editor, (PsiElement)atCaret, JavaSmartEnterProcessor.isModified(editor))) continue;
            return;
        }
        if (!JavaSmartEnterProcessor.isModified(editor)) {
            JavaSmartEnterProcessor.plainEnter(editor);
        } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(rangeMarker.getEndOffset());
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
        }
    }

    private static void collectAllElements(PsiElement atCaret, List<PsiElement> res, boolean recurse) {
        PsiElement[] children;
        res.add(0, atCaret);
        if (JavaSmartEnterProcessor.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        for (PsiElement child : children = atCaret.getChildren()) {
            if (atCaret instanceof PsiStatement && child instanceof PsiStatement) continue;
            JavaSmartEnterProcessor.collectAllElements(child, res, recurse);
        }
    }

    private static boolean doNotStepInto(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiCodeBlock || element instanceof PsiStatement || element instanceof PsiMethod;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        if (atCaret instanceof PsiJavaToken && "}".equals(atCaret.getText()) && !(atCaret.getParent() instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        PsiElement statementAtCaret = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMember.class, PsiComment.class, PsiImportStatementBase.class});
        if (statementAtCaret instanceof PsiBlockStatement) {
            return null;
        }
        if (statementAtCaret != null && statementAtCaret.getParent() instanceof PsiForStatement && !PsiTreeUtil.hasErrorElements((PsiElement)statementAtCaret)) {
            statementAtCaret = statementAtCaret.getParent();
        }
        return statementAtCaret instanceof PsiStatement || statementAtCaret instanceof PsiMember || statementAtCaret instanceof PsiImportStatementBase ? statementAtCaret : null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.moveCaretInsideBracesIfAny must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.moveCaretInsideBracesIfAny must not be null");
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement elt = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(caretOffset - 1), PsiCodeBlock.class);
            this.reformat(elt);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.plainEnter must not be null");
        }
        JavaSmartEnterProcessor.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/smartEnter/JavaSmartEnterProcessor.isModified must not be null");
        }
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    static {
        ArrayList<Fixer> fixers = new ArrayList<Fixer>();
        fixers.add(new LiteralFixer());
        fixers.add(new MethodCallFixer());
        fixers.add(new IfConditionFixer());
        fixers.add(new WhileConditionFixer());
        fixers.add(new CatchDeclarationFixer());
        fixers.add(new SwitchExpressionFixer());
        fixers.add(new DoWhileConditionFixer());
        fixers.add(new BlockBraceFixer());
        fixers.add(new MissingIfBranchesFixer());
        fixers.add(new MissingWhileBodyFixer());
        fixers.add(new MissingSwitchBodyFixer());
        fixers.add(new MissingCatchBodyFixer());
        fixers.add(new MissingSynchronizedBodyFixer());
        fixers.add(new MissingForBodyFixer());
        fixers.add(new MissingForeachBodyFixer());
        fixers.add(new ParameterListFixer());
        fixers.add(new MissingMethodBodyFixer());
        fixers.add(new MissingReturnExpressionFixer());
        fixers.add(new MissingThrowExpressionFixer());
        fixers.add(new ParenthesizedFixer());
        fixers.add(new SemicolonFixer());
        fixers.add(new MissingArrayInitializerBraceFixer());
        fixers.add(new EnumFieldFixer());
        ourFixers = fixers.toArray(new Fixer[fixers.size()]);
        ArrayList<EnterProcessor> processors = new ArrayList<EnterProcessor>();
        processors.add(new CommentBreakerEnterProcessor());
        processors.add(new AfterSemicolonEnterProcessor());
        processors.add(new BreakingControlFlowEnterProcessor());
        processors.add(new PlainEnterProcessor());
        ourEnterProcessors = processors.toArray(new EnterProcessor[processors.size()]);
        SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

