/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanExpressionFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpression");
    private final PsiExpression mySubExpression;
    private final Boolean mySubExpressionValue;

    public SimplifyBooleanExpressionFix(PsiExpression subExpression, Boolean subExpressionValue) {
        this.mySubExpression = subExpression;
        this.mySubExpressionValue = subExpressionValue;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("simplify.boolean.expression.text", this.mySubExpression.getText(), this.mySubExpressionValue);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("simplify.boolean.expression.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix.isAvailable must not be null");
        }
        return this.mySubExpression.isValid() && this.mySubExpression.getManager().isInProject((PsiElement)this.mySubExpression) && !PsiUtil.isAccessedForWriting((PsiExpression)this.mySubExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiExpression expression;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix.invoke must not be null");
        }
        if (!this.isAvailable(project, editor, file)) {
            return;
        }
        LOG.assertTrue(this.mySubExpression.isValid());
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.mySubExpression)) {
            return;
        }
        if (this.mySubExpressionValue == null) {
            expression = this.mySubExpression;
        } else {
            PsiExpression constExpression = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(Boolean.toString(this.mySubExpressionValue), (PsiElement)this.mySubExpression);
            expression = (PsiExpression)this.mySubExpression.replace((PsiElement)constExpression);
        }
        while (expression.getParent() instanceof PsiExpression) {
            expression = (PsiExpression)expression.getParent();
        }
        SimplifyBooleanExpressionFix.simplifyExpression(expression);
    }

    public static void simplifyIfStatement(PsiExpression expression) throws IncorrectOperationException {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiIfStatement) || ((PsiIfStatement)parent).getCondition() != expression) {
            return;
        }
        if (!(expression instanceof PsiLiteralExpression) || expression.getType() != PsiType.BOOLEAN) {
            return;
        }
        boolean condition = Boolean.parseBoolean(expression.getText());
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (condition) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, ifStatement.getThenBranch());
        } else {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ifStatement.delete();
            } else {
                SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, elseBranch);
            }
        }
    }

    private static void replaceWithStatements(PsiStatement orig, PsiStatement statement) throws IncorrectOperationException {
        if (statement == null) {
            orig.delete();
            return;
        }
        PsiElement parent = orig.getParent();
        if (parent == null) {
            return;
        }
        if (statement instanceof PsiBlockStatement && parent instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            PsiJavaToken lBrace = codeBlock.getLBrace();
            PsiJavaToken rBrace = codeBlock.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                PsiElement added = parent.addRangeBefore(children[1], children[children.length - 2], (PsiElement)orig);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((PsiManager)orig.getManager());
                codeStyleManager.reformat(added);
            }
            orig.delete();
        } else {
            orig.replace((PsiElement)statement);
        }
    }

    public static void simplifyExpression(PsiExpression expression) throws IncorrectOperationException {
        final PsiExpression[] result = new PsiExpression[]{(PsiExpression)expression.copy()};
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression.getManager(), true);
        final IncorrectOperationException[] exception = new IncorrectOperationException[]{null};
        result[0].accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement[] children;
                for (PsiElement child : children = element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                expressionVisitor.clear();
                expression.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.resultExpression != null) {
                    LOG.assertTrue(expressionVisitor.resultExpression.isValid());
                    try {
                        if (expression != result[0]) {
                            expression.replace((PsiElement)expressionVisitor.resultExpression);
                        } else {
                            result[0] = expressionVisitor.resultExpression;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        exception[0] = e;
                    }
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        PsiExpression newExpression = (PsiExpression)expression.replace((PsiElement)result[0]);
        SimplifyBooleanExpressionFix.simplifyIfStatement(newExpression);
    }

    public static boolean canBeSimplified(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix.canBeSimplified must not be null");
        }
        if (!(expression instanceof PsiConditionalExpression) && expression.getType() != PsiType.BOOLEAN) {
            return false;
        }
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression.getManager(), false);
        final Ref canBeSimplified = new Ref((Object)Boolean.FALSE);
        expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)canBeSimplified.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                expressionVisitor.clear();
                expression.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.canBeSimplifiedFlag) {
                    canBeSimplified.set((Object)Boolean.TRUE);
                }
            }
        });
        return (Boolean)canBeSimplified.get();
    }

    public static Boolean getConstBoolean(PsiExpression operand) {
        if (operand == null) {
            return null;
        }
        if ((operand = PsiUtil.deparenthesizeExpression((PsiExpression)operand)) == null) {
            return null;
        }
        String text = operand.getText();
        return "true".equals(text) ? Boolean.TRUE : ("false".equals(text) ? Boolean.FALSE : null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static class ExpressionVisitor
    extends JavaElementVisitor {
        private PsiExpression resultExpression;
        private final PsiExpression trueExpression;
        private final PsiExpression falseExpression;
        private final boolean isCreateResult;
        boolean canBeSimplifiedFlag;

        private ExpressionVisitor(PsiManager psiManager, boolean createResult) {
            this.isCreateResult = createResult;
            this.trueExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(true)) : null;
            this.falseExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(false)) : null;
        }

        private static PsiExpression createExpression(PsiManager psiManager, @NonNls String text) {
            try {
                return JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createExpressionFromText(text, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private boolean markAndCheckCreateResult() {
            this.canBeSimplifiedFlag = true;
            return this.isCreateResult;
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiExpression lOperand = expression.getLOperand();
            PsiExpression rOperand = expression.getROperand();
            PsiJavaToken operationSign = expression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            Boolean lConstBoolean = SimplifyBooleanExpressionFix.getConstBoolean(lOperand);
            Boolean rConstBoolean = SimplifyBooleanExpressionFix.getConstBoolean(rOperand);
            if (lConstBoolean != null) {
                this.simplifyBinary(tokenType, lConstBoolean, rOperand);
            } else if (rConstBoolean != null) {
                this.simplifyBinary(tokenType, rConstBoolean, lOperand);
            }
        }

        private void simplifyBinary(IElementType tokenType, Boolean lConstBoolean, PsiExpression rOperand) {
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            if (JavaTokenType.ANDAND == tokenType || JavaTokenType.AND == tokenType) {
                this.resultExpression = lConstBoolean != false ? rOperand : this.falseExpression;
            } else if (JavaTokenType.OROR == tokenType || JavaTokenType.OR == tokenType) {
                this.resultExpression = lConstBoolean != false ? this.trueExpression : rOperand;
            } else if (JavaTokenType.EQEQ == tokenType) {
                this.simplifyEquation(lConstBoolean, rOperand);
            } else if (JavaTokenType.NE == tokenType) {
                PsiPrefixExpression negatedExpression = ExpressionVisitor.createNegatedExpression(rOperand);
                this.resultExpression = negatedExpression;
                this.visitPrefixExpression(negatedExpression);
                this.simplifyEquation(lConstBoolean, this.resultExpression);
            }
        }

        private void simplifyEquation(Boolean constBoolean, PsiExpression otherOperand) {
            if (constBoolean.booleanValue()) {
                this.resultExpression = otherOperand;
            } else {
                PsiPrefixExpression negated = ExpressionVisitor.createNegatedExpression(otherOperand);
                this.resultExpression = negated;
                this.visitPrefixExpression(negated);
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            Boolean condition = SimplifyBooleanExpressionFix.getConstBoolean(expression.getCondition());
            if (condition == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = condition != false ? expression.getThenExpression() : expression.getElseExpression();
        }

        private static PsiPrefixExpression createNegatedExpression(PsiExpression otherOperand) {
            PsiPrefixExpression expression = (PsiPrefixExpression)ExpressionVisitor.createExpression(otherOperand.getManager(), "!(xxx)");
            try {
                expression.getOperand().replace((PsiElement)otherOperand);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return expression;
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiExpression operand = expression.getOperand();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand);
            if (constBoolean == null) {
                return;
            }
            PsiJavaToken operationSign = expression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            if (JavaTokenType.EXCL == tokenType) {
                if (!this.markAndCheckCreateResult()) {
                    return;
                }
                this.resultExpression = constBoolean != false ? this.falseExpression : this.trueExpression;
            }
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiExpression subexpr = expression.getExpression();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(subexpr);
            if (constBoolean == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = constBoolean != false ? this.trueExpression : this.falseExpression;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void clear() {
            this.resultExpression = null;
        }
    }
}

