/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class NegationBroadScopeFix
implements IntentionAction {
    private final PsiPrefixExpression myPrefixExpression;

    public NegationBroadScopeFix(PsiPrefixExpression prefixExpression) {
        this.myPrefixExpression = prefixExpression;
    }

    @NotNull
    public String getText() {
        PsiExpression rOperand;
        PsiTypeElement type;
        String text = this.myPrefixExpression.getOperand().getText();
        text = text + " ";
        PsiElement parent = this.myPrefixExpression.getParent();
        String operation = parent instanceof PsiInstanceOfExpression ? "instanceof" : ((PsiBinaryExpression)parent).getOperationSign().getText();
        text = text + operation + " ";
        String rop = parent instanceof PsiInstanceOfExpression ? ((type = ((PsiInstanceOfExpression)parent).getCheckType()) == null ? "" : type.getText()) : ((rOperand = ((PsiBinaryExpression)parent).getROperand()) == null ? "" : rOperand.getText());
        text = text + rop;
        String string = QuickFixBundle.message("negation.broader.scope.text", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("negation.broader.scope.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix.isAvailable must not be null");
        }
        if (this.myPrefixExpression == null || !this.myPrefixExpression.isValid()) {
            return false;
        }
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent).getOperand() == this.myPrefixExpression) {
            return true;
        }
        if (!(parent instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
        return binaryExpression.getLOperand() == this.myPrefixExpression && TypeConversionUtil.isBooleanType((PsiType)binaryExpression.getType());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.myPrefixExpression)) {
            return;
        }
        PsiExpression operand = this.myPrefixExpression.getOperand();
        PsiElement unnegated = this.myPrefixExpression.replace((PsiElement)operand);
        PsiElement parent = unnegated.getParent();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
        PsiPrefixExpression negated = (PsiPrefixExpression)factory.createExpressionFromText("!(xxx)", parent);
        PsiParenthesizedExpression parentheses = (PsiParenthesizedExpression)negated.getOperand();
        parentheses.getExpression().replace(parent.copy());
        parent.replace((PsiElement)negated);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

