/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddVariableInitializerFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiVariable myVariable;

    public AddVariableInitializerFix(PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.text", (Object[])new Object[]{this.myVariable.getName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"quickfix.add.variable.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix.isAvailable must not be null");
        }
        return this.myVariable != null && this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable) && !this.myVariable.hasInitializer();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddVariableInitializerFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        String initializerText = this.suggestInitializer();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myVariable.getProject()).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(initializerText, (PsiElement)this.myVariable);
        if (this.myVariable instanceof PsiLocalVariable) {
            ((PsiLocalVariable)this.myVariable).setInitializer(initializer);
        } else if (this.myVariable instanceof PsiField) {
            ((PsiField)this.myVariable).setInitializer(initializer);
        } else {
            LOG.error("Unknown variable type: " + this.myVariable);
        }
        PsiVariable var = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(this.myVariable);
        TextRange range = var.getInitializer().getTextRange();
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
    }

    private String suggestInitializer() {
        PsiType type = this.myVariable.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

