/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class RefCountHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.RefCountHolder");
    private final PsiFile myFile;
    private final BidirectionalMap<PsiReference, PsiElement> myLocalRefsMap;
    private final Map<PsiNamedElement, Boolean> myDclsUsedMap;
    private final Map<PsiReference, PsiImportStatementBase> myImportStatements;
    private final Map<PsiElement, Boolean> myPossiblyDuplicateElements;
    private final AtomicReference<State> myState;
    private static final Key<RefCountHolder> REF_COUNT_HOLDER_IN_FILE_KEY = Key.create((String)"REF_COUNT_HOLDER_IN_FILE_KEY");

    public static RefCountHolder getInstance(PsiFile file) {
        RefCountHolder refCountHolder = (RefCountHolder)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
        if (refCountHolder == null) {
            refCountHolder = (RefCountHolder)((UserDataHolderEx)file).putUserDataIfAbsent(REF_COUNT_HOLDER_IN_FILE_KEY, (Object)new RefCountHolder(file));
        }
        return refCountHolder;
    }

    private RefCountHolder(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/RefCountHolder.<init> must not be null");
        }
        this.myLocalRefsMap = new BidirectionalMap();
        this.myDclsUsedMap = new ConcurrentHashMap();
        this.myImportStatements = new ConcurrentHashMap();
        this.myPossiblyDuplicateElements = new ConcurrentHashMap();
        this.myState = new AtomicReference<State>(State.VIRGIN);
        this.myFile = file;
        LOG.debug("RefCountHolder created for '" + StringUtil.first((String)file.getText(), (int)30, (boolean)true));
    }

    private void clear() {
        this.assertIsAnalyzing();
        this.myLocalRefsMap.clear();
        this.myImportStatements.clear();
        this.myDclsUsedMap.clear();
        this.myPossiblyDuplicateElements.clear();
    }

    public void registerLocallyReferenced(@NotNull PsiNamedElement result) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/RefCountHolder.registerLocallyReferenced must not be null");
        }
        this.assertIsAnalyzing();
        this.myDclsUsedMap.put(result, Boolean.TRUE);
    }

    public void registerReference(@NotNull PsiJavaReference ref, JavaResolveResult resolveResult) {
        PsiElement resolveScope;
        PsiFile psiFile;
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/RefCountHolder.registerReference must not be null");
        }
        this.assertIsAnalyzing();
        PsiElement refElement = resolveResult.getElement();
        PsiFile psiFile2 = psiFile = refElement == null ? null : refElement.getContainingFile();
        if (psiFile != null) {
            psiFile = (PsiFile)psiFile.getNavigationElement();
        }
        if (refElement != null && psiFile != null && this.myFile.getViewProvider().equals(psiFile.getViewProvider())) {
            this.registerLocalRef((PsiReference)ref, refElement.getNavigationElement());
        }
        if ((resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
            this.registerImportStatement((PsiReference)ref, (PsiImportStatementBase)resolveScope);
        }
    }

    private void registerImportStatement(@NotNull PsiReference ref, PsiImportStatementBase importStatement) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/RefCountHolder.registerImportStatement must not be null");
        }
        this.myImportStatements.put(ref, importStatement);
    }

    public boolean isRedundant(PsiImportStatementBase importStatement) {
        this.assertIsRetrieving();
        return !this.myImportStatements.containsValue(importStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalRef(@NotNull PsiReference ref, PsiElement refElement) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/RefCountHolder.registerLocalRef must not be null");
        }
        if (refElement instanceof PsiMethod && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)ref.getElement(), (boolean)true)) {
            return;
        }
        if (refElement instanceof PsiClass && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)ref.getElement(), (boolean)true)) {
            return;
        }
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            this.myLocalRefsMap.put((Object)ref, (Object)refElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidRefs() {
        this.assertIsAnalyzing();
        BidirectionalMap<PsiReference, PsiElement> bidirectionalMap = this.myLocalRefsMap;
        synchronized (bidirectionalMap) {
            Iterator iterator = this.myLocalRefsMap.keySet().iterator();
            while (iterator.hasNext()) {
                PsiReference ref = (PsiReference)iterator.next();
                if (ref.getElement().isValid()) continue;
                PsiElement value = (PsiElement)this.myLocalRefsMap.get((Object)ref);
                iterator.remove();
                List array = this.myLocalRefsMap.getKeysByValue((Object)value);
                LOG.assertTrue(array != null);
                array.remove(ref);
            }
        }
        Iterator<PsiReference> iterator = this.myImportStatements.keySet().iterator();
        while (iterator.hasNext()) {
            PsiReference ref = iterator.next();
            if (ref.getElement().isValid()) continue;
            iterator.remove();
        }
        RefCountHolder.removeInvalidFrom(this.myDclsUsedMap.keySet());
        RefCountHolder.removeInvalidFrom(this.myPossiblyDuplicateElements.keySet());
    }

    private static void removeInvalidFrom(Iterable<? extends PsiElement> collection) {
        Iterator<? extends PsiElement> it = collection.iterator();
        while (it.hasNext()) {
            PsiElement element = it.next();
            if (element.isValid()) continue;
            it.remove();
        }
    }

    public boolean isReferenced(PsiNamedElement element) {
        this.assertIsRetrieving();
        List array = this.myLocalRefsMap.getKeysByValue((Object)element);
        if (array != null && !array.isEmpty() && !RefCountHolder.isParameterUsedRecursively((PsiElement)element, array)) {
            return true;
        }
        Boolean usedStatus = this.myDclsUsedMap.get(element);
        return usedStatus == Boolean.TRUE;
    }

    private static boolean isParameterUsedRecursively(PsiElement element, List<PsiReference> array) {
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter = (PsiParameter)element;
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        int paramIndex = ArrayUtil.find((Object[])method.getParameterList().getParameters(), (Object)parameter);
        for (PsiReference reference : array) {
            if (!(reference instanceof PsiElement)) {
                return false;
            }
            PsiElement argument = (PsiElement)reference;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)new PsiMatcherImpl(argument).dot(PsiMatchers.hasClass(PsiReferenceExpression.class)).parent(PsiMatchers.hasClass(PsiExpressionList.class)).parent(PsiMatchers.hasClass(PsiMethodCallExpression.class)).getElement();
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (method != methodExpression.resolve()) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            int argumentIndex = ArrayUtil.find((Object[])arguments, (Object)argument);
            if (paramIndex == argumentIndex) continue;
            return false;
        }
        return true;
    }

    public boolean isReferencedForRead(PsiElement element) {
        this.assertIsRetrieving();
        LOG.assertTrue(element instanceof PsiVariable);
        List array = this.myLocalRefsMap.getKeysByValue((Object)element);
        if (array == null) {
            return false;
        }
        for (PsiReference ref : array) {
            PsiElement refElement = ref.getElement();
            if (!(refElement instanceof PsiExpression)) {
                return true;
            }
            if (!PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)refElement)) || refElement.getParent() instanceof PsiExpression && refElement.getParent().getParent() instanceof PsiExpressionStatement && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) continue;
            return true;
        }
        return false;
    }

    public boolean isReferencedForWrite(PsiElement element) {
        this.assertIsRetrieving();
        LOG.assertTrue(element instanceof PsiVariable);
        List array = this.myLocalRefsMap.getKeysByValue((Object)element);
        if (array == null) {
            return false;
        }
        for (PsiReference ref : array) {
            PsiElement refElement = ref.getElement();
            if (!(refElement instanceof PsiExpression)) {
                return true;
            }
            if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(Runnable analyze, TextRange dirtyScope, PsiFile file) {
        this.myState.compareAndSet(State.READY, State.VIRGIN);
        if (!this.myState.compareAndSet(State.VIRGIN, State.BEING_WRITTEN_BY_GHP)) {
            return false;
        }
        try {
            if (dirtyScope != null) {
                if (dirtyScope.equals((Object)file.getTextRange())) {
                    this.clear();
                } else {
                    this.removeInvalidRefs();
                }
            }
            analyze.run();
        }
        finally {
            boolean set = this.myState.compareAndSet(State.BEING_WRITTEN_BY_GHP, State.READY);
            assert (set) : this.myState.get();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieveUnusedReferencesInfo(Runnable analyze) {
        if (!this.myState.compareAndSet(State.READY, State.BEING_USED_BY_PHP)) {
            return false;
        }
        try {
            analyze.run();
        }
        finally {
            boolean set = this.myState.compareAndSet(State.BEING_USED_BY_PHP, State.READY);
            assert (set) : this.myState.get();
        }
        return true;
    }

    private void assertIsAnalyzing() {
        assert (this.myState.get() == State.BEING_WRITTEN_BY_GHP) : this.myState.get();
    }

    private void assertIsRetrieving() {
        assert (this.myState.get() == State.BEING_USED_BY_PHP) : this.myState.get();
    }

    private static enum State {
        VIRGIN,
        BEING_WRITTEN_BY_GHP,
        READY,
        BEING_USED_BY_PHP;

    }
}

