/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.DummyIdentifierPatcher;
import com.intellij.codeInsight.completion.ExpectedTypeBasedCompletionProvider;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.SameSignatureCallParametersProvider;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.GeneratorFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.getters.CastTypeGetter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.filters.getters.InstanceOfLeftPartTypeGetter;
import com.intellij.psi.filters.getters.ThrowsListGetter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.filters.types.AssignableGroupFilter;
import com.intellij.psi.filters.types.AssignableToFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionCache;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSmartCompletionContributor
extends CompletionContributor {
    private static final TObjectHashingStrategy<ExpectedTypeInfo> EXPECTED_TYPE_INFO_STRATEGY = new TObjectHashingStrategy<ExpectedTypeInfo>(){

        public int computeHashCode(ExpectedTypeInfo object) {
            return object.getType().hashCode();
        }

        public boolean equals(ExpectedTypeInfo o1, ExpectedTypeInfo o2) {
            return o1.getType().equals(o2.getType());
        }
    };
    private static final ElementExtractorFilter THROWABLES_FILTER = new ElementExtractorFilter(new AssignableFromFilter("java.lang.Throwable"));
    @NonNls
    private static final String EXCEPTION_TAG = "exception";
    static final ElementPattern<PsiElement> AFTER_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("new")).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("throw"))));
    static final ElementPattern<PsiElement> AFTER_THROW_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("new")).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("throw")));
    private static final OrFilter THROWABLE_TYPE_FILTER = new OrFilter(new GeneratorFilter(AssignableGroupFilter.class, new ThrowsListGetter()), new AssignableFromFilter("java.lang.RuntimeException"));
    public static final ElementPattern<PsiElement> INSIDE_EXPRESSION = StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(PsiExpression.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(PsiLiteralExpression.class)), PlatformPatterns.psiElement().inside(PsiClassObjectAccessExpression.class), PlatformPatterns.psiElement().inside(PsiThisExpression.class), PlatformPatterns.psiElement().inside(PsiSuperExpression.class)});
    static final ElementPattern<PsiElement> INSIDE_TYPECAST_EXPRESSION = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(")")).withParent(PsiTypeCastExpression.class)));

    @Nullable
    private static ElementFilter getReferenceFilter(PsiElement element) {
        if (AFTER_THROW_NEW.accepts((Object)element)) {
            return new ElementExtractorFilter(THROWABLE_TYPE_FILTER);
        }
        if (((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("."))).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PsiNewExpression.class))).accepts((Object)element) && ((PsiNewExpression)element.getParent().getParent()).getClassReference() == element.getParent()) {
            return new GeneratorFilter(AssignableGroupFilter.class, new ExpectedTypesGetter());
        }
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiReferenceList.class).save("refList")).withParent((ElementPattern)PsiJavaPatterns.psiMethod().withThrowsList(StandardPatterns.get((String)"refList"))))).accepts((Object)element)) {
            return THROWABLES_FILTER;
        }
        return null;
    }

    public JavaSmartCompletionContributor() {
        this.extend(CompletionType.SMART, (ElementPattern)SmartCastProvider.INSIDE_TYPECAST_TYPE, new SmartCastProvider());
        this.extend(CompletionType.SMART, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().beforeLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JavaTokenType.RPARENTH))).afterLeaf(new String[]{"("})).withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiExpressionList.class).withParent(PsiMethodCallExpression.class))), new SameSignatureCallParametersProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"instanceof"}), (CompletionProvider)new CompletionProvider<CompletionParameters>(false){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$2.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$2.addCompletions must not be null");
                }
                final PsiElement position = parameters.getPosition();
                PsiType[] leftTypes = (PsiType[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiType[]>(){

                    public PsiType[] compute() {
                        return InstanceOfLeftPartTypeGetter.getLeftTypes(position);
                    }
                });
                final LinkedHashSet<PsiClassType> expectedClassTypes = new LinkedHashSet<PsiClassType>();
                THashSet parameterizedTypes = new THashSet();
                for (PsiType type : leftTypes) {
                    if (!(type instanceof PsiClassType)) continue;
                    PsiClassType classType = (PsiClassType)type;
                    if (!classType.isRaw()) {
                        ContainerUtil.addIfNotNull((Object)classType.resolve(), (Collection)parameterizedTypes);
                    }
                    expectedClassTypes.add(classType.rawType());
                }
                JavaSmartCompletionContributor.processInheritors(parameters, position, position.getContainingFile(), expectedClassTypes, new Consumer<PsiType>((Set)parameterizedTypes){
                    final /* synthetic */ Set val$parameterizedTypes;
                    {
                        this.val$parameterizedTypes = set2;
                    }

                    public void consume(PsiType type) {
                        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                        if (psiClass == null) {
                            return;
                        }
                        if (expectedClassTypes.contains(type)) {
                            return;
                        }
                        result.addElement(JavaSmartCompletionContributor.createInstanceofLookupElement(psiClass, this.val$parameterizedTypes));
                    }
                }, result.getPrefixMatcher());
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                block7: {
                    PsiReference reference;
                    PsiElement element;
                    block8: {
                        if (parameters == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$3.addCompletions must not be null");
                        }
                        if (result == null) {
                            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$3.addCompletions must not be null");
                        }
                        element = parameters.getPosition();
                        reference = element.getContainingFile().findReferenceAt(parameters.getOffset());
                        if (reference == null) break block7;
                        ElementFilter filter = JavaSmartCompletionContributor.getReferenceFilter(element);
                        if (filter == null) break block8;
                        List<ExpectedTypeInfo> infos = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes(parameters));
                        for (LookupElement item : JavaSmartCompletionContributor.completeReference(element, reference, filter, true, parameters)) {
                            if (AFTER_THROW_NEW.accepts((Object)element)) {
                                ((LookupItem)item).setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, "");
                                if (item.getObject() instanceof PsiClass) {
                                    JavaCompletionUtil.setShowFQN((LookupItem)item);
                                }
                            } else {
                                ((LookupItem)item).setAttribute(LookupItem.NEW_OBJECT_ATTR, "");
                            }
                            result.addElement((LookupElement)JavaSmartCompletionContributor.decorate(item, infos));
                        }
                        break block7;
                    }
                    if (!INSIDE_TYPECAST_EXPRESSION.accepts((Object)element)) break block7;
                    for (LookupElement item : JavaSmartCompletionContributor.completeReference(element, reference, new GeneratorFilter(AssignableToFilter.class, new CastTypeGetter()), false, parameters)) {
                        result.addElement(item);
                    }
                }
            }
        });
        this.extend(CompletionType.SMART, INSIDE_EXPRESSION, new ExpectedTypeBasedCompletionProvider(){

            @Override
            protected void addCompletions(CompletionParameters params, final CompletionResultSet result, final Collection<ExpectedTypeInfo> _infos) {
                Set infos = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<ExpectedTypeInfo>>(){

                    public Set<ExpectedTypeInfo> compute() {
                        return new THashSet(_infos, EXPECTED_TYPE_INFO_STRATEGY);
                    }
                });
                for (ExpectedTypeInfo info : infos) {
                    JavaSmartCompletionParameters parameters = new JavaSmartCompletionParameters(params, info);
                    final PsiType type = info.getType();
                    CompletionService service = CompletionService.getCompletionService();
                    new BasicExpressionCompletionContributor().fillCompletionVariants(parameters, service.createResultSet((CompletionParameters)parameters, (Consumer)new Consumer<LookupElement>(){

                        public void consume(LookupElement lookupElement) {
                            PsiType psiType;
                            TypedLookupItem typed = JavaCompletionUtil.typedFrom(lookupElement);
                            if (typed != null && (psiType = typed.getType()) != null && type.isAssignableFrom(psiType)) {
                                result.addElement((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, _infos));
                            }
                        }
                    }, (CompletionContributor)JavaSmartCompletionContributor.this));
                    ReferenceExpressionCompletionContributor.fillCompletionVariants(parameters, service.createResultSet((CompletionParameters)parameters, (Consumer)new Consumer<LookupElement>(){

                        public void consume(LookupElement lookupElement) {
                            result.addElement((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, _infos));
                        }
                    }, (CompletionContributor)JavaSmartCompletionContributor.this));
                }
            }
        });
        this.extend(CompletionType.SMART, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withSuperParent(2, PsiNameValuePair.class)}), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$5.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$5.addCompletions must not be null");
                }
                PsiElement element = parameters.getPosition();
                PsiElementPattern leftNeighbor = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."));
                boolean needQualify = leftNeighbor.accepts((Object)element);
                for (PsiType type : ExpectedTypesGetter.getExpectedTypes(element, false)) {
                    PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                    if (psiClass == null || !psiClass.isAnnotationType()) continue;
                    MutableLookupElement item = new JavaPsiClassReferenceElement(psiClass).setTailType(TailType.NONE);
                    if (needQualify) {
                        JavaCompletionUtil.qualify((LookupItem)item);
                    }
                    result.addElement((LookupElement)item);
                }
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PsiDocTag.class).withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"throws", EXCEPTION_TAG}))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$6.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$6.addCompletions must not be null");
                }
                PsiElement element = parameters.getPosition();
                HashSet<PsiClass> throwsSet = new HashSet<PsiClass>();
                PsiMethod method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)element, PsiMethod.class, (boolean)true);
                if (method != null) {
                    for (PsiClassType ref : method.getThrowsList().getReferencedTypes()) {
                        PsiClass exception = ref.resolve();
                        if (exception == null || !throwsSet.add(exception)) continue;
                        result.addElement(TailTypeDecorator.withTail(new JavaPsiClassReferenceElement(exception).setInsertHandler(new DefaultInsertHandler()), TailType.SPACE));
                    }
                }
            }
        });
        final Key tryKey = Key.create((String)"try");
        this.extend(CompletionType.SMART, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("("))).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(PsiCatchSection.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiTryStatement.class).save(tryKey))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$7.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$7.addCompletions must not be null");
                }
                PsiCodeBlock tryBlock = ((PsiTryStatement)context.get(tryKey)).getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                for (PsiClassType type : ExceptionUtil.getThrownExceptions((PsiElement[])tryBlock.getStatements())) {
                    result.addElement(TailTypeDecorator.withTail(PsiTypeLookupItem.createLookupItem((PsiType)type, (PsiElement)tryBlock).setInsertHandler(new DefaultInsertHandler()), TailType.SPACE));
                }
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PsiReferenceParameterList.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext processingContext, final @NotNull CompletionResultSet resultSet) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$8.addCompletions must not be null");
                }
                if (resultSet == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$8.addCompletions must not be null");
                }
                final PsiElement context = parameters.getPosition();
                Pair<PsiClass, Integer> pair = JavaSmartCompletionContributor.getTypeParameterInfo(context);
                if (pair == null) {
                    return;
                }
                final PsiClass referencedClass = (PsiClass)pair.first;
                int parameterIndex = (Integer)pair.second;
                PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
                final PsiTypeParameter targetParameter = typeParameters[parameterIndex];
                boolean isLast = parameterIndex == typeParameters.length - 1;
                final TailType tail = isLast ? new CharTailType('>') : TailType.COMMA;
                boolean hasExpected = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
                        PsiType[] psiTypes = ExpectedTypesGetter.getExpectedTypes(context, false);
                        if (psiTypes.length == 0) {
                            return false;
                        }
                        for (PsiType type : psiTypes) {
                            if (!(type instanceof PsiClassType)) continue;
                            PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
                            PsiClass typeClass = result.getElement();
                            PsiSubstitutor substitutor = result.getSubstitutor();
                            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)referencedClass, (PsiClass)typeClass, (boolean)true)) continue;
                            PsiSubstitutor currentSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)typeClass, (PsiClass)referencedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)typeClass)) {
                                PsiType argSubstitution = substitutor.substitute(parameter);
                                PsiType paramSubstitution = currentSubstitutor.substitute(parameter);
                                PsiType substitution = resolveHelper.getSubstitutionForTypeParameter(targetParameter, paramSubstitution, argSubstitution, false, PsiUtil.getLanguageLevel((PsiElement)context));
                                if (substitution == null || substitution == PsiType.NULL) continue;
                                LookupItem item = PsiTypeLookupItem.createLookupItem(substitution, context);
                                resultSet.addElement(TailTypeDecorator.withTail(item.setInsertHandler(new DefaultInsertHandler()), tail));
                            }
                        }
                        return true;
                    }
                });
                if (!hasExpected) {
                    List<PsiClassType> typeList = Collections.singletonList((PsiClassType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)targetParameter));
                    JavaSmartCompletionContributor.processInheritors(parameters, context, parameters.getOriginalFile(), typeList, new Consumer<PsiType>(){

                        public void consume(PsiType type) {
                            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                            if (psiClass == null) {
                                return;
                            }
                            resultSet.addElement(TailTypeDecorator.withTail(new JavaPsiClassReferenceElement(psiClass).setInsertHandler(new DefaultInsertHandler()), tail));
                        }
                    }, resultSet.getPrefixMatcher());
                }
            }
        });
        this.extend(CompletionType.SMART, AFTER_NEW, (CompletionProvider)new CompletionProvider<CompletionParameters>(false){

            public void addCompletions(final @NotNull CompletionParameters parameters, ProcessingContext matchingContext, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$9.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor$9.addCompletions must not be null");
                }
                final PsiElement identifierCopy = parameters.getPosition();
                PsiFile file = parameters.getOriginalFile();
                SmartList expectedClassTypes = new SmartList();
                SmartList expectedArrayTypes = new SmartList();
                SmartList infos = new SmartList();
                ApplicationManager.getApplication().runReadAction(new Runnable((List)infos, parameters, identifierCopy, (List)expectedClassTypes, (List)expectedArrayTypes){
                    final /* synthetic */ List val$infos;
                    final /* synthetic */ CompletionParameters val$parameters;
                    final /* synthetic */ PsiElement val$identifierCopy;
                    final /* synthetic */ List val$expectedClassTypes;
                    final /* synthetic */ List val$expectedArrayTypes;
                    {
                        this.val$infos = list;
                        this.val$parameters = completionParameters;
                        this.val$identifierCopy = psiElement;
                        this.val$expectedClassTypes = list2;
                        this.val$expectedArrayTypes = list3;
                    }

                    @Override
                    public void run() {
                        this.val$infos.addAll(Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes(this.val$parameters)));
                        for (PsiType type : ExpectedTypesGetter.getExpectedTypes(this.val$identifierCopy, true)) {
                            if (type instanceof PsiClassType) {
                                PsiClassType classType = (PsiClassType)type;
                                if (classType.resolve() == null) continue;
                                this.val$expectedClassTypes.add(classType);
                                continue;
                            }
                            if (!(type instanceof PsiArrayType)) continue;
                            this.val$expectedArrayTypes.add((PsiArrayType)type);
                        }
                    }
                });
                for (final PsiArrayType type : expectedArrayTypes) {
                    ApplicationManager.getApplication().runReadAction(new Runnable((List)infos){
                        final /* synthetic */ List val$infos;
                        {
                            this.val$infos = list;
                        }

                        @Override
                        public void run() {
                            LookupItem item = PsiTypeLookupItem.createLookupItem(JavaCompletionUtil.eliminateWildcards((PsiType)type), identifierCopy);
                            item.setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, "");
                            if (item.getObject() instanceof PsiClass) {
                                JavaCompletionUtil.setShowFQN(item);
                            }
                            item.setInsertHandler(new DefaultInsertHandler());
                            result.addElement((LookupElement)JavaSmartCompletionContributor.decorate((LookupElement)item, this.val$infos));
                        }
                    });
                }
                JavaSmartCompletionContributor.processInheritors(parameters, identifierCopy, file, (Collection<PsiClassType>)expectedClassTypes, new Consumer<PsiType>((List)infos){
                    final /* synthetic */ List val$infos;
                    {
                        this.val$infos = list;
                    }

                    public void consume(PsiType type) {
                        JavaSmartCompletionContributor.addExpectedType(result, type, parameters, this.val$infos);
                    }
                }, result.getPrefixMatcher());
            }
        });
    }

    public static SmartCompletionDecorator decorate(LookupElement lookupElement, Collection<ExpectedTypeInfo> infos) {
        LookupItem lookupItem;
        if (lookupElement instanceof LookupItem && (lookupItem = (LookupItem)lookupElement).getInsertHandler() == null) {
            lookupItem.setInsertHandler(new DefaultInsertHandler(){

                @Override
                protected TailType getTailType(char completionChar) {
                    return TailType.NONE;
                }
            });
        }
        return new SmartCompletionDecorator(lookupElement, infos);
    }

    private static LookupElement createInstanceofLookupElement(PsiClass psiClass, Set<PsiClass> toWildcardInheritors) {
        PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
        if (typeParameters.length > 0) {
            for (PsiClass parameterizedType : toWildcardInheritors) {
                if (!psiClass.isInheritor(parameterizedType, true)) continue;
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiWildcardType wildcard = PsiWildcardType.createUnbounded((PsiManager)psiClass.getManager());
                for (PsiTypeParameter typeParameter : typeParameters) {
                    substitutor = substitutor.put(typeParameter, (PsiType)wildcard);
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
                return PsiTypeLookupItem.createLookupItem((PsiType)factory.createType(psiClass, substitutor), (PsiElement)psiClass);
            }
        }
        return new JavaPsiClassReferenceElement(psiClass);
    }

    @Nullable
    public static Pair<PsiClass, Integer> getTypeParameterInfo(PsiElement context) {
        int parameterIndex;
        PsiReferenceParameterList parameterList = (PsiReferenceParameterList)PsiTreeUtil.getContextOfType((PsiElement)context, PsiReferenceParameterList.class, (boolean)true);
        if (parameterList == null) {
            return null;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parameterList.getParent();
        int index = 0;
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getContextOfType((PsiElement)context, PsiTypeElement.class, (boolean)true);
        if (typeElement != null) {
            PsiTypeElement element;
            PsiTypeElement[] elements = referenceElement.getParameterList().getTypeParameterElements();
            while (index < elements.length && (element = elements[index++]) != typeElement) {
            }
        }
        if ((parameterIndex = index - 1) < 0) {
            return null;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiClass)) {
            return null;
        }
        PsiClass referencedClass = (PsiClass)target;
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length <= parameterIndex) {
            return null;
        }
        return Pair.create((Object)referencedClass, (Object)parameterIndex);
    }

    public static void processInheritors(final CompletionParameters parameters, PsiElement identifierCopy, final PsiFile file, Collection<PsiClassType> expectedClassTypes, final Consumer<PsiType> consumer, final PrefixMatcher matcher) {
        for (final PsiClassType type : expectedClassTypes) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    StatisticsInfo[] statisticsInfos;
                    consumer.consume((Object)type);
                    PsiClassType.ClassResolveResult baseResult = JavaCompletionUtil.originalize(type).resolveGenerics();
                    PsiClass baseClass = baseResult.getElement();
                    if (baseClass == null) {
                        return;
                    }
                    PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
                    THashSet statVariants = new THashSet();
                    Processor<PsiClass> processor = CodeInsightUtil.createInheritorsProcessor(parameters.getPosition(), type, 0, false, (Set<PsiType>)statVariants, baseClass, baseSubstitutor);
                    for (StatisticsInfo statisticsInfo : statisticsInfos = StatisticsManager.getInstance().getAllValues(JavaStatisticsManager.getAfterNewKey((PsiType)type))) {
                        String value = statisticsInfo.getValue();
                        if (!value.startsWith("class#")) continue;
                        String qname = value.substring("class#".length());
                        PsiClass psiClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(qname, file.getResolveScope());
                        if (psiClass != null && !PsiTreeUtil.isAncestor((PsiElement)file, (PsiElement)psiClass, (boolean)true) && !processor.process((Object)psiClass)) break;
                    }
                    for (PsiType variant : statVariants) {
                        consumer.consume((Object)variant);
                    }
                }
            });
        }
        Condition<String> shortNameCondition = new Condition<String>(){

            public boolean value(String s) {
                return matcher.prefixMatches(s);
            }
        };
        for (final PsiClassType type : expectedClassTypes) {
            boolean shouldSearchForInheritors = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    PsiClass psiClass = type.resolve();
                    return psiClass != null && psiClass.isValid() && !psiClass.hasModifierProperty("final");
                }
            });
            if (!shouldSearchForInheritors) continue;
            Set<PsiType> psiTypes = CodeInsightUtil.addSubtypes((PsiType)type, identifierCopy, false, shortNameCondition);
            for (final PsiType psiType : psiTypes) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (psiType.isValid()) {
                            consumer.consume((Object)psiType);
                        }
                    }
                });
            }
        }
    }

    public static ExpectedTypeInfo[] getExpectedTypes(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)position)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)position.getProject()).getElementFactory();
            PsiClassType classType = factory.createTypeByFQClassName("java.lang.RuntimeException", position.getResolveScope());
            SmartList result = new SmartList();
            result.add(new ExpectedTypeInfoImpl((PsiType)classType, 1, 0, (PsiType)classType, TailType.SEMICOLON));
            PsiMethod method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)position, PsiMethod.class, (boolean)true);
            if (method != null) {
                for (PsiClassType type : method.getThrowsList().getReferencedTypes()) {
                    result.add(new ExpectedTypeInfoImpl((PsiType)type, 1, 0, (PsiType)type, TailType.SEMICOLON));
                }
            }
            return result.toArray(new ExpectedTypeInfo[result.size()]);
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)position, PsiExpression.class, (boolean)true);
        if (expression == null) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        return ExpectedTypesProvider.getInstance(position.getProject()).getExpectedTypes(expression, true, parameters.getCompletionType() == CompletionType.SMART);
    }

    private static void addExpectedType(CompletionResultSet result, PsiType type, CompletionParameters parameters, Collection<ExpectedTypeInfo> infos) {
        if (!JavaCompletionUtil.hasAccessibleConstructor(type)) {
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null) {
            return;
        }
        PsiClass parentClass = psiClass.getContainingClass();
        if (!(parentClass == null || psiClass.hasModifierProperty("static") || PsiTreeUtil.isAncestor((PsiElement)parentClass, (PsiElement)parameters.getPosition(), (boolean)false) || parentClass.getContainingFile().equals(parameters.getOriginalFile()) && parentClass.getTextRange().contains(parameters.getOffset()))) {
            return;
        }
        LookupItem item = PsiTypeLookupItem.createLookupItem(JavaCompletionUtil.eliminateWildcards(type), parameters.getPosition());
        item.setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, "");
        JavaCompletionUtil.setShowFQN(item);
        item.setAttribute(LookupItem.NEW_OBJECT_ATTR, "");
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) {
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            item.setAttribute(LookupItem.INDICATE_ANONYMOUS, "");
        }
        result.addElement((LookupElement)JavaSmartCompletionContributor.decorate((LookupElement)item, infos));
    }

    static Set<LookupElement> completeReference(PsiElement element, PsiReference reference, final ElementFilter filter, final boolean acceptClasses, CompletionParameters parameters) {
        if (reference instanceof PsiMultiReference) {
            reference = (PsiReference)ContainerUtil.findInstance((Object[])((PsiMultiReference)reference).getReferences(), PsiJavaReference.class);
        }
        if (reference instanceof PsiJavaReference) {
            PsiJavaReference javaReference = (PsiJavaReference)reference;
            return JavaCompletionUtil.processJavaReference(element, javaReference, new ElementFilter(){

                public boolean isAcceptable(Object element, PsiElement context) {
                    return filter.isAcceptable(element, context);
                }

                public boolean isClassAcceptable(Class hintClass) {
                    if (acceptClasses) {
                        return ReflectionCache.isAssignable(PsiClass.class, (Class)hintClass);
                    }
                    return ReflectionCache.isAssignable(PsiVariable.class, (Class)hintClass) || ReflectionCache.isAssignable(PsiMethod.class, (Class)hintClass) || ReflectionCache.isAssignable(CandidateInfo.class, (Class)hintClass);
                }
            }, true, null, parameters);
        }
        return Collections.emptySet();
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement lastElement;
        PsiFile file;
        PsiElement element;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaSmartCompletionContributor.beforeCompletion must not be null");
        }
        if (context.getCompletionType() != CompletionType.SMART) {
            return;
        }
        if (!context.getEditor().getSelectionModel().hasSelection() && (element = (file = context.getFile()).findElementAt(context.getStartOffset())) instanceof PsiIdentifier) {
            element = element.getParent();
            while (element instanceof PsiJavaCodeReferenceElement || element instanceof PsiMethodCallExpression || element instanceof PsiThisExpression || element instanceof PsiSuperExpression || element instanceof PsiTypeElement || element instanceof PsiClassObjectAccessExpression) {
                int newEnd = element.getTextRange().getEndOffset();
                if (element instanceof PsiMethodCallExpression) {
                    newEnd = ((PsiMethodCallExpression)element).getMethodExpression().getElement().getTextRange().getEndOffset();
                }
                context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, newEnd);
                element = element.getParent();
            }
        }
        if ((lastElement = context.getFile().findElementAt(context.getStartOffset() - 1)) != null && lastElement.getText().equals("(")) {
            PsiElement parent = lastElement.getParent();
            if (parent instanceof PsiTypeCastExpression) {
                context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher(""));
                return;
            }
            if (parent instanceof PsiParenthesizedExpression) {
                context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("xxx)yyy "));
                return;
            }
        }
        context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("xxx"));
    }
}

