/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.jsp.jspJava.JspMethodCall;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypesProvider {
    private static final ExpectedTypeInfo VOID_EXPECTED = new ExpectedTypeInfoImpl(PsiType.VOID, 1, 0, PsiType.VOID, TailType.SEMICOLON);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypesProvider");
    private static final ExpectedClassProvider ourGlobalScopeClassProvider = new ExpectedClassProvider(){

        @Override
        public PsiField[] findDeclaredFields(PsiManager manager, String name) {
            PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)manager.getProject()).getShortNamesCache();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            return cache.getFieldsByName(name, scope);
        }

        @Override
        public PsiMethod[] findDeclaredMethods(PsiManager manager, String name) {
            PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)manager.getProject()).getShortNamesCache();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            return cache.getMethodsByName(name, scope);
        }
    };
    private static final PsiType[] PRIMITIVE_TYPES = new PsiType[]{PsiType.BYTE, PsiType.CHAR, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE};

    public static ExpectedTypesProvider getInstance(Project project) {
        return (ExpectedTypesProvider)ServiceManager.getService((Project)project, ExpectedTypesProvider.class);
    }

    public static ExpectedTypeInfo createInfo(@NotNull PsiType type, int kind, PsiType defaultType, TailType tailType) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExpectedTypesProvider.createInfo must not be null");
        }
        return ExpectedTypesProvider.createInfoImpl(type, kind, defaultType, tailType);
    }

    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, int kind, PsiType defaultType, TailType tailType) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExpectedTypesProvider.createInfoImpl must not be null");
        }
        int dims = 0;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
            LOG.assertTrue(defaultType instanceof PsiArrayType);
            defaultType = ((PsiArrayType)defaultType).getComponentType();
            ++dims;
        }
        return new ExpectedTypeInfoImpl(type, kind, dims, defaultType, tailType);
    }

    public ExpectedTypeInfo[] getExpectedTypes(PsiExpression expr, boolean forCompletion) {
        return this.getExpectedTypes(expr, forCompletion, false);
    }

    public ExpectedTypeInfo[] getExpectedTypes(PsiExpression expr, boolean forCompletion, boolean voidable) {
        return this.getExpectedTypes(expr, forCompletion, ourGlobalScopeClassProvider, voidable);
    }

    public ExpectedTypeInfo[] getExpectedTypes(PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider) {
        return this.getExpectedTypes(expr, forCompletion, classProvider, false);
    }

    public ExpectedTypeInfo[] getExpectedTypes(PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable) {
        if (expr == null) {
            return null;
        }
        PsiElement parent = expr.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            expr = (PsiExpression)parent;
            parent = parent.getParent();
        }
        MyParentVisitor visitor = new MyParentVisitor(expr, forCompletion, classProvider, voidable);
        parent.accept((PsiElementVisitor)visitor);
        return visitor.getResult();
    }

    public static PsiType[] processExpectedTypes(ExpectedTypeInfo[] infos, PsiTypeVisitor<PsiType> visitor, Project project) {
        LinkedHashSet<PsiType> set = new LinkedHashSet<PsiType>();
        for (ExpectedTypeInfo info : infos) {
            ExpectedTypeInfoImpl infoImpl = (ExpectedTypeInfoImpl)info;
            if (infoImpl.getDefaultType() instanceof PsiClassType && infoImpl.getDimCount() == 0) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)infoImpl.getDefaultType()).resolveGenerics();
                PsiClass aClass = (PsiClass)result.getElement();
                if (aClass instanceof PsiAnonymousClass) {
                    ExpectedTypesProvider.processType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType(), visitor, set);
                    ((PsiAnonymousClass)aClass).getBaseClassType().accept(visitor);
                } else {
                    ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
                }
            } else {
                ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
            }
            if (infoImpl.kind == 2) {
                ExpectedTypesProvider.processAllSuperTypes(infoImpl.getType(), infoImpl.getDimCount(), visitor, project, set);
                continue;
            }
            if (infoImpl.getKind() != 1 || !(infoImpl.getType() instanceof PsiPrimitiveType) || infoImpl.getDimCount() != 0) continue;
            ExpectedTypesProvider.processPrimitiveTypeAndSubtypes((PsiPrimitiveType)infoImpl.getType(), visitor, set);
        }
        return set.toArray(new PsiType[set.size()]);
    }

    private static void processType(@NotNull PsiType type, PsiTypeVisitor<PsiType> visitor, Set<PsiType> typeSet) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExpectedTypesProvider.processType must not be null");
        }
        PsiType accepted = (PsiType)type.accept(visitor);
        if (accepted != null) {
            typeSet.add(accepted);
        }
    }

    public static void processPrimitiveTypeAndSubtypes(PsiPrimitiveType type, PsiTypeVisitor<PsiType> visitor, Set<PsiType> set) {
        if (type.equals((Object)PsiType.BOOLEAN) || type.equals((Object)PsiType.VOID) || type.equals((Object)PsiType.NULL)) {
            return;
        }
        int i = 0;
        while (true) {
            PsiType primitive = PRIMITIVE_TYPES[i];
            ExpectedTypesProvider.processType(primitive, visitor, set);
            if (primitive.equals(type)) {
                return;
            }
            ++i;
        }
    }

    public static void processAllSuperTypes(PsiType type, int dimCount, PsiTypeVisitor<PsiType> visitor, Project project, Set<PsiType> set) {
        block7: {
            PsiType[] superTypes;
            block6: {
                if (!(type instanceof PsiPrimitiveType)) break block6;
                if (type.equals(PsiType.BOOLEAN) || type.equals(PsiType.VOID) || type.equals(PsiType.NULL)) {
                    return;
                }
                Stack<PsiType> stack = new Stack<PsiType>();
                int i = PRIMITIVE_TYPES.length - 1;
                while (!PRIMITIVE_TYPES[i].equals(type)) {
                    stack.push(PRIMITIVE_TYPES[i]);
                    --i;
                }
                while (!stack.empty()) {
                    ExpectedTypesProvider.processType((PsiType)stack.pop(), visitor, set);
                }
                break block7;
            }
            PsiManager manager = PsiManager.getInstance((Project)project);
            GlobalSearchScope resolveScope = type.getResolveScope();
            if (resolveScope == null) {
                resolveScope = GlobalSearchScope.allScope((Project)project);
            }
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            ExpectedTypesProvider.processType((PsiType)objectType, visitor, set);
            if (!(type instanceof PsiClassType)) break block7;
            PsiType[] arr$ = superTypes = type.getSuperTypes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PsiType superType;
                PsiType wrappedType = superType = arr$[i$];
                for (int j = 0; j < dimCount; ++j) {
                    wrappedType = wrappedType.createArrayType();
                }
                ExpectedTypesProvider.processType(wrappedType, visitor, set);
                ExpectedTypesProvider.processAllSuperTypes(superType, dimCount, visitor, project, set);
            }
        }
    }

    public static interface ExpectedClassProvider {
        public PsiField[] findDeclaredFields(PsiManager var1, String var2);

        public PsiMethod[] findDeclaredMethods(PsiManager var1, String var2);
    }

    private class MyParentVisitor
    extends JavaElementVisitor {
        private PsiExpression myExpr;
        private final boolean myForCompletion;
        private final ExpectedClassProvider myClassProvider;
        private boolean myVoidable;
        private ExpectedTypeInfo[] myResult = ExpectedTypeInfo.EMPTY_ARRAY;
        @NonNls
        private static final String LENGTH_SYNTHETIC_ARRAY_FIELD = "length";

        private MyParentVisitor(PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable) {
            this.myExpr = expr;
            this.myForCompletion = forCompletion;
            this.myClassProvider = classProvider;
            this.myVoidable = voidable;
        }

        public ExpectedTypeInfo[] getResult() {
            return this.myResult;
        }

        public void visitAnnotationMethod(PsiAnnotationMethod method) {
            PsiType type;
            if (this.myExpr == method.getDefaultValue() && (type = method.getReturnType()) != null) {
                this.myResult = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.SEMICOLON)};
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.myForCompletion) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression, this.myForCompletion, this.myClassProvider, this.myVoidable);
                expression.getParent().accept((PsiElementVisitor)visitor);
                this.myResult = visitor.getResult();
                return;
            }
            String referenceName = expression.getReferenceName();
            if (referenceName != null) {
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    this.myResult = this.findClassesWithDeclaredMethod((PsiMethodCallExpression)parent, this.myForCompletion);
                } else if (parent instanceof PsiReferenceExpression || parent instanceof PsiVariable || parent instanceof PsiExpression) {
                    this.myResult = LENGTH_SYNTHETIC_ARRAY_FIELD.equals(referenceName) ? this.anyArrayType() : this.findClassesWithDeclaredField(expression);
                }
            }
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            if (this.myVoidable) {
                this.myResult = new ExpectedTypeInfo[]{VOID_EXPECTED};
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            this.myExpr = (PsiExpression)this.myExpr.getParent();
            expression.getParent().accept((PsiElementVisitor)this);
        }

        public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
            PsiType type = this.getAnnotationMethodType((PsiNameValuePair)initializer.getParent());
            if (type instanceof PsiArrayType) {
                this.myResult = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfoImpl(((PsiArrayType)type).getComponentType(), 1, type, TailType.UNKNOWN)};
            }
        }

        public void visitNameValuePair(PsiNameValuePair pair) {
            PsiType type = this.getAnnotationMethodType(pair);
            if (type == null) {
                return;
            }
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.UNKNOWN);
            this.myResult = type instanceof PsiArrayType ? new ExpectedTypeInfo[]{info, ExpectedTypesProvider.createInfoImpl(((PsiArrayType)type).getComponentType(), 1, type, TailType.UNKNOWN)} : new ExpectedTypeInfo[]{info};
        }

        @Nullable
        private PsiType getAnnotationMethodType(PsiNameValuePair pair) {
            PsiElement method;
            PsiReference reference = pair.getReference();
            if (reference != null && (method = reference.resolve()) instanceof PsiMethod) {
                return ((PsiMethod)method).getReturnType();
            }
            return null;
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod scopeMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            if (scopeMethod != null) {
                PsiType type = scopeMethod.getReturnType();
                if (type != null) {
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.SEMICOLON);
                    if (PropertyUtil.isSimplePropertyAccessor((PsiMethod)scopeMethod)) {
                        info.expectedName = PropertyUtil.getPropertyName((PsiMethod)scopeMethod);
                    }
                    this.myResult = new ExpectedTypeInfo[]{info};
                } else {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                }
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailTypes.IF_RPARENTH);
            this.myResult = new ExpectedTypeInfo[]{info};
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH);
            this.myResult = new ExpectedTypeInfo[]{info};
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH);
            this.myResult = new ExpectedTypeInfo[]{info};
        }

        public void visitForStatement(PsiForStatement statement) {
            if (this.myExpr.equals(statement.getCondition())) {
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailType.SEMICOLON);
                this.myResult = new ExpectedTypeInfo[]{info};
            }
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailType.SEMICOLON);
            this.myResult = new ExpectedTypeInfo[]{info};
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            if (this.myExpr.equals(statement.getIteratedValue())) {
                PsiType type = statement.getIterationParameter().getType();
                PsiArrayType arrayType = type.createArrayType();
                ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, 1, (PsiType)arrayType, TailType.NONE);
                PsiManager manager = statement.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiClass iterableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Iterable", statement.getResolveScope());
                if (iterableClass == null || iterableClass.getTypeParameters().length != 1) {
                    this.myResult = new ExpectedTypeInfo[]{info1};
                } else {
                    HashMap map = new HashMap();
                    map.put(iterableClass.getTypeParameters()[0], PsiWildcardType.createExtends((PsiManager)manager, (PsiType)type));
                    PsiSubstitutor substitutor = factory.createSubstitutor((Map)map);
                    PsiClassType iterableType = factory.createType(iterableClass, substitutor);
                    ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl((PsiType)iterableType, 1, (PsiType)iterableType, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info1, info2};
                }
            }
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.LONG, 1, PsiType.INT, TailType.NONE);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)statement)) {
                this.myResult = new ExpectedTypeInfo[]{info};
                return;
            }
            PsiManager manager = statement.getManager();
            PsiClassType enumType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Enum", statement.getResolveScope());
            ExpectedTypeInfoImpl enumInfo = ExpectedTypesProvider.createInfoImpl((PsiType)enumType, 1, (PsiType)enumType, TailType.NONE);
            this.myResult = new ExpectedTypeInfo[]{info, enumInfo};
        }

        public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
            PsiType type;
            PsiExpression expression;
            PsiSwitchStatement switchStatement = statement.getEnclosingSwitchStatement();
            if (switchStatement != null && (expression = switchStatement.getExpression()) != null && (type = expression.getType()) != null) {
                this.myResult = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.CASE_COLON)};
            }
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)statement.getProject()).getElementFactory();
            PsiClassType objectType = factory.createTypeByFQClassName("java.lang.Object", this.myExpr.getResolveScope());
            this.myResult = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfoImpl((PsiType)objectType, 1, (PsiType)objectType, TailType.NONE)};
        }

        public void visitVariable(PsiVariable variable) {
            PsiType type = variable.getType();
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.SEMICOLON);
            info.expectedName = this.getPropertyName(variable);
            this.myResult = new ExpectedTypeInfo[]{info};
        }

        public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
            if (this.myExpr.equals(assignment.getRExpression())) {
                PsiExpression lExpr = assignment.getLExpression();
                PsiType type = lExpr.getType();
                if (type != null) {
                    PsiElement refElement;
                    TailType tailType = this.getAssignmentRValueTailType(assignment);
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(type, 1, type, tailType);
                    if (lExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                        info.expectedName = this.getPropertyName((PsiVariable)refElement);
                    }
                    this.myResult = new ExpectedTypeInfo[]{info};
                } else {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                }
            } else {
                PsiType type;
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    assignment.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiExpression rExpr = assignment.getRExpression();
                if (rExpr != null && (type = rExpr.getType()) != null) {
                    PsiClass resolved;
                    if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) instanceof PsiAnonymousClass) {
                        type = ((PsiAnonymousClass)resolved).getBaseClassType();
                    }
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(type, 2, type, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info};
                    return;
                }
                this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
            }
        }

        private TailType getAssignmentRValueTailType(PsiAssignmentExpression assignment) {
            if (assignment.getParent() instanceof PsiExpressionStatement) {
                if (!(assignment.getParent().getParent() instanceof PsiForStatement)) {
                    return TailType.SEMICOLON;
                }
                PsiForStatement forStatement = (PsiForStatement)assignment.getParent().getParent();
                if (!assignment.getParent().equals(forStatement.getUpdate())) {
                    return TailType.SEMICOLON;
                }
            }
            return TailType.NONE;
        }

        public void visitExpressionList(PsiExpressionList list) {
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            if (list.getParent() instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)list.getParent();
                CandidateInfo[] candidates = helper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false);
                this.myResult = this.getExpectedArgumentTypesForMethodCall(candidates, list, this.myExpr, this.myForCompletion);
            } else if (list.getParent() instanceof PsiEnumConstant) {
                this.getExpectedArgumentsTypesForEnumConstant((PsiEnumConstant)list.getParent(), helper, list);
            } else if (list.getParent() instanceof PsiNewExpression) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)list.getParent(), helper, list);
            } else if (list.getParent() instanceof PsiAnonymousClass) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)list.getParent().getParent(), helper, list);
            }
        }

        private void getExpectedArgumentsTypesForEnumConstant(PsiEnumConstant enumConstant, PsiResolveHelper helper, PsiExpressionList list) {
            PsiClass aClass = enumConstant.getContainingClass();
            if (aClass != null) {
                LOG.assertTrue(aClass.isEnum());
                this.getExpectedTypesForConstructorCall(aClass, helper, list, PsiSubstitutor.EMPTY);
            }
        }

        private void getExpectedArgumentsTypesForNewExpression(PsiNewExpression newExpr, PsiResolveHelper helper, PsiExpressionList list) {
            PsiType newType = newExpr.getType();
            if (newType instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)newType);
                PsiClass newClass = (PsiClass)resolveResult.getElement();
                if (newClass instanceof PsiAnonymousClass) {
                    PsiAnonymousClass anonymous = (PsiAnonymousClass)newClass;
                    if ((newClass = anonymous.getBaseClassType().resolve()) == null) {
                        return;
                    }
                    substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)newClass, (PsiClass)anonymous, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                } else if (newClass != null) {
                    substitutor = resolveResult.getSubstitutor();
                } else {
                    return;
                }
                this.getExpectedTypesForConstructorCall(newClass, helper, list, substitutor);
            }
        }

        private void getExpectedTypesForConstructorCall(PsiClass referencedClass, PsiResolveHelper helper, PsiExpressionList argumentList, PsiSubstitutor substitutor) {
            PsiMethod[] constructors;
            ArrayList<MethodCandidateInfo> array = new ArrayList<MethodCandidateInfo>();
            for (PsiMethod constructor : constructors = referencedClass.getConstructors()) {
                if (!helper.isAccessible((PsiMember)constructor, (PsiElement)argumentList, null)) continue;
                array.add(new MethodCandidateInfo((PsiElement)constructor, substitutor, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null));
            }
            CandidateInfo[] candidates = array.toArray(new CandidateInfo[array.size()]);
            this.myResult = this.getExpectedArgumentTypesForMethodCall(candidates, argumentList, this.myExpr, this.myForCompletion);
        }

        public void visitBinaryExpression(PsiBinaryExpression expr) {
            PsiExpression op1 = expr.getLOperand();
            PsiExpression op2 = expr.getROperand();
            PsiJavaToken sign = expr.getOperationSign();
            if (this.myForCompletion && op1.equals(this.myExpr)) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, this.myForCompletion, this.myClassProvider, this.myVoidable);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                expr.getParent().accept((PsiElementVisitor)visitor);
                this.myResult = visitor.getResult();
                if (!(expr.getParent() instanceof PsiExpressionList)) {
                    for (ExpectedTypeInfo info : this.myResult) {
                        ((ExpectedTypeInfoImpl)info).myTailType = TailType.NONE;
                    }
                }
                return;
            }
            PsiExpression anotherExpr = op1.equals(this.myExpr) ? op2 : op1;
            PsiType anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
            IElementType i = sign.getTokenType();
            if (i == JavaTokenType.MINUS || i == JavaTokenType.ASTERISK || i == JavaTokenType.DIV || i == JavaTokenType.PERC || i == JavaTokenType.LT || i == JavaTokenType.GT || i == JavaTokenType.LE || i == JavaTokenType.GE) {
                if (anotherType == null) {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                } else {
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.DOUBLE, 1, anotherType, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info};
                }
            } else if (i == JavaTokenType.PLUS) {
                if (anotherType == null) {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                } else if (anotherType.equalsToText("java.lang.String")) {
                    PsiClassType objType = PsiType.getJavaLangObject((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope());
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)objType, 1, anotherType, TailType.NONE);
                    ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl(PsiType.DOUBLE, 1, PsiType.INT, TailType.NONE);
                    PsiType booleanType = PsiType.BOOLEAN;
                    ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl(booleanType, 0, booleanType, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info, info1, info2};
                } else if (PsiType.DOUBLE.isAssignableFrom(anotherType)) {
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.DOUBLE, 1, anotherType, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info};
                }
            } else if (i == JavaTokenType.EQEQ || i == JavaTokenType.NE) {
                if (anotherType == null) {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                } else {
                    PsiElement refElement;
                    ExpectedTypeInfoImpl info;
                    if (anotherType instanceof PsiPrimitiveType) {
                        if (PsiType.BOOLEAN.equals(anotherType)) {
                            info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE);
                        } else if (PsiType.NULL.equals(anotherType)) {
                            PsiClassType objectType = factory.createTypeByFQClassName("java.lang.Object", this.myExpr.getResolveScope());
                            info = ExpectedTypesProvider.createInfoImpl((PsiType)objectType, 1, (PsiType)objectType, TailType.NONE);
                        } else {
                            info = ExpectedTypesProvider.createInfoImpl(PsiType.DOUBLE, 1, anotherType, TailType.NONE);
                        }
                    } else {
                        info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE);
                    }
                    if (anotherExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)anotherExpr).resolve()) instanceof PsiVariable) {
                        info.expectedName = this.getPropertyName((PsiVariable)refElement);
                    }
                    this.myResult = new ExpectedTypeInfo[]{info};
                }
            } else if (i == JavaTokenType.LTLT || i == JavaTokenType.GTGT || i == JavaTokenType.GTGTGT) {
                if (anotherType == null) {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                } else {
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.DOUBLE, 1, anotherType, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info};
                }
            } else if (i == JavaTokenType.OROR || i == JavaTokenType.ANDAND) {
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailType.NONE);
                this.myResult = new ExpectedTypeInfo[]{info};
            } else if (i == JavaTokenType.OR || i == JavaTokenType.XOR || i == JavaTokenType.AND) {
                if (anotherType == null) {
                    this.myResult = ExpectedTypeInfo.EMPTY_ARRAY;
                } else {
                    ExpectedTypeInfoImpl info = PsiType.BOOLEAN.equals(anotherType) ? ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE) : ExpectedTypesProvider.createInfoImpl(PsiType.LONG, 1, anotherType, TailType.NONE);
                    this.myResult = new ExpectedTypeInfo[]{info};
                }
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expr) {
            TailType tailType;
            PsiJavaToken sign = expr.getOperationSign();
            IElementType i = sign.getTokenType();
            TailType tailType2 = tailType = expr.getParent() instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expr.getParent()).getRExpression() == expr ? this.getAssignmentRValueTailType((PsiAssignmentExpression)expr.getParent()) : TailType.NONE;
            if (i == JavaTokenType.PLUSPLUS || i == JavaTokenType.MINUSMINUS || i == JavaTokenType.TILDE) {
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.LONG, 1, PsiType.INT, tailType);
                this.myResult = new ExpectedTypeInfo[]{info};
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.DOUBLE, 1, PsiType.INT, tailType);
                this.myResult = new ExpectedTypeInfo[]{info};
            } else if (i == JavaTokenType.EXCL) {
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, tailType);
                this.myResult = new ExpectedTypeInfo[]{info};
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expr) {
            if (this.myForCompletion) {
                return;
            }
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.LONG, 1, PsiType.INT, TailType.NONE);
            this.myResult = new ExpectedTypeInfo[]{info};
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expr) {
            PsiType type;
            PsiElement pparent = expr.getParent();
            PsiType arrayType = null;
            if (pparent instanceof PsiVariable) {
                arrayType = ((PsiVariable)pparent).getType();
            } else if (pparent instanceof PsiNewExpression) {
                arrayType = ((PsiNewExpression)pparent).getType();
            } else if (pparent instanceof PsiArrayInitializerExpression && (type = ((PsiArrayInitializerExpression)pparent).getType()) instanceof PsiArrayType) {
                arrayType = ((PsiArrayType)type).getComponentType();
            }
            if (arrayType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(componentType, 1, componentType, TailType.NONE);
                this.myResult = new ExpectedTypeInfo[]{info};
            }
        }

        public void visitNewExpression(PsiNewExpression expression) {
            PsiExpression[] arrayDimensions;
            for (PsiExpression dimension : arrayDimensions = expression.getArrayDimensions()) {
                if (!this.myExpr.equals(dimension)) continue;
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.INT, 1, PsiType.INT, TailType.NONE);
                this.myResult = new ExpectedTypeInfo[]{info};
                return;
            }
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expr) {
            if (this.myExpr.equals(expr.getIndexExpression())) {
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.INT, 1, PsiType.INT, TailType.NONE);
                this.myResult = new ExpectedTypeInfo[]{info};
            } else if (this.myExpr.equals(expr.getArrayExpression())) {
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    expr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiElement parent = expr.getParent();
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, this.myForCompletion, this.myClassProvider, this.myVoidable);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                parent.accept((PsiElementVisitor)visitor);
                ExpectedTypeInfo[] componentTypeInfo = visitor.getResult();
                if (componentTypeInfo.length == 0) {
                    this.myResult = this.anyArrayType();
                } else {
                    this.myResult = new ExpectedTypeInfoImpl[componentTypeInfo.length];
                    for (int i = 0; i < componentTypeInfo.length; ++i) {
                        ExpectedTypeInfo compInfo = componentTypeInfo[i];
                        PsiArrayType expectedArrayType = compInfo.getType().createArrayType();
                        this.myResult[i] = ExpectedTypesProvider.createInfoImpl((PsiType)expectedArrayType, 1, (PsiType)expectedArrayType, TailType.NONE);
                    }
                }
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expr) {
            if (this.myExpr.equals(expr.getCondition())) {
                if (this.myForCompletion) {
                    this.myExpr = expr;
                    this.myExpr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(PsiType.BOOLEAN, 0, PsiType.BOOLEAN, TailType.NONE);
                this.myResult = new ExpectedTypeInfo[]{info};
            } else if (this.myExpr.equals(expr.getThenExpression())) {
                ExpectedTypeInfo[] types = ExpectedTypesProvider.this.getExpectedTypes((PsiExpression)expr, this.myForCompletion);
                if (types != null) {
                    for (ExpectedTypeInfo info : types) {
                        ExpectedTypeInfoImpl infoImpl = (ExpectedTypeInfoImpl)info;
                        infoImpl.setInsertExplicitTypeParams(true);
                        infoImpl.myTailType = TailType.COND_EXPR_COLON;
                    }
                }
                this.myResult = types;
            } else {
                LOG.assertTrue(this.myExpr.equals(expr.getElseExpression()));
                this.myResult = ExpectedTypesProvider.this.getExpectedTypes((PsiExpression)expr, this.myForCompletion);
                if (this.myResult != null) {
                    for (ExpectedTypeInfo info : this.myResult) {
                        ((ExpectedTypeInfoImpl)info).setInsertExplicitTypeParams(true);
                    }
                }
            }
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            if (statement.getException() == this.myExpr) {
                PsiManager manager = statement.getManager();
                PsiClassType throwableType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Throwable", this.myExpr.getResolveScope());
                PsiMember container = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
                PsiType[] throwsTypes = PsiType.EMPTY_ARRAY;
                if (container instanceof PsiMethod) {
                    throwsTypes = ((PsiMethod)container).getThrowsList().getReferencedTypes();
                }
                if (throwsTypes.length == 0) {
                    PsiClassType exceptionType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Exception", this.myExpr.getResolveScope());
                    throwsTypes = new PsiClassType[]{exceptionType};
                }
                ExpectedTypeInfo[] infos = new ExpectedTypeInfo[throwsTypes.length];
                for (int i = 0; i < infos.length; ++i) {
                    infos[i] = ExpectedTypesProvider.createInfoImpl((PsiType)(this.myExpr instanceof PsiTypeCastExpression && this.myForCompletion ? throwsTypes[i] : throwableType), 1, throwsTypes[i], TailType.SEMICOLON);
                }
                this.myResult = infos;
            }
        }

        public void visitCodeFragment(JavaCodeFragment codeFragment) {
            PsiType type;
            if (codeFragment instanceof PsiExpressionCodeFragment && (type = ((PsiExpressionCodeFragment)codeFragment).getExpectedType()) != null) {
                this.myResult = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.NONE)};
            }
        }

        private ExpectedTypeInfo[] getExpectedArgumentTypesForMethodCall(CandidateInfo[] methodCandidates, PsiExpressionList argumentList, PsiExpression argument, boolean forCompletion) {
            PsiSubstitutor substitutor;
            PsiMethod method;
            PsiExpression[] leftArgs;
            if (methodCandidates.length == 0) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            Object[] args = argumentList.getExpressions();
            int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
            LOG.assertTrue(index >= 0);
            if (index <= args.length - 1) {
                leftArgs = new PsiExpression[index];
                System.arraycopy(args, 0, leftArgs, 0, index);
            } else {
                leftArgs = null;
            }
            LinkedHashSet<ExpectedTypeInfo> array = new LinkedHashSet<ExpectedTypeInfo>();
            for (CandidateInfo candidateInfo : methodCandidates) {
                method = (PsiMethod)candidateInfo.getElement();
                if (candidateInfo instanceof MethodCandidateInfo) {
                    MethodCandidateInfo info = (MethodCandidateInfo)candidateInfo;
                    substitutor = info.inferTypeArguments(forCompletion);
                    if (!info.isStaticsScopeCorrect() && method != null && !method.hasModifierProperty("static")) {
                        continue;
                    }
                } else {
                    substitutor = candidateInfo.getSubstitutor();
                }
                this.inferMethodCallArgumentTypes(argument, forCompletion, (PsiExpression[])args, index, method, substitutor, array);
                if (leftArgs == null || !(candidateInfo instanceof MethodCandidateInfo)) continue;
                substitutor = ((MethodCandidateInfo)candidateInfo).inferTypeArguments(forCompletion, leftArgs);
                this.inferMethodCallArgumentTypes(argument, forCompletion, leftArgs, index, method, substitutor, array);
            }
            if (forCompletion && array.isEmpty()) {
                for (CandidateInfo candidate : methodCandidates) {
                    method = (PsiMethod)candidate.getElement();
                    substitutor = candidate.getSubstitutor();
                    PsiParameter[] parms = method.getParameterList().getParameters();
                    if (parms.length <= index) continue;
                    PsiParameter parm = parms[index];
                    PsiType parmType = this.getParameterType(parm, substitutor);
                    TailType tailType = this.getMethodArgumentTailType(argument, index, method, substitutor, parms);
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(parmType, 1, parmType, tailType);
                    info.expectedName = this.getPropertyName((PsiVariable)parm);
                    info.setCalledMethod(method);
                    array.add(info);
                }
            }
            return array.toArray(new ExpectedTypeInfo[array.size()]);
        }

        private TailType getMethodArgumentTailType(PsiExpression argument, int index, PsiMethod method, PsiSubstitutor substitutor, PsiParameter[] parms) {
            if (index >= parms.length) {
                return TailType.NONE;
            }
            if (index == parms.length - 1) {
                PsiElement call = argument.getParent().getParent();
                if (call instanceof JspMethodCall) {
                    return TailType.NONE;
                }
                PsiType returnType = method.getReturnType();
                if (returnType != null) {
                    returnType = substitutor.substitute(returnType);
                }
                return (PsiType.VOID.equals(returnType) || returnType == null) && call.getParent() instanceof PsiStatement ? TailTypes.CALL_RPARENTH_SEMICOLON : TailTypes.CALL_RPARENTH;
            }
            return TailType.COMMA;
        }

        private void inferMethodCallArgumentTypes(PsiExpression argument, boolean forCompletion, PsiExpression[] args, int index, PsiMethod method, PsiSubstitutor substitutor, Set<ExpectedTypeInfo> array) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (!forCompletion && parameters.length != args.length) {
                return;
            }
            if (parameters.length <= index && !method.isVarArgs()) {
                return;
            }
            for (int j = 0; j < index; ++j) {
                PsiType paramType = this.getParameterType(parameters[Math.min(parameters.length - 1, j)], substitutor);
                PsiType argType = args[j].getType();
                if (argType == null || paramType.isAssignableFrom(argType)) continue;
                return;
            }
            PsiParameter parameter = parameters[Math.min(parameters.length - 1, index)];
            PsiType parameterType = this.getParameterType(parameter, substitutor);
            TailType tailType = this.getMethodArgumentTailType(argument, index, method, substitutor, parameters);
            PsiType defaultType = this.getDefautType(method, substitutor, parameterType, argument);
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(parameterType, 1, defaultType, tailType);
            info.setInsertExplicitTypeParams(true);
            info.setCalledMethod(method);
            String propertyName = this.getPropertyName((PsiVariable)parameter);
            if (propertyName != null) {
                info.expectedName = propertyName;
            }
            array.add(info);
            if (index == parameters.length - 1 && parameter.isVarArgs()) {
                PsiArrayType arrayType = parameterType.createArrayType();
                ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, 1, (PsiType)arrayType, tailType);
                info1.setInsertExplicitTypeParams(true);
                info1.setCalledMethod(method);
                info1.expectedName = propertyName;
                array.add(info1);
            }
        }

        @Nullable
        private PsiType getTypeParameterValue(PsiClass rootClass, PsiClass derivedClass, PsiSubstitutor substitutor, int index) {
            PsiType type;
            PsiSubstitutor psiSubstitutor;
            PsiTypeParameter[] typeParameters = rootClass.getTypeParameters();
            if (typeParameters.length > index && (psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)rootClass, (PsiClass)derivedClass, (PsiSubstitutor)substitutor)) != null && (type = psiSubstitutor.substitute(typeParameters[index])) != null) {
                return type;
            }
            return null;
        }

        @Nullable
        protected PsiType checkMethod(PsiMethod method, @NonNls String className, NullableFunction<PsiClass, PsiType> function) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            if (className.equals(containingClass.getQualifiedName())) {
                return (PsiType)function.fun((Object)containingClass);
            }
            for (PsiMethod psiMethod : DeepestSuperMethodsSearch.search((PsiMethod)method).findAll()) {
                PsiClass rootClass = psiMethod.getContainingClass();
                if (!className.equals(rootClass.getQualifiedName())) continue;
                return (PsiType)function.fun((Object)rootClass);
            }
            return null;
        }

        @Nullable
        private PsiType getDefautType(PsiMethod method, final PsiSubstitutor substitutor, PsiType parameterType, final PsiExpression argumentList) {
            PsiType type;
            final PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return parameterType;
            }
            final String name = method.getName();
            if (("contains".equals(name) || "remove".equals(name)) && (type = this.checkMethod(method, "java.util.Collection", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(PsiClass psiClass) {
                    return MyParentVisitor.this.getTypeParameterValue(psiClass, containingClass, substitutor, 0);
                }
            })) != null) {
                return type;
            }
            if (("containsKey".equals(name) || "remove".equals(name) || "get".equals(name) || "containsValue".equals(name)) && (type = this.checkMethod(method, "java.util.Map", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(PsiClass psiClass) {
                    return MyParentVisitor.this.getTypeParameterValue(psiClass, containingClass, substitutor, name.equals("containsValue") ? 1 : 0);
                }
            })) != null) {
                return type;
            }
            if ("equals".equals(name) && (type = this.checkMethod(method, "java.lang.Object", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(PsiClass psiClass) {
                    PsiElement parent = argumentList.getParent().getParent();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression expression = (PsiMethodCallExpression)parent;
                        PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
                        if (qualifierExpression != null) {
                            return qualifierExpression.getType();
                        }
                        PsiClass aClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)parent, PsiClass.class, (boolean)true);
                        if (aClass != null) {
                            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
                        }
                    }
                    return null;
                }
            })) != null) {
                return type;
            }
            return parameterType;
        }

        private PsiType getParameterType(PsiParameter parameter, PsiSubstitutor substitutor) {
            PsiType superBound;
            PsiWildcardType psiWildcardType;
            PsiType parameterType;
            PsiType type = parameter.getType();
            if (parameter.isVarArgs()) {
                type = ((PsiArrayType)type).getComponentType();
            }
            if ((parameterType = substitutor.substitute(type)) instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType instanceof PsiWildcardType && (psiWildcardType = (PsiWildcardType)parameterType).isExtends() && (superBound = psiWildcardType.getBound()) != null) {
                parameterType = superBound;
            }
            return parameterType;
        }

        @Nullable
        private String getPropertyName(PsiVariable variable) {
            String name = variable.getName();
            if (name == null) {
                return null;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
            VariableKind variableKind = codeStyleManager.getVariableKind(variable);
            return codeStyleManager.variableNameToPropertyName(name, variableKind);
        }

        private void addBaseType(Set<ExpectedTypeInfo> types, PsiClassType type, PsiMethod method) {
            PsiType[] supers = type.getSuperTypes();
            boolean addedSuper = false;
            for (PsiType aSuper : supers) {
                PsiClassType superType = (PsiClassType)aSuper;
                PsiClass superClass = superType.resolve();
                if (superClass == null || superClass.findMethodBySignature(method, false) == null) continue;
                this.addBaseType(types, superType, method);
                addedSuper = true;
            }
            if (!addedSuper) {
                types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type, 1, (PsiType)type, TailType.DOT));
            }
        }

        private ExpectedTypeInfo[] anyArrayType() {
            PsiArrayType objType = PsiType.getJavaLangObject((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope()).createArrayType();
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)objType, 1, (PsiType)objType, TailType.NONE);
            ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE.createArrayType(), 1, (PsiType)PsiType.INT.createArrayType(), TailType.NONE);
            PsiArrayType booleanType = PsiType.BOOLEAN.createArrayType();
            ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl((PsiType)booleanType, 0, (PsiType)booleanType, TailType.NONE);
            return new ExpectedTypeInfo[]{info, info1, info2};
        }

        private ExpectedTypeInfo[] findClassesWithDeclaredMethod(PsiMethodCallExpression methodCallExpr, boolean forCompletion) {
            PsiReferenceExpression reference = methodCallExpr.getMethodExpression();
            PsiManager manager = methodCallExpr.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiMethod[] methods = this.myClassProvider.findDeclaredMethods(reference.getManager(), reference.getReferenceName());
            THashSet types = new THashSet();
            for (PsiMethod method : methods) {
                PsiClassType type;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)reference, aClass)) continue;
                PsiSubstitutor substitutor = ExpectedTypeUtil.inferSubstitutor(method, methodCallExpr, forCompletion);
                PsiClassType psiClassType = type = substitutor == null ? facade.getElementFactory().createType(aClass) : facade.getElementFactory().createType(aClass, substitutor);
                if (method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private")) {
                    types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type, 0, (PsiType)type, TailType.DOT));
                    continue;
                }
                this.addBaseType((Set<ExpectedTypeInfo>)types, type, method);
            }
            return types.toArray(new ExpectedTypeInfo[types.size()]);
        }

        private ExpectedTypeInfo[] findClassesWithDeclaredField(PsiReferenceExpression expression) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
            PsiField[] fields = this.myClassProvider.findDeclaredFields(expression.getManager(), expression.getReferenceName());
            ArrayList<ExpectedTypeInfoImpl> types = new ArrayList<ExpectedTypeInfoImpl>();
            for (PsiField field : fields) {
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)field, (PsiElement)expression, aClass)) continue;
                PsiClassType type = facade.getElementFactory().createType(aClass);
                int kind = field.hasModifierProperty("static") || field.hasModifierProperty("final") || field.hasModifierProperty("private") ? 0 : 1;
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)type, kind, (PsiType)type, TailType.DOT);
                types.add(info);
            }
            return types.toArray(new ExpectedTypeInfo[types.size()]);
        }
    }
}

