/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.run.IdeaLicenseHelper;
import org.jetbrains.idea.devkit.run.PluginRunConfigurationEditor;

public class PluginRunConfiguration
extends RunConfigurationBase
implements ModuleRunConfiguration {
    private Module myModule;
    private String myModuleName;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String MODULE = "module";

    public PluginRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new PluginRunConfigurationEditor(this);
    }

    public JDOMExternalizable createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    public SettingsEditor<JDOMExternalizable> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/run/PluginRunConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/run/PluginRunConfiguration.getState must not be null");
        }
        if (this.getModule() == null) {
            throw new ExecutionException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        Sdk jdk = rootManager.getSdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule((Module)this.getModule());
        }
        final Sdk ideaJdk = IdeaJdk.findIdeaJdk(jdk);
        if (ideaJdk == null) {
            throw new ExecutionException(DevKitBundle.message("jdk.type.incorrect.common", new Object[0]));
        }
        String sandboxHome = ((Sandbox)ideaJdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome == null) {
            throw new ExecutionException(DevKitBundle.message("sandbox.no.configured", new Object[0]));
        }
        try {
            sandboxHome = new File(sandboxHome).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ExecutionException(DevKitBundle.message("sandbox.no.configured", new Object[0]));
        }
        final String canonicalSandbox = sandboxHome;
        IdeaLicenseHelper.copyIDEALicencse(sandboxHome, ideaJdk);
        JavaCommandLineState state = new JavaCommandLineState(env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                JavaParameters params = new JavaParameters();
                ParametersList vm = params.getVMParametersList();
                PluginRunConfiguration.fillParameterList(vm, PluginRunConfiguration.this.VM_PARAMETERS);
                PluginRunConfiguration.fillParameterList(params.getProgramParametersList(), PluginRunConfiguration.this.PROGRAM_PARAMETERS);
                String libPath = ideaJdk.getHomePath() + File.separator + "lib";
                vm.add("-Xbootclasspath/a:" + libPath + File.separator + "boot.jar");
                vm.defineProperty("idea.config.path", canonicalSandbox + File.separator + "config");
                vm.defineProperty("idea.system.path", canonicalSandbox + File.separator + "system");
                vm.defineProperty("idea.plugins.path", canonicalSandbox + File.separator + "plugins");
                if (SystemInfo.isMac) {
                    vm.defineProperty("idea.smooth.progress", "false");
                    vm.defineProperty("apple.laf.useScreenMenuBar", "true");
                }
                params.setWorkingDirectory(ideaJdk.getHomePath() + File.separator + "bin" + File.separator);
                params.setJdk(ideaJdk);
                params.getClassPath().addFirst(libPath + File.separator + "log4j.jar");
                params.getClassPath().addFirst(libPath + File.separator + "jdom.jar");
                params.getClassPath().addFirst(libPath + File.separator + "openapi.jar");
                params.getClassPath().addFirst(libPath + File.separator + "util.jar");
                params.getClassPath().addFirst(libPath + File.separator + "extensions.jar");
                params.getClassPath().addFirst(libPath + File.separator + "bootstrap.jar");
                params.getClassPath().addFirst(libPath + File.separator + "idea.jar");
                params.getClassPath().addFirst(libPath + File.separator + "idea_rt.jar");
                params.getClassPath().addFirst(((JavaSdkType)ideaJdk.getSdkType()).getToolsPath(ideaJdk));
                params.setMainClass("com.intellij.idea.Main");
                return params;
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject()));
        return state;
    }

    private static void fillParameterList(ParametersList list, String value) {
        String[] parameters = value != null ? value.split(" ") : null;
        for (int i = 0; parameters != null && i < parameters.length; ++i) {
            if (parameters[i] == null || parameters[i].length() <= 0) continue;
            list.add(parameters[i]);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getModule() == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        String moduleName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return PluginRunConfiguration.this.getModule().getName();
            }
        });
        if (ModuleManager.getInstance((Project)this.getProject()).findModuleByName(moduleName) == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        Sdk jdk = rootManager.getSdk();
        if (jdk == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("jdk.no.specified", moduleName));
        }
        if (IdeaJdk.findIdeaJdk(jdk) == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("jdk.type.incorrect", moduleName));
        }
    }

    @NotNull
    public Module[] getModules() {
        Module[] allModules;
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : allModules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (module.getModuleType() != PluginModuleType.getInstance()) continue;
            modules.add(module);
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/run/PluginRunConfiguration.getModules must not return null");
        }
        return moduleArray;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element module = element.getChild(MODULE);
        if (module != null) {
            this.myModuleName = module.getAttributeValue(NAME);
        }
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        super.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element moduleElement = new Element(MODULE);
        moduleElement.setAttribute(NAME, (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Module module = PluginRunConfiguration.this.getModule();
                return module != null ? module.getName() : (PluginRunConfiguration.this.myModuleName != null ? PluginRunConfiguration.this.myModuleName : "");
            }
        }));
        element.addContent(moduleElement);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        super.writeExternal(element);
    }

    @Nullable
    public Module getModule() {
        if (this.myModule == null && this.myModuleName != null) {
            this.myModule = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    public void setModule(Module module) {
        this.myModule = module;
    }
}

